/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.shared.impl;

import com.google.web.bindery.autobean.shared.AutoBean;
import com.google.web.bindery.autobean.shared.AutoBeanUtils;
import com.google.web.bindery.autobean.shared.Splittable;
import com.google.web.bindery.autobean.shared.ValueCodex;
import com.google.web.bindery.autobean.shared.impl.StringQuoter;
import com.google.web.bindery.requestfactory.shared.BaseProxy;
import com.google.web.bindery.requestfactory.shared.EntityProxyId;
import com.google.web.bindery.requestfactory.shared.impl.BaseProxyCategory;
import com.google.web.bindery.requestfactory.shared.impl.Poser;
import com.google.web.bindery.requestfactory.shared.impl.SimpleProxyId;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EntityCodex {
    public static Object decode(EntitySource source, Class<?> type, Class<?> elementType, Splittable split) {
        if (split == null || split == Splittable.NULL) {
            return null;
        }
        if (elementType != null) {
            AbstractCollection collection = null;
            if (List.class.equals(type)) {
                collection = new ArrayList();
            } else if (Set.class.equals(type)) {
                collection = new HashSet();
            } else {
                throw new UnsupportedOperationException();
            }
            if (ValueCodex.canDecode(elementType)) {
                int j = split.size();
                for (int i = 0; i < j; ++i) {
                    if (split.isNull(i)) {
                        collection.add(null);
                        continue;
                    }
                    Object element = ValueCodex.decode(elementType, split.get(i));
                    collection.add(element);
                }
            } else {
                int j = split.size();
                for (int i = 0; i < j; ++i) {
                    if (split.isNull(i)) {
                        collection.add(null);
                        continue;
                    }
                    Object element = EntityCodex.decode(source, elementType, null, split.get(i));
                    collection.add(element);
                }
            }
            return collection;
        }
        if (source.isEntityType(type) || source.isValueType(type) || EntityProxyId.class.equals(type)) {
            return source.getBeanForPayload(split).as();
        }
        return ValueCodex.decode(type, split);
    }

    public static Object decode(EntitySource source, Class<?> type, Class<?> elementType, String jsonPayload) {
        Splittable split = StringQuoter.split(jsonPayload);
        return EntityCodex.decode(source, type, elementType, split);
    }

    public static Object decode(EntitySource source, Class<?> type, Class<?> keyType, Class<?> valueType, Splittable split) {
        if (split == null || split == Splittable.NULL) {
            return null;
        }
        if (!Map.class.equals(type)) {
            throw new UnsupportedOperationException();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (ValueCodex.canDecode(keyType) || !split.isIndexed()) {
            List<String> keys = split.getPropertyKeys();
            for (String propertyKey : keys) {
                String key;
                String string = key = keyType == String.class ? propertyKey : ValueCodex.decode(keyType, StringQuoter.split(propertyKey));
                if (split.isNull(propertyKey)) {
                    map.put(key, null);
                    continue;
                }
                Splittable valueSplit = split.get(propertyKey);
                Object value = null;
                value = ValueCodex.canDecode(valueType) ? (Object)ValueCodex.decode(valueType, valueSplit) : EntityCodex.decode(source, valueType, null, valueSplit);
                map.put(key, value);
            }
        } else {
            if (split.size() != 2) {
                throw new UnsupportedOperationException();
            }
            List keys = (List)EntityCodex.decode(source, List.class, keyType, split.get(0));
            List values = (List)EntityCodex.decode(source, List.class, valueType, split.get(1));
            if (keys.size() != values.size()) {
                throw new UnsupportedOperationException();
            }
            int size = keys.size();
            for (int i = 0; i < size; ++i) {
                map.put((String)keys.get(i), values.get(i));
            }
        }
        return map;
    }

    public static Splittable encode(EntitySource source, Object value) {
        if (value == null) {
            return Splittable.NULL;
        }
        if (value instanceof Poser) {
            value = ((Poser)((Object)value)).getPosedValue();
        }
        if (value instanceof Iterable) {
            StringBuilder toReturn = new StringBuilder("[");
            boolean first = true;
            for (Object val : (Iterable)((Object)value)) {
                if (!first) {
                    toReturn.append(',');
                } else {
                    first = false;
                }
                if (val == null) {
                    toReturn.append("null");
                    continue;
                }
                toReturn.append(EntityCodex.encode(source, val).getPayload());
            }
            toReturn.append(']');
            return StringQuoter.split(toReturn.toString());
        }
        if (value instanceof Map) {
            boolean isSimpleMap;
            Map map = (Map)((Object)value);
            StringBuilder sb = new StringBuilder();
            if (map.containsKey(null)) {
                throw new IllegalArgumentException("null Map keys are not supported");
            }
            boolean bl = isSimpleMap = map.isEmpty() || ValueCodex.canDecode(map.keySet().iterator().next().getClass());
            if (isSimpleMap) {
                boolean first = true;
                sb.append("{");
                for (Map.Entry entry : map.entrySet()) {
                    Object mapKey = entry.getKey();
                    if (mapKey == null) continue;
                    Object mapValue = entry.getValue();
                    if (first) {
                        first = false;
                    } else {
                        sb.append(",");
                    }
                    String encodedKey = mapKey.getClass() == String.class ? (String)mapKey : EntityCodex.encode(source, mapKey).getPayload();
                    sb.append(StringQuoter.quote(encodedKey));
                    sb.append(":");
                    if (mapValue == null) {
                        sb.append("null");
                        continue;
                    }
                    sb.append(EntityCodex.encode(source, mapValue).getPayload());
                }
                sb.append("}");
            } else {
                ArrayList keys = new ArrayList(map.size());
                ArrayList values = new ArrayList(map.size());
                for (Map.Entry entry : map.entrySet()) {
                    keys.add(entry.getKey());
                    values.add(entry.getValue());
                }
                sb.append("[");
                sb.append(EntityCodex.encode(source, keys).getPayload());
                sb.append(",");
                sb.append(EntityCodex.encode(source, values).getPayload());
                sb.append("]");
            }
            return StringQuoter.split(sb.toString());
        }
        if (value instanceof BaseProxy) {
            AutoBean autoBean = AutoBeanUtils.getAutoBean((BaseProxy)((Object)value));
            value = BaseProxyCategory.stableId(autoBean);
        }
        if (value instanceof SimpleProxyId) {
            return source.getSerializedProxyId(value);
        }
        return ValueCodex.encode(value);
    }

    public static interface EntitySource {
        public <Q extends BaseProxy> AutoBean<Q> getBeanForPayload(Splittable var1);

        public Splittable getSerializedProxyId(SimpleProxyId<?> var1);

        public boolean isEntityType(Class<?> var1);

        public boolean isValueType(Class<?> var1);
    }
}

