/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.services.uow;

import java.util.function.Consumer;
import org.kie.kogito.uow.WorkUnit;

public class BaseWorkUnit<T>
implements WorkUnit<T> {
    private T data;
    private Consumer<T> action;
    private Consumer<T> compensation;
    private Integer priority;

    public BaseWorkUnit(T data, Consumer<T> action) {
        this(data, action, null);
    }

    public BaseWorkUnit(T data, Consumer<T> action, Consumer<T> compensation) {
        this(data, action, compensation, 100);
    }

    public BaseWorkUnit(T data, Consumer<T> action, Consumer<T> compensation, Integer priority) {
        this.data = data;
        this.action = action;
        this.compensation = compensation;
        this.priority = priority;
    }

    public T data() {
        return this.data;
    }

    public Integer priority() {
        return this.priority;
    }

    public void perform() {
        this.action.accept(this.data());
    }

    public void abort() {
        if (this.compensation != null) {
            this.compensation.accept(this.data());
        }
    }
}

