/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.pmml;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.api.pmml.PMML4Result;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.kogito.pmml.utils.PMMLUtils;
import org.kie.memorycompiler.KieMemoryCompiler;
import org.kie.pmml.api.PMMLRuntimeFactory;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.models.PMMLModel;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.api.runtime.PMMLRuntimeContext;
import org.kie.pmml.evaluator.core.PMMLRuntimeContextImpl;
import org.kie.pmml.evaluator.core.service.PMMLRuntimeInternalImpl;
import org.kie.pmml.evaluator.utils.SPIUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMMLKogito {
    private static final PMMLRuntimeFactory PMML_RUNTIME_FACTORY = SPIUtils.getPMMLRuntimeFactory((boolean)false);
    private static final Logger logger = LoggerFactory.getLogger(PMMLKogito.class);

    private PMMLKogito() {
    }

    public static Map<String, PMMLRuntime> createPMMLRuntimes(String ... pmmlPaths) {
        HashMap<String, PMMLRuntime> toReturn = new HashMap<String, PMMLRuntime>();
        Stream.of(pmmlPaths).forEach(pmmlPath -> toReturn.put((String)pmmlPath, PMMLKogito.getPMMLRuntimeAlreadyCompiled()));
        return toReturn;
    }

    public static PMMLModel modelByName(PMMLRuntime pmmlRuntime, String fileName, String modelName) {
        logger.debug("modelByName {} {} {}", new Object[]{pmmlRuntime, fileName, modelName});
        PMMLRequestData pmmlRequestData = PMMLUtils.getPMMLRequestData(modelName);
        PMMLRuntimeContext runtimeContext = PMMLKogito.getPMMLRuntimeContext(pmmlRequestData, fileName);
        List allPmmlModels = pmmlRuntime.getPMMLModels(runtimeContext);
        logger.debug("allPmmlModels {}", (Object)allPmmlModels);
        List modelsWithName = allPmmlModels.stream().filter(m -> modelName.equals(m.getName())).collect(Collectors.toList());
        if (modelsWithName.size() == 1) {
            return (PMMLModel)modelsWithName.get(0);
        }
        String errorMessage = String.format("Wrong number of model(s) with name '%s': %s", modelName, modelsWithName.size());
        throw new KiePMMLException(errorMessage);
    }

    public static PMML4Result evaluate(PMMLRuntime pmmlRuntime, String fileName, String modelName, Map<String, Object> pmmlInputData) {
        PMMLRequestData pmmlRequestData = PMMLUtils.getPMMLRequestData(modelName, pmmlInputData);
        return pmmlRuntime.evaluate(modelName, PMMLKogito.getPMMLRuntimeContext(pmmlRequestData, fileName));
    }

    private static PMMLRuntimeContext getPMMLRuntimeContext(PMMLRequestData pmmlRequestData, String fileName) {
        KieMemoryCompiler.MemoryCompilerClassLoader memoryCompilerClassLoader = new KieMemoryCompiler.MemoryCompilerClassLoader(Thread.currentThread().getContextClassLoader());
        return new PMMLRuntimeContextImpl(pmmlRequestData, fileName, memoryCompilerClassLoader);
    }

    private static PMMLRuntime getPMMLRuntimeAlreadyCompiled() {
        return new PMMLRuntimeInternalImpl();
    }

    private static PMMLRuntime getPMMLRuntimeWithInMemoryCompilation(File pmmlFile) {
        return PMML_RUNTIME_FACTORY.getPMMLRuntimeFromFile(pmmlFile);
    }
}

