/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.expr.jq;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.Output;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.javacc.ExpressionParser;
import net.thisptr.jackson.jq.internal.tree.FunctionCall;
import net.thisptr.jackson.jq.internal.tree.StringInterpolation;
import net.thisptr.jackson.jq.internal.tree.binaryop.BinaryOperatorExpression;
import org.kie.kogito.internal.process.runtime.KogitoProcessContext;
import org.kie.kogito.jackson.utils.FunctionJsonNode;
import org.kie.kogito.jackson.utils.JsonObjectUtils;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;
import org.kie.kogito.jackson.utils.PrefixJsonNode;
import org.kie.kogito.serverless.workflow.utils.ExpressionHandlerUtils;
import org.kie.kogito.serverless.workflow.utils.JsonNodeContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JqExpression
implements org.kie.kogito.process.expr.Expression {
    static final String LANG = "jq";
    private static final Logger logger = LoggerFactory.getLogger(JqExpression.class);
    private final Map<Class<? extends Expression>, Collection<Field>> declaredFieldsMap = new ConcurrentHashMap<Class<? extends Expression>, Collection<Field>>();
    private final Map<Class<? extends Expression>, Collection<Field>> allFieldsMap = new ConcurrentHashMap<Class<? extends Expression>, Collection<Field>>();
    private final Supplier<Scope> scope;
    private final String expr;
    private Expression internalExpr;
    private JsonQueryException validationError;
    private static Field rhsField;

    public JqExpression(Supplier<Scope> scope, String expr, Version version) {
        this.expr = expr;
        this.scope = scope;
        try {
            this.internalExpr = this.compile(version);
            this.checkFunctionCall(this.internalExpr);
        }
        catch (JsonQueryException ex) {
            this.validationError = ex;
        }
    }

    private Expression compile(Version version) throws JsonQueryException {
        Expression expression;
        try {
            expression = ExpressionParser.compile((String)this.expr, (Version)version);
        }
        catch (JsonQueryException ex) {
            expression = this.handleStringInterpolation(version).orElseThrow(() -> ex);
        }
        this.checkFunctionCall(expression);
        return expression;
    }

    private Optional<Expression> handleStringInterpolation(Version version) {
        if (!this.expr.startsWith("\"")) {
            try {
                Expression expression = ExpressionParser.compile((String)("\"" + this.expr + "\""), (Version)version);
                if (expression instanceof StringInterpolation) {
                    return Optional.of(expression);
                }
            }
            catch (JsonQueryException jsonQueryException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    private TypedOutput output(Class<?> returnClass) {
        TypedOutput out = String.class.isAssignableFrom(returnClass) ? new StringOutput() : (Collection.class.isAssignableFrom(returnClass) ? new CollectionOutput() : new JsonNodeOutput());
        return out;
    }

    public <T> T eval(Object target, Class<T> returnClass, KogitoProcessContext context) {
        return this.eval(JsonObjectUtils.fromValue((Object)target), returnClass, context);
    }

    public void assign(Object target, Object value, KogitoProcessContext context) {
        JsonNode targetNode = JsonObjectUtils.fromValue((Object)target);
        ExpressionHandlerUtils.assign((JsonNode)targetNode, (JsonNode)this.eval(targetNode, JsonNode.class, context), (JsonNode)JsonObjectUtils.fromValue((Object)value), (String)this.expr);
    }

    private Scope getScope(KogitoProcessContext processInfo) {
        Scope childScope = Scope.newChildScope((Scope)this.scope.get());
        childScope.setValue("SECRET", (JsonNode)new PrefixJsonNode(ExpressionHandlerUtils::getOptionalSecret));
        childScope.setValue("WORKFLOW", (JsonNode)new FunctionJsonNode(ExpressionHandlerUtils.getContextFunction((KogitoProcessContext)processInfo)));
        childScope.setValue("CONST", ExpressionHandlerUtils.getConstants((KogitoProcessContext)processInfo));
        return childScope;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T eval(JsonNode context, Class<T> returnClass, KogitoProcessContext processInfo) {
        if (this.validationError != null) {
            throw new IllegalArgumentException("Unable to evaluate content " + context + " using expr " + this.expr, this.validationError);
        }
        TypedOutput output = this.output(returnClass);
        try (JsonNodeContext jsonNode = JsonNodeContext.from((JsonNode)context, (KogitoProcessContext)processInfo);){
            this.internalExpr.apply(this.getScope(processInfo), jsonNode.getNode(), (Output)output);
            Object object = JsonObjectUtils.convertValue((Object)output.getResult(), returnClass);
            return (T)object;
        }
        catch (JsonQueryException e) {
            throw new IllegalArgumentException("Unable to evaluate content " + context + " using expr " + this.expr, e);
        }
    }

    public boolean isValid() {
        return this.validationError == null;
    }

    private void checkFunctionCall(Expression toCheck) throws JsonQueryException {
        if (toCheck instanceof FunctionCall) {
            toCheck.apply(this.scope.get(), (JsonNode)ObjectMapperFactory.get().createObjectNode(), out -> {});
        } else if (toCheck instanceof BinaryOperatorExpression) {
            if (rhsField != null) {
                try {
                    this.checkFunctionCall((Expression)rhsField.get(toCheck));
                }
                catch (ReflectiveOperationException e) {
                    logger.warn("Ignoring unexpected error {} while accesing field {} for class{} and expression {}", new Object[]{e.getMessage(), rhsField.getName(), toCheck.getClass(), this.expr});
                }
            }
        } else if (toCheck != null) {
            for (Field f : this.getAllExprFields(toCheck)) {
                try {
                    this.checkFunctionCall((Expression)f.get(toCheck));
                }
                catch (ReflectiveOperationException e) {
                    logger.warn("Ignoring unexpected error {} while accesing field {} for class{} and expression {}", new Object[]{e.getMessage(), f.getName(), toCheck.getClass(), this.expr});
                }
            }
        }
    }

    private Collection<Field> getAllExprFields(Expression toCheck) {
        return this.allFieldsMap.computeIfAbsent(toCheck.getClass(), this::getAllExprFields);
    }

    private Collection<Field> getAllExprFields(Class<? extends Expression> clazz) {
        HashSet<Field> fields = new HashSet<Field>();
        Class<? extends Expression> currentClass = clazz;
        do {
            fields.addAll(this.declaredFieldsMap.computeIfAbsent(currentClass.asSubclass(Expression.class), this::getDeclaredExprFields));
        } while (Expression.class.isAssignableFrom(currentClass = currentClass.getSuperclass()));
        return fields;
    }

    private Collection<Field> getDeclaredExprFields(Class<? extends Expression> clazz) {
        HashSet<Field> fields = new HashSet<Field>();
        for (Field f : clazz.getDeclaredFields()) {
            if (!Expression.class.isAssignableFrom(f.getType())) continue;
            f.setAccessible(true);
            fields.add(f);
        }
        return fields;
    }

    public String asString() {
        return this.expr;
    }

    public Exception validationError() {
        return this.validationError;
    }

    public String lang() {
        return LANG;
    }

    static {
        try {
            rhsField = BinaryOperatorExpression.class.getDeclaredField("rhs");
            rhsField.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            logger.warn("Unexpected exception while resolving rhs field", (Throwable)e);
        }
    }

    private static class StringOutput
    implements TypedOutput {
        StringBuilder sb = new StringBuilder();

        private StringOutput() {
        }

        public void emit(JsonNode out) throws JsonQueryException {
            if (this.sb.length() > 0) {
                this.sb.append(' ');
            }
            this.sb.append(out.asText());
        }

        @Override
        public Object getResult() {
            return this.sb.toString();
        }
    }

    private static class CollectionOutput
    implements TypedOutput {
        Collection<Object> result = new ArrayList<Object>();

        private CollectionOutput() {
        }

        public void emit(JsonNode out) throws JsonQueryException {
            Object obj = JsonObjectUtils.toJavaValue((JsonNode)out);
            if (obj instanceof Collection) {
                this.result.addAll((Collection)obj);
            } else {
                this.result.add(obj);
            }
        }

        @Override
        public Object getResult() {
            return this.result;
        }
    }

    private static class JsonNodeOutput
    implements TypedOutput {
        private JsonNode result;
        private boolean arrayCreated;

        private JsonNodeOutput() {
        }

        public void emit(JsonNode out) throws JsonQueryException {
            if (this.result == null) {
                this.result = out;
            } else if (!this.arrayCreated) {
                ArrayNode newNode = ObjectMapperFactory.get().createArrayNode();
                newNode.add(this.result).add(out);
                this.result = newNode;
                this.arrayCreated = true;
            } else {
                ((ArrayNode)this.result).add(out);
            }
        }

        public JsonNode getResult() {
            return this.result;
        }
    }

    private static interface TypedOutput
    extends Output {
        public Object getResult();
    }
}

