/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jackson.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.function.Function;
import java.util.function.Supplier;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;

public class JsonNodeConverter
implements Function<String, JsonNode> {
    private Supplier<ObjectMapper> objectMapper;

    public JsonNodeConverter() {
        this(ObjectMapperFactory::get);
    }

    public JsonNodeConverter(Supplier<ObjectMapper> mapper) {
        this.objectMapper = mapper;
    }

    @Override
    public JsonNode apply(String t) {
        try {
            return this.objectMapper.get().readTree(t);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Invalid value for json node " + t);
        }
    }
}

