/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.api.io;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.kie.api.io.Resource;

public class CollectedResource {
    private final Path basePath;
    private final Resource resource;

    public CollectedResource(Path basePath, Resource resource) {
        try {
            if (!basePath.toString().endsWith(".jar") && !Paths.get(resource.getSourcePath(), new String[0]).toAbsolutePath().toRealPath(new LinkOption[0]).startsWith(basePath.toAbsolutePath().toRealPath(new LinkOption[0]))) {
                throw new IllegalArgumentException(String.format("basePath %s is not a prefix to the resource sourcePath %s", basePath, resource.getSourcePath()));
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Could not determine if basePath %s is a prefix to the resource sourcePath %s", basePath, resource.getSourcePath()), e);
        }
        this.basePath = basePath;
        this.resource = resource;
    }

    public Path basePath() {
        return this.basePath;
    }

    public Resource resource() {
        return this.resource;
    }
}

