/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.event;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.jbpm.process.instance.event.KogitoProcessNodeLeftEventImpl;
import org.jbpm.process.instance.event.KogitoProcessNodeTriggeredEventImpl;
import org.jbpm.process.instance.event.KogitoProcessVariableChangedEventImpl;
import org.jbpm.process.instance.event.KogitoProcessWorkItemTransitionEventImpl;
import org.jbpm.process.instance.event.MessageEventImpl;
import org.jbpm.process.instance.event.ProcessCompletedEventImpl;
import org.jbpm.process.instance.event.ProcessStartedEventImpl;
import org.jbpm.process.instance.event.SLAViolatedEventImpl;
import org.jbpm.process.instance.event.SignalEventImpl;
import org.jbpm.process.instance.event.UserTaskAssignmentEventImpl;
import org.jbpm.process.instance.event.UserTaskAttachmentEventImpl;
import org.jbpm.process.instance.event.UserTaskCommentEventImpl;
import org.jbpm.process.instance.event.UserTaskDeadlineEventImpl;
import org.jbpm.process.instance.event.UserTaskStateEventImpl;
import org.jbpm.process.instance.event.UserTaskVariableEventImpl;
import org.jbpm.workflow.instance.node.HumanTaskNodeInstance;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.api.event.usertask.UserTaskAssignmentEvent;
import org.kie.api.event.usertask.UserTaskAttachmentEvent;
import org.kie.api.event.usertask.UserTaskCommentEvent;
import org.kie.api.event.usertask.UserTaskDeadlineEvent;
import org.kie.api.event.usertask.UserTaskStateEvent;
import org.kie.api.event.usertask.UserTaskVariableEvent;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.runtime.Closeable;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.internal.process.event.KogitoProcessEventListener;
import org.kie.kogito.internal.process.event.KogitoProcessEventSupport;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.process.workitem.Attachment;
import org.kie.kogito.process.workitem.Comment;
import org.kie.kogito.process.workitem.HumanTaskWorkItem;
import org.kie.kogito.process.workitem.Transition;

public class KogitoProcessEventSupportImpl
implements KogitoProcessEventSupport {
    private final List<KogitoProcessEventListener> listeners = new CopyOnWriteArrayList<KogitoProcessEventListener>();
    private final IdentityProvider identityProvider;

    public KogitoProcessEventSupportImpl(IdentityProvider identityProvider) {
        this.identityProvider = identityProvider;
    }

    private void notifyAllListeners(Consumer<KogitoProcessEventListener> consumer) {
        this.listeners.forEach(l -> consumer.accept((KogitoProcessEventListener)l));
    }

    public final synchronized void addEventListener(KogitoProcessEventListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public final void removeEventListener(KogitoProcessEventListener listener) {
        this.listeners.remove(listener);
    }

    public List<KogitoProcessEventListener> getEventListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    private void clear() {
        this.listeners.forEach(l -> {
            if (l instanceof Closeable) {
                ((Closeable)l).close();
            }
        });
        this.listeners.clear();
    }

    public void fireBeforeProcessStarted(KogitoProcessInstance instance, KieRuntime kruntime) {
        ProcessStartedEventImpl event = new ProcessStartedEventImpl((ProcessInstance)instance, kruntime, this.identityProvider.getName());
        this.notifyAllListeners(l -> l.beforeProcessStarted(event));
    }

    public void fireAfterProcessStarted(KogitoProcessInstance instance, KieRuntime kruntime) {
        ProcessStartedEventImpl event = new ProcessStartedEventImpl((ProcessInstance)instance, kruntime, this.identityProvider.getName());
        this.notifyAllListeners(l -> l.afterProcessStarted(event));
    }

    public void fireBeforeProcessCompleted(KogitoProcessInstance instance, KieRuntime kruntime) {
        ProcessCompletedEventImpl event = new ProcessCompletedEventImpl((ProcessInstance)instance, kruntime, this.identityProvider.getName());
        this.notifyAllListeners(l -> l.beforeProcessCompleted(event));
    }

    public void fireAfterProcessCompleted(KogitoProcessInstance instance, KieRuntime kruntime) {
        ProcessCompletedEventImpl event = new ProcessCompletedEventImpl((ProcessInstance)instance, kruntime, this.identityProvider.getName());
        this.notifyAllListeners(l -> l.afterProcessCompleted(event));
    }

    public void fireBeforeNodeTriggered(KogitoNodeInstance nodeInstance, KieRuntime kruntime) {
        KogitoProcessNodeTriggeredEventImpl event = new KogitoProcessNodeTriggeredEventImpl((NodeInstance)nodeInstance, kruntime, this.identityProvider.getName());
        this.notifyAllListeners(l -> l.beforeNodeTriggered(event));
    }

    public void fireAfterNodeTriggered(KogitoNodeInstance nodeInstance, KieRuntime kruntime) {
        KogitoProcessNodeTriggeredEventImpl event = new KogitoProcessNodeTriggeredEventImpl((NodeInstance)nodeInstance, kruntime, this.identityProvider.getName());
        this.notifyAllListeners(l -> l.afterNodeTriggered(event));
    }

    public void fireBeforeNodeLeft(KogitoNodeInstance nodeInstance, KieRuntime kruntime) {
        KogitoProcessNodeLeftEventImpl event = new KogitoProcessNodeLeftEventImpl((NodeInstance)nodeInstance, kruntime, this.identityProvider.getName());
        this.notifyAllListeners(l -> l.beforeNodeLeft(event));
    }

    public void fireAfterNodeLeft(KogitoNodeInstance nodeInstance, KieRuntime kruntime) {
        KogitoProcessNodeLeftEventImpl event = new KogitoProcessNodeLeftEventImpl((NodeInstance)nodeInstance, kruntime, this.identityProvider.getName());
        this.notifyAllListeners(l -> l.afterNodeLeft(event));
    }

    public void fireBeforeVariableChanged(String id, String instanceId, Object oldValue, Object newValue, List<String> tags, KogitoProcessInstance processInstance, KogitoNodeInstance nodeInstance, KieRuntime kruntime) {
        KogitoProcessVariableChangedEventImpl event = new KogitoProcessVariableChangedEventImpl(id, instanceId, oldValue, newValue, tags, (ProcessInstance)processInstance, nodeInstance, kruntime, this.identityProvider.getName());
        this.notifyAllListeners(arg_0 -> KogitoProcessEventSupportImpl.lambda$fireBeforeVariableChanged$10((ProcessVariableChangedEvent)event, arg_0));
    }

    public void fireAfterVariableChanged(String name, String id, Object oldValue, Object newValue, List<String> tags, KogitoProcessInstance processInstance, KogitoNodeInstance nodeInstance, KieRuntime kruntime) {
        KogitoProcessVariableChangedEventImpl event = new KogitoProcessVariableChangedEventImpl(name, id, oldValue, newValue, tags, (ProcessInstance)processInstance, nodeInstance, kruntime, this.identityProvider.getName());
        this.notifyAllListeners(arg_0 -> KogitoProcessEventSupportImpl.lambda$fireAfterVariableChanged$11((ProcessVariableChangedEvent)event, arg_0));
    }

    public void fireBeforeSLAViolated(KogitoProcessInstance instance, KieRuntime kruntime) {
        SLAViolatedEventImpl event = new SLAViolatedEventImpl((ProcessInstance)instance, kruntime, this.identityProvider.getName());
        this.notifyAllListeners(l -> l.beforeSLAViolated(event));
    }

    public void fireAfterSLAViolated(KogitoProcessInstance instance, KieRuntime kruntime) {
        SLAViolatedEventImpl event = new SLAViolatedEventImpl((ProcessInstance)instance, kruntime, this.identityProvider.getName());
        this.notifyAllListeners(l -> l.afterSLAViolated(event));
    }

    public void fireBeforeSLAViolated(KogitoProcessInstance instance, KogitoNodeInstance nodeInstance, KieRuntime kruntime) {
        SLAViolatedEventImpl event = new SLAViolatedEventImpl((ProcessInstance)instance, (NodeInstance)nodeInstance, kruntime, this.identityProvider.getName());
        this.notifyAllListeners(l -> l.beforeSLAViolated(event));
    }

    public void fireAfterSLAViolated(KogitoProcessInstance instance, KogitoNodeInstance nodeInstance, KieRuntime kruntime) {
        SLAViolatedEventImpl event = new SLAViolatedEventImpl((ProcessInstance)instance, (NodeInstance)nodeInstance, kruntime, this.identityProvider.getName());
        this.notifyAllListeners(l -> l.afterSLAViolated(event));
    }

    public void fireBeforeWorkItemTransition(KogitoProcessInstance instance, KogitoWorkItem workitem, Transition<?> transition, KieRuntime kruntime) {
        KogitoProcessWorkItemTransitionEventImpl event = new KogitoProcessWorkItemTransitionEventImpl((ProcessInstance)instance, workitem, transition, kruntime, false, this.identityProvider.getName());
        this.notifyAllListeners(l -> l.beforeWorkItemTransition(event));
    }

    public void fireAfterWorkItemTransition(KogitoProcessInstance instance, KogitoWorkItem workitem, Transition<?> transition, KieRuntime kruntime) {
        KogitoProcessWorkItemTransitionEventImpl event = new KogitoProcessWorkItemTransitionEventImpl((ProcessInstance)instance, workitem, transition, kruntime, true, this.identityProvider.getName());
        this.notifyAllListeners(l -> l.afterWorkItemTransition(event));
    }

    public void fireOnSignal(KogitoProcessInstance instance, KogitoNodeInstance nodeInstance, KieRuntime kruntime, String signalName, Object signalObject) {
        SignalEventImpl event = new SignalEventImpl((ProcessInstance)instance, kruntime, (NodeInstance)nodeInstance, signalName, signalObject, this.identityProvider.getName());
        this.notifyAllListeners(l -> l.onSignal(event));
    }

    public void fireOnMessage(KogitoProcessInstance instance, KogitoNodeInstance nodeInstance, KieRuntime kruntime, String messageName, Object messageObject) {
        MessageEventImpl event = new MessageEventImpl((ProcessInstance)instance, kruntime, (NodeInstance)nodeInstance, messageName, messageObject, this.identityProvider.getName());
        this.notifyAllListeners(l -> l.onMessage(event));
    }

    public void fireOnUserTaskNotStartedDeadline(KogitoProcessInstance instance, KogitoNodeInstance nodeInstance, HumanTaskWorkItem workItem, Map<String, Object> notification, KieRuntime kruntime) {
        this.fireUserTaskNotification(instance, nodeInstance, workItem, notification, UserTaskDeadlineEvent.DeadlineType.Started, kruntime);
    }

    public void fireOnUserTaskNotCompletedDeadline(KogitoProcessInstance instance, KogitoNodeInstance nodeInstance, HumanTaskWorkItem workItem, Map<String, Object> notification, KieRuntime kruntime) {
        this.fireUserTaskNotification(instance, nodeInstance, workItem, notification, UserTaskDeadlineEvent.DeadlineType.Completed, kruntime);
    }

    private void fireUserTaskNotification(KogitoProcessInstance instance, KogitoNodeInstance nodeInstance, HumanTaskWorkItem workItem, Map<String, Object> notification, UserTaskDeadlineEvent.DeadlineType type, KieRuntime kruntime) {
        UserTaskDeadlineEventImpl event = new UserTaskDeadlineEventImpl((ProcessInstance)instance, (HumanTaskNodeInstance)nodeInstance, workItem, notification, type, kruntime, this.identityProvider.getName());
        this.notifyAllListeners(l -> l.onUserTaskDeadline(event));
    }

    public void fireOneUserTaskStateChange(KogitoProcessInstance instance, KogitoNodeInstance nodeInstance, KieRuntime kruntime, String oldStatus, String newStatus) {
        UserTaskStateEventImpl event = new UserTaskStateEventImpl((ProcessInstance)instance, (HumanTaskNodeInstance)nodeInstance, kruntime, this.identityProvider.getName());
        event.setOldStatus(oldStatus);
        event.setNewStatus(newStatus);
        this.notifyAllListeners(l -> l.onUserTaskState((UserTaskStateEvent)event));
    }

    public void fireOnUserTaskAssignmentChange(KogitoProcessInstance instance, KogitoNodeInstance nodeInstance, KieRuntime kruntime, KogitoProcessEventSupport.AssignmentType assignmentType, Set<String> oldUsersId, Set<String> newUsersId) {
        UserTaskAssignmentEventImpl event = new UserTaskAssignmentEventImpl((ProcessInstance)instance, (HumanTaskNodeInstance)nodeInstance, kruntime, this.identityProvider.getName());
        event.setAssignmentType(assignmentType.name());
        event.setOldUsersId(oldUsersId);
        event.setNewUsersId(newUsersId);
        this.notifyAllListeners(l -> l.onUserTaskAssignment((UserTaskAssignmentEvent)event));
    }

    public void fireOnUserTaskInputVariableChange(KogitoProcessInstance instance, KogitoNodeInstance nodeInstance, KieRuntime kruntime, String variableName, Object newValue, Object oldValue) {
        UserTaskVariableEventImpl event = new UserTaskVariableEventImpl((ProcessInstance)instance, (HumanTaskNodeInstance)nodeInstance, kruntime, this.identityProvider.getName());
        event.setVariableName(variableName);
        event.setOldValue(oldValue);
        event.setNewValue(newValue);
        event.setVariableType(UserTaskVariableEvent.VariableEventType.INPUT);
        this.notifyAllListeners(l -> l.onUserTaskInputVariable((UserTaskVariableEvent)event));
    }

    public void fireOnUserTaskOutputVariableChange(KogitoProcessInstance instance, KogitoNodeInstance nodeInstance, KieRuntime kruntime, String variableName, Object newValue, Object oldValue) {
        UserTaskVariableEventImpl event = new UserTaskVariableEventImpl((ProcessInstance)instance, (HumanTaskNodeInstance)nodeInstance, kruntime, this.identityProvider.getName());
        event.setVariableName(variableName);
        event.setOldValue(oldValue);
        event.setNewValue(newValue);
        event.setVariableType(UserTaskVariableEvent.VariableEventType.OUTPUT);
        this.notifyAllListeners(l -> l.onUserTaskOutputVariable((UserTaskVariableEvent)event));
    }

    public void fireOnUserTaskAttachmentAdded(KogitoProcessInstance instance, KogitoNodeInstance nodeInstance, KieRuntime kruntime, Attachment addedAttachment) {
        UserTaskAttachmentEventImpl event = new UserTaskAttachmentEventImpl((ProcessInstance)instance, (HumanTaskNodeInstance)nodeInstance, kruntime, this.identityProvider.getName());
        event.setNewAttachment(addedAttachment);
        this.notifyAllListeners(l -> l.onUserTaskAttachmentAdded((UserTaskAttachmentEvent)event));
    }

    public void fireOnUserTaskAttachmentChange(KogitoProcessInstance instance, KogitoNodeInstance nodeInstance, KieRuntime kruntime, Attachment oldAttachment, Attachment newAttachment) {
        UserTaskAttachmentEventImpl event = new UserTaskAttachmentEventImpl((ProcessInstance)instance, (HumanTaskNodeInstance)nodeInstance, kruntime, this.identityProvider.getName());
        event.setOldAttachment(oldAttachment);
        event.setNewAttachment(newAttachment);
        this.notifyAllListeners(l -> l.onUserTaskAttachmentChange((UserTaskAttachmentEvent)event));
    }

    public void fireOnUserTaskAttachmentDeleted(KogitoProcessInstance instance, KogitoNodeInstance nodeInstance, KieRuntime kruntime, Attachment deletedAttachment) {
        UserTaskAttachmentEventImpl event = new UserTaskAttachmentEventImpl((ProcessInstance)instance, (HumanTaskNodeInstance)nodeInstance, kruntime, this.identityProvider.getName());
        event.setOldAttachment(deletedAttachment);
        this.notifyAllListeners(l -> l.onUserTaskAttachmentDeleted((UserTaskAttachmentEvent)event));
    }

    public void fireOnUserTaskCommentAdded(KogitoProcessInstance instance, KogitoNodeInstance nodeInstance, KieRuntime kruntime, Comment addedComment) {
        UserTaskCommentEventImpl event = new UserTaskCommentEventImpl((ProcessInstance)instance, (HumanTaskNodeInstance)nodeInstance, kruntime, this.identityProvider.getName());
        event.setNewComment(addedComment);
        this.notifyAllListeners(l -> l.onUserTaskCommentAdded((UserTaskCommentEvent)event));
    }

    public void fireOnUserTaskCommentChange(KogitoProcessInstance instance, KogitoNodeInstance nodeInstance, KieRuntime kruntime, Comment oldComment, Comment newComment) {
        UserTaskCommentEventImpl event = new UserTaskCommentEventImpl((ProcessInstance)instance, (HumanTaskNodeInstance)nodeInstance, kruntime, this.identityProvider.getName());
        event.setOldComment(oldComment);
        event.setNewComment(newComment);
        this.notifyAllListeners(l -> l.onUserTaskCommentChange((UserTaskCommentEvent)event));
    }

    public void fireOnUserTaskCommentDeleted(KogitoProcessInstance instance, KogitoNodeInstance nodeInstance, KieRuntime kruntime, Comment deletedComment) {
        UserTaskCommentEventImpl event = new UserTaskCommentEventImpl((ProcessInstance)instance, (HumanTaskNodeInstance)nodeInstance, kruntime, this.identityProvider.getName());
        event.setOldComment(deletedComment);
        this.notifyAllListeners(l -> l.onUserTaskCommentDeleted((UserTaskCommentEvent)event));
    }

    public void reset() {
        this.clear();
    }

    private static /* synthetic */ void lambda$fireAfterVariableChanged$11(ProcessVariableChangedEvent event, KogitoProcessEventListener l) {
        l.afterVariableChanged(event);
    }

    private static /* synthetic */ void lambda$fireBeforeVariableChanged$10(ProcessVariableChangedEvent event, KogitoProcessEventListener l) {
        l.beforeVariableChanged(event);
    }
}

