/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xpath;

import java.util.List;
import java.util.function.Function;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.jbpm.process.instance.impl.AssignmentAction;
import org.jbpm.process.instance.impl.AssignmentProducer;
import org.jbpm.workflow.core.impl.DataDefinition;
import org.jbpm.workflow.core.node.Assignment;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XPATHAssignmentAction
implements AssignmentAction {
    private Assignment assignment;
    private List<DataDefinition> sourcesDefinitions;
    private DataDefinition targetDefinition;

    public XPATHAssignmentAction(Assignment assignment, List<DataDefinition> sources, DataDefinition target) {
        this.assignment = assignment;
        this.sourcesDefinitions = sources;
        this.targetDefinition = target;
    }

    public void execute(Function<String, Object> sourceResolver, Function<String, Object> targetResolver, AssignmentProducer producer) throws Exception {
        Node parent;
        String from = this.assignment.getFrom().getExpression();
        String to = this.assignment.getTo().getExpression();
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpathFrom = factory.newXPath();
        XPathExpression exprFrom = xpathFrom.compile(from);
        XPath xpathTo = factory.newXPath();
        XPathExpression exprTo = xpathTo.compile(to);
        Object target = null;
        Object source = null;
        source = !this.sourcesDefinitions.isEmpty() ? sourceResolver.apply(this.sourcesDefinitions.get(0).getLabel()) : this.assignment.getFrom().getExpression();
        target = targetResolver.apply(this.targetDefinition.getLabel());
        Object targetElem = null;
        if (target != null && (targetElem = exprTo.evaluate(parent = ((Node)target).getParentNode(), XPathConstants.NODE)) == null) {
            throw new RuntimeException("Nothing was selected by the to expression " + to + " on " + target);
        }
        NodeList nl = null;
        if (source instanceof Node) {
            nl = (NodeList)exprFrom.evaluate(source, XPathConstants.NODESET);
        } else if (source instanceof String) {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            Element temp = doc.createElementNS(null, "temp");
            temp.appendChild(doc.createTextNode((String)source));
            nl = temp.getChildNodes();
        } else if (source == null) {
            throw new RuntimeException("Source value was null for source " + source);
        }
        if (nl == null || nl.getLength() == 0) {
            throw new RuntimeException("Nothing was selected by the from expression " + from + " on " + source);
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!(targetElem instanceof Node)) {
                if (nl.item(i) instanceof Attr) {
                    targetElem = ((Attr)nl.item(i)).getValue();
                } else if (nl.item(i) instanceof Text) {
                    targetElem = ((Text)nl.item(i)).getWholeText();
                } else {
                    DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    Document doc = builder.newDocument();
                    targetElem = doc.importNode(nl.item(i), true);
                }
                target = targetElem;
                continue;
            }
            Node n = ((Node)targetElem).getOwnerDocument().importNode(nl.item(i), true);
            if (n instanceof Attr) {
                ((Element)targetElem).setAttributeNode((Attr)n);
                continue;
            }
            ((Node)targetElem).appendChild(n);
        }
        producer.accept(this.targetDefinition.getLabel(), target);
    }
}

