/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jbpm.bpmn2.core.Error;
import org.jbpm.bpmn2.core.Escalation;
import org.jbpm.bpmn2.core.Message;
import org.jbpm.bpmn2.xml.AbstractNodeHandler;
import org.jbpm.bpmn2.xml.ProcessHandler;
import org.jbpm.bpmn2.xml.ProcessParsingValidationException;
import org.jbpm.compiler.xml.Parser;
import org.jbpm.compiler.xml.ProcessBuildData;
import org.jbpm.process.instance.impl.Action;
import org.jbpm.process.instance.impl.actions.HandleMessageAction;
import org.jbpm.process.instance.impl.actions.SignalProcessInstanceAction;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.impl.IOSpecification;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.FaultNode;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class EndEventHandler
extends AbstractNodeHandler {
    @Override
    protected Node createNode(Attributes attrs) {
        EndNode node = new EndNode();
        node.setTerminate(false);
        return node;
    }

    public Class<EndNode> generateNodeFor() {
        return EndNode.class;
    }

    @Override
    protected Node handleNode(Node newNode, Element element, String uri, String localName, Parser parser) throws SAXException {
        NodeImpl node = (NodeImpl)newNode;
        super.handleNode((Node)node, element, uri, localName, parser);
        IOSpecification ioSpecification = this.readThrowSpecification(parser, element);
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("terminateEventDefinition".equals(nodeName)) {
                this.setThrowVariable(ioSpecification, (Node)node);
                this.handleTerminateNode((Node)node, element, uri, localName, parser);
                break;
            }
            if ("signalEventDefinition".equals(nodeName)) {
                this.setThrowVariable(ioSpecification, (Node)node);
                this.handleSignalNode((Node)node, element, uri, localName, parser);
                continue;
            }
            if ("messageEventDefinition".equals(nodeName)) {
                this.setThrowVariable(ioSpecification, (Node)node);
                this.handleMessageNode((Node)node, element, uri, localName, parser);
                continue;
            }
            if ("errorEventDefinition".equals(nodeName)) {
                FaultNode faultNode = new FaultNode();
                faultNode.setId(node.getId());
                faultNode.setName(node.getName());
                faultNode.setTerminateParent(true);
                faultNode.setMetaData("UniqueId", node.getMetaData().get("UniqueId"));
                node = faultNode;
                this.setThrowVariable(ioSpecification, (Node)node);
                faultNode.setFaultVariable((String)node.getMetaData().get("Variable"));
                super.handleNode((Node)node, element, uri, localName, parser);
                this.handleErrorNode((Node)node, element, uri, localName, parser);
                break;
            }
            if ("escalationEventDefinition".equals(nodeName)) {
                FaultNode faultNode = new FaultNode();
                faultNode.setId(node.getId());
                faultNode.setName(node.getName());
                faultNode.setMetaData("UniqueId", node.getMetaData().get("UniqueId"));
                node = faultNode;
                this.setThrowVariable(ioSpecification, (Node)node);
                faultNode.setFaultVariable((String)node.getMetaData().get("Variable"));
                super.handleNode((Node)node, element, uri, localName, parser);
                this.handleEscalationNode((Node)node, element, uri, localName, parser);
                break;
            }
            if (!"compensateEventDefinition".equals(nodeName)) continue;
            this.setThrowVariable(ioSpecification, (Node)node);
            this.handleThrowCompensationEventNode((Node)node, element, uri, localName, parser);
            break;
        }
        if (node.getName() == null) {
            node.setName("End");
        }
        return node;
    }

    public void handleTerminateNode(Node node, Element element, String uri, String localName, Parser parser) throws SAXException {
        ((EndNode)node).setTerminate(true);
        EndNode endNode = (EndNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if (!"terminateEventDefinition".equals(nodeName)) continue;
            String scope = ((Element)xmlNode).getAttribute("scope");
            if ("process".equalsIgnoreCase(scope)) {
                endNode.setScope(1);
                continue;
            }
            endNode.setScope(0);
        }
    }

    public void handleSignalNode(Node node, Element element, String uri, String localName, Parser parser) throws SAXException {
        EndNode endNode = (EndNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if (!"signalEventDefinition".equals(nodeName)) continue;
            Object signalName = ((Element)xmlNode).getAttribute("signalRef");
            String variable = (String)endNode.getMetaData("Variable");
            String inputVariable = (String)endNode.getMetaData("MappingVariableInput");
            signalName = this.checkSignalAndConvertToRealSignalNam(parser, (String)signalName);
            endNode.setMetaData("EventType", (Object)"signal");
            endNode.setMetaData("Ref", signalName);
            endNode.setMetaData("Variable", (Object)variable);
            if (endNode.getIoSpecification().containsInputLabel("async")) {
                signalName = "ASYNC-" + (String)signalName;
            }
            DroolsConsequenceAction action = ProcessHandler.createJavaAction((Action)new SignalProcessInstanceAction((String)signalName, variable, inputVariable, (String)endNode.getMetaData("customScope")));
            ArrayList<DroolsConsequenceAction> actions = new ArrayList<DroolsConsequenceAction>();
            actions.add(action);
            endNode.setActions("onEntry", actions);
        }
    }

    public void handleMessageNode(Node node, Element element, String uri, String localName, Parser parser) throws SAXException {
        EndNode endNode = (EndNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if (!"messageEventDefinition".equals(nodeName)) continue;
            String messageRef = ((Element)xmlNode).getAttribute("messageRef");
            Map messages = (Map)((ProcessBuildData)parser.getData()).getMetaData("Messages");
            if (messages == null) {
                throw new ProcessParsingValidationException("No messages found");
            }
            Message message = (Message)messages.get(messageRef);
            if (message == null) {
                throw new ProcessParsingValidationException("Could not find message " + messageRef);
            }
            String variable = (String)endNode.getMetaData("MappingVariable");
            endNode.setMetaData("EventType", (Object)"message");
            endNode.setMetaData("MessageType", (Object)message.getType());
            endNode.setMetaData("TriggerType", (Object)"ProduceMessage");
            endNode.setMetaData("TriggerRef", (Object)message.getName());
            ArrayList<DroolsConsequenceAction> actions = new ArrayList<DroolsConsequenceAction>();
            DroolsConsequenceAction action = ProcessHandler.createJavaAction((Action)new HandleMessageAction(message.getType(), variable));
            actions.add(action);
            endNode.setActions("onEntry", actions);
        }
    }

    public void handleErrorNode(Node node, Element element, String uri, String localName, Parser parser) throws SAXException {
        FaultNode faultNode = (FaultNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String errorRef;
            String nodeName = xmlNode.getNodeName();
            if (!"errorEventDefinition".equals(nodeName) || (errorRef = ((Element)xmlNode).getAttribute("errorRef")) == null || errorRef.trim().length() <= 0) continue;
            List errors = (List)((ProcessBuildData)parser.getData()).getMetaData("Errors");
            if (errors == null) {
                throw new ProcessParsingValidationException("No errors found");
            }
            Error error = null;
            for (Error listError : errors) {
                if (!errorRef.equals(listError.getId())) continue;
                error = listError;
                break;
            }
            if (error == null) {
                throw new ProcessParsingValidationException("Could not find error " + errorRef);
            }
            faultNode.setFaultName(error.getErrorCode());
            faultNode.setTerminateParent(true);
        }
    }

    public void handleEscalationNode(Node node, Element element, String uri, String localName, Parser parser) throws SAXException {
        FaultNode faultNode = (FaultNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if (!"escalationEventDefinition".equals(nodeName)) continue;
            String escalationRef = ((Element)xmlNode).getAttribute("escalationRef");
            if (escalationRef != null && escalationRef.trim().length() > 0) {
                Map escalations = (Map)((ProcessBuildData)parser.getData()).getMetaData("BPMN.Escalations");
                if (escalations == null) {
                    throw new ProcessParsingValidationException("No escalations found");
                }
                Escalation escalation = (Escalation)escalations.get(escalationRef);
                if (escalation == null) {
                    throw new ProcessParsingValidationException("Could not find escalation " + escalationRef);
                }
                faultNode.setFaultName(escalation.getEscalationCode());
                continue;
            }
            throw new ProcessParsingValidationException("End events throwing an escalation must throw *specific* escalations (and not general ones).");
        }
    }

    @Override
    public void writeNode(Node node, StringBuilder xmlDump, int metaDataType) {
        throw new IllegalArgumentException("Writing out should be handled by specific handlers");
    }
}

