/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.rule;

import java.util.Map;
import org.drools.core.common.InternalAgenda;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.node.RuleSetNodeInstance;
import org.jbpm.workflow.instance.rule.RuleFlowGroupRuleTypeEngine;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;

public class RuleFlowGroupRuleTypeEngineImpl
implements RuleFlowGroupRuleTypeEngine {
    private static final String FIRE_RULE_LIMIT_PARAMETER = "FireRuleLimit";
    private static final String FIRE_RULE_LIMIT_PROPERTY = "org.jbpm.rule.task.firelimit";
    private static final int DEFAULT_FIRE_RULE_LIMIT = Integer.parseInt(System.getProperty("org.jbpm.rule.task.firelimit", "10000"));

    public void evaluate(RuleSetNodeInstance rsni, String ruleFlowGroup) {
        rsni.setRuleFlowGroup(ruleFlowGroup);
        KieRuntime kruntime = this.getKieRuntime(rsni);
        Map inputs = this.getInputs(rsni);
        for (Map.Entry entry : inputs.entrySet()) {
            if (FIRE_RULE_LIMIT_PARAMETER.equals(entry.getKey())) continue;
            String inputKey = rsni.getRuleFlowGroup() + "_" + rsni.getProcessInstance().getStringId() + "_" + (String)entry.getKey();
            rsni.addFact(inputKey, kruntime.insert(entry.getValue()));
        }
        if (rsni.actAsWaitState()) {
            rsni.addRuleSetListener();
            ((InternalAgenda)kruntime.getAgenda()).activateRuleFlowGroup(rsni.getRuleFlowGroup(), rsni.getProcessInstance().getStringId(), rsni.getUniqueId());
        } else {
            int fireLimit = DEFAULT_FIRE_RULE_LIMIT;
            WorkflowProcessInstance processInstance = rsni.getProcessInstance();
            if (inputs.containsKey(FIRE_RULE_LIMIT_PARAMETER)) {
                fireLimit = Integer.parseInt(inputs.get(FIRE_RULE_LIMIT_PARAMETER).toString());
            }
            ((InternalAgenda)kruntime.getAgenda()).activateRuleFlowGroup(rsni.getRuleFlowGroup(), processInstance.getStringId(), rsni.getUniqueId());
            int fired = ((KieSession)kruntime).fireAllRules(processInstance.getAgendaFilter(), fireLimit);
            if (fired == fireLimit) {
                throw new RuntimeException("Fire rule limit reached " + fireLimit + ", limit can be set via system property org.jbpm.rule.task.firelimit or via data input of business rule task named FireRuleLimit");
            }
            rsni.removeEventListeners();
            rsni.retractFacts(kruntime);
            rsni.triggerCompleted();
        }
    }
}

