/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.ast.factories;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dmg.pmml.Field;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsType;
import org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType;

public class KiePMMLDataDictionaryASTFactory {
    private final Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap;

    private KiePMMLDataDictionaryASTFactory(Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap) {
        this.fieldTypeMap = fieldTypeMap;
    }

    public static KiePMMLDataDictionaryASTFactory factory(Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap) {
        return new KiePMMLDataDictionaryASTFactory(fieldTypeMap);
    }

    public List<KiePMMLDroolsType> declareTypes(List<Field<?>> fields) {
        return fields.stream().map(this::declareType).collect(Collectors.toList());
    }

    public KiePMMLDroolsType declareType(Field field) {
        String generatedType = KiePMMLModelUtils.getGeneratedClassName((String)field.getName());
        String fieldName = field.getName();
        String fieldType = field.getDataType().value();
        this.fieldTypeMap.put(fieldName, new KiePMMLOriginalTypeGeneratedType(fieldType, generatedType));
        return new KiePMMLDroolsType(generatedType, DATA_TYPE.byName((String)fieldType).getMappedClass().getSimpleName());
    }
}

