/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.ast.factories;

import java.util.List;
import java.util.stream.Collectors;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.kie.pmml.api.enums.ResultCode;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsRule;
import org.kie.pmml.models.drools.ast.factories.KiePMMLSimplePredicateASTFactory;
import org.kie.pmml.models.drools.ast.factories.PredicateASTFactoryData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLCompoundPredicateWithResultASTFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLCompoundPredicateWithResultASTFactory.class.getName());

    public static void declareRuleFromCompoundPredicateSurrogate(PredicateASTFactoryData predicateASTFactoryData, String agendaActivationGroup, Object result, boolean isFinalLeaf) {
        logger.trace("declareRuleFromCompoundPredicateSurrogate {} {} {} {}", new Object[]{predicateASTFactoryData, agendaActivationGroup, result, isFinalLeaf});
        CompoundPredicate compoundPredicate = (CompoundPredicate)predicateASTFactoryData.getPredicate();
        List<Predicate> simplePredicates = compoundPredicate.getPredicates().stream().filter(predicate -> predicate instanceof SimplePredicate).collect(Collectors.toList());
        simplePredicates.forEach(predicate -> {
            SimplePredicate simplePredicate = (SimplePredicate)predicate;
            PredicateASTFactoryData newPredicateASTFactoryData = predicateASTFactoryData.cloneWithPredicate((Predicate)simplePredicate);
            KiePMMLSimplePredicateASTFactory.factory(newPredicateASTFactoryData).declareRuleFromSimplePredicateSurrogate(agendaActivationGroup, result, isFinalLeaf);
        });
    }

    public static void declareRuleFromCompoundPredicateAndOrXor(KiePMMLDroolsRule.Builder builder, List<KiePMMLDroolsRule> rules, Object result, boolean isFinalLeaf) {
        logger.trace("declareRuleFromCompoundPredicateAndOrXor {} {} {} {}", new Object[]{builder, rules, result, isFinalLeaf});
        if (isFinalLeaf) {
            builder = builder.withResult(result).withResultCode(ResultCode.OK);
        }
        rules.add(builder.build());
    }
}

