/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.ast;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.kie.pmml.api.enums.BOOLEAN_OPERATOR;
import org.kie.pmml.models.drools.tuples.KiePMMLOperatorValue;

public class KiePMMLFieldOperatorValue {
    public static final String NO_FIELD_CONSTRAINT_PATTERN = "(%s)";
    public static final String FIELD_CONSTRAINT_PATTERN = " %s (%s)";
    private final String name;
    private final BOOLEAN_OPERATOR operator;
    private final List<KiePMMLOperatorValue> kiePMMLOperatorValues;
    private final List<KiePMMLFieldOperatorValue> nestedKiePMMLFieldOperatorValues;
    private final String constraintsString;

    public KiePMMLFieldOperatorValue(String name, BOOLEAN_OPERATOR operator, List<KiePMMLOperatorValue> kiePMMLOperatorValues, List<KiePMMLFieldOperatorValue> nestedKiePMMLFieldOperatorValues) {
        this.name = name;
        this.operator = operator;
        this.kiePMMLOperatorValues = kiePMMLOperatorValues;
        this.nestedKiePMMLFieldOperatorValues = nestedKiePMMLFieldOperatorValues;
        this.constraintsString = this.buildConstraintsString();
    }

    public String getName() {
        return this.name;
    }

    public BOOLEAN_OPERATOR getOperator() {
        return this.operator;
    }

    public String getConstraintsAsString() {
        return this.constraintsString;
    }

    public List<KiePMMLFieldOperatorValue> getNestedKiePMMLFieldOperatorValues() {
        return this.nestedKiePMMLFieldOperatorValues != null ? Collections.unmodifiableList(this.nestedKiePMMLFieldOperatorValues) : null;
    }

    public List<KiePMMLOperatorValue> getKiePMMLOperatorValues() {
        return this.kiePMMLOperatorValues;
    }

    public String toString() {
        return "KiePMMLFieldOperatorValue{name='" + this.name + "', operator='" + this.operator + "', kiePMMLOperatorValues=" + this.kiePMMLOperatorValues + ", nestedKiePMMLFieldOperatorValues=" + this.nestedKiePMMLFieldOperatorValues + ", constraintsString='" + this.constraintsString + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KiePMMLFieldOperatorValue that = (KiePMMLFieldOperatorValue)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.operator, that.operator) && Objects.equals(this.kiePMMLOperatorValues, that.kiePMMLOperatorValues);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.operator, this.kiePMMLOperatorValues);
    }

    protected String buildConstraintsString() {
        String operatorString = this.operator != null ? this.operator.getCustomOperator() : "";
        return this.kiePMMLOperatorValues.stream().map(KiePMMLOperatorValue::getConstraintsAsString).collect(Collectors.joining(" " + operatorString + " "));
    }
}

