/*
 * Decompiled with CFR 0.152.
 */
package org.kie.drl.engine.runtime.mapinput.utils;

import java.util.Map;
import java.util.Optional;
import org.kie.api.runtime.KieSession;
import org.kie.drl.api.identifiers.DrlSessionIdFactory;
import org.kie.drl.api.identifiers.KieDrlComponentRoot;
import org.kie.drl.api.identifiers.LocalComponentIdDrlSession;
import org.kie.drl.engine.runtime.mapinput.model.EfestoOutputDrlMap;
import org.kie.drl.engine.runtime.mapinput.utils.MapInputSessionUtils;
import org.kie.drl.engine.runtime.utils.EfestoKieSessionUtil;
import org.kie.efesto.common.api.identifiers.EfestoAppRoot;
import org.kie.efesto.common.api.identifiers.ModelLocalUriId;
import org.kie.efesto.runtimemanager.api.exceptions.KieRuntimeServiceException;
import org.kie.efesto.runtimemanager.api.model.BaseEfestoInput;
import org.kie.efesto.runtimemanager.api.model.EfestoInput;
import org.kie.efesto.runtimemanager.api.model.EfestoMapInputDTO;
import org.kie.efesto.runtimemanager.api.model.EfestoRuntimeContext;
import org.kie.efesto.runtimemanager.api.utils.GeneratedResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrlRuntimeHelper {
    private static final Logger logger = LoggerFactory.getLogger((String)DrlRuntimeHelper.class.getName());

    private DrlRuntimeHelper() {
    }

    public static boolean canManage(EfestoInput toEvaluate, EfestoRuntimeContext context) {
        return GeneratedResourceUtils.getGeneratedExecutableResource((ModelLocalUriId)toEvaluate.getModelLocalUriId(), (Map)context.getGeneratedResourcesMap()).isPresent();
    }

    public static Optional<EfestoOutputDrlMap> execute(BaseEfestoInput<EfestoMapInputDTO> toEvaluate, EfestoRuntimeContext context) {
        KieSession kieSession;
        try {
            kieSession = EfestoKieSessionUtil.loadKieSession((ModelLocalUriId)toEvaluate.getModelLocalUriId(), (EfestoRuntimeContext)context);
        }
        catch (Exception e) {
            logger.warn("{} can not execute {}", (Object)DrlRuntimeHelper.class.getName(), (Object)toEvaluate.getModelLocalUriId());
            return Optional.empty();
        }
        if (kieSession == null) {
            return Optional.empty();
        }
        try {
            MapInputSessionUtils.Builder builder = MapInputSessionUtils.builder(kieSession, (EfestoMapInputDTO)toEvaluate.getInputData());
            MapInputSessionUtils mapInputSessionUtils = builder.build();
            long identifier = kieSession.getIdentifier();
            mapInputSessionUtils.fireAllRules();
            LocalComponentIdDrlSession modelLocalUriId = ((DrlSessionIdFactory)((KieDrlComponentRoot)new EfestoAppRoot().get(KieDrlComponentRoot.class)).get(DrlSessionIdFactory.class)).get(toEvaluate.getModelLocalUriId().basePath(), identifier);
            return Optional.of(new EfestoOutputDrlMap((ModelLocalUriId)modelLocalUriId, null));
        }
        catch (Exception e) {
            throw new KieRuntimeServiceException(String.format("%s failed to execute %s", DrlRuntimeHelper.class.getName(), toEvaluate.getModelLocalUriId()), (Throwable)e);
        }
    }
}

