/*
 * Decompiled with CFR 0.152.
 */
package org.kie.api.internal.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.kie.api.internal.utils.KieService;

public class KieServiceLoader {
    static final KieServiceLoader INSTANCE = new KieServiceLoader();
    private final Map<String, KieService> serviceCache = new HashMap<String, KieService>();

    private KieServiceLoader() {
    }

    <T extends KieService> T lookup(Class<T> serviceClass) {
        return this.lookup(serviceClass, "undefined");
    }

    <T extends KieService> T lookup(Class<T> serviceClass, String tag) {
        String serviceKey = serviceClass.getName() + ":" + tag;
        if (this.serviceCache.containsKey(serviceKey)) {
            return (T)this.serviceCache.get(serviceKey);
        }
        T loadedService = this.load(serviceClass, tag);
        this.serviceCache.put(serviceKey, (KieService)this.load(serviceClass, tag));
        return loadedService;
    }

    <T extends KieService> T load(Class<T> serviceClass, String tag) {
        ServiceLoader<KieService> loader = ServiceLoader.load(serviceClass);
        KieService service = null;
        for (KieService impl : loader) {
            if (!tag.equals(impl.serviceTag()) || service != null && impl.compareTo(service) <= 0) continue;
            service = impl;
        }
        return (T)service;
    }
}

