/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.asm;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.ProtectionDomain;
import java.util.Map;
import org.drools.base.base.BaseClassFieldReader;
import org.drools.base.base.ClassFieldInspector;
import org.drools.base.base.ValueResolver;
import org.drools.base.base.ValueType;
import org.drools.base.base.extractors.BaseObjectClassFieldReader;
import org.drools.base.base.extractors.SelfReferenceClassFieldReader;
import org.drools.base.util.Drools;
import org.drools.core.base.BaseClassFieldWriter;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.FieldAccessorFactory;
import org.drools.mvel.accessors.BaseBooleanClassFieldReader;
import org.drools.mvel.accessors.BaseBooleanClassFieldWriter;
import org.drools.mvel.accessors.BaseDecimalClassFieldReader;
import org.drools.mvel.accessors.BaseDecimalClassFieldWriter;
import org.drools.mvel.accessors.BaseObjectClassFieldWriter;
import org.drools.mvel.accessors.BaseWholeNumberClassFieldReader;
import org.drools.mvel.accessors.BaseWholeNumberClassFieldWriter;
import org.drools.mvel.accessors.ClassFieldAccessorStore;
import org.drools.mvel.asm.ClassFieldInspectorImpl;
import org.drools.mvel.asm.ClassGenerator;
import org.drools.wiring.api.util.ByteArrayClassLoader;
import org.mvel2.asm.ClassWriter;
import org.mvel2.asm.Label;
import org.mvel2.asm.MethodVisitor;
import org.mvel2.asm.Type;

public class ClassFieldAccessorFactory
implements FieldAccessorFactory {
    private static final String BASE_PACKAGE = "org/drools/base";
    private static final String SELF_REFERENCE_FIELD = "this";
    private static final ProtectionDomain PROTECTION_DOMAIN = Drools.isNativeImage() ? null : AccessController.doPrivileged(ClassFieldAccessorFactory.class::getProtectionDomain);

    public BaseClassFieldReader getClassFieldReader(Class<?> clazz, String fieldName, ClassFieldAccessorCache.CacheEntry cache) {
        try {
            String altFieldName;
            if (SELF_REFERENCE_FIELD.equals(fieldName)) {
                return new SelfReferenceClassFieldReader(clazz);
            }
            ClassFieldInspector inspector = ClassFieldAccessorStore.getClassFieldInspector(clazz, cache);
            Method getterMethod = (Method)inspector.getGetterMethods().get(fieldName);
            Integer index = (Integer)inspector.getFieldNames().get(fieldName);
            Class fieldType = inspector.getFieldType(fieldName);
            if (fieldType == null && fieldName.length() > 1 && Character.isLowerCase(fieldName.charAt(0)) && Character.isUpperCase(fieldName.charAt(1)) && (fieldType = inspector.getFieldType(altFieldName = Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1))) != null) {
                getterMethod = (Method)inspector.getGetterMethods().get(altFieldName);
                index = (Integer)inspector.getFieldNames().get(altFieldName);
            }
            if (fieldType != null && getterMethod != null) {
                String className = "org/drools/base/" + Type.getInternalName(clazz) + Math.abs((long)System.identityHashCode(clazz)) + "$" + getterMethod.getName();
                byte[] bytes = ClassFieldAccessorFactory.dumpReader(clazz, className, getterMethod, fieldType);
                ByteArrayClassLoader byteArrayClassLoader = cache.getByteArrayClassLoader();
                Class newClass = byteArrayClassLoader.defineClass(className.replace('/', '.'), bytes, PROTECTION_DOMAIN);
                ValueType valueType = ValueType.determineValueType((Class)fieldType);
                Object[] params = new Object[]{index, fieldType, valueType};
                return (BaseClassFieldReader)newClass.getConstructors()[0].newInstance(params);
            }
            return null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public BaseClassFieldWriter getClassFieldWriter(Class<?> clazz, String fieldName, ClassFieldAccessorCache.CacheEntry cache) {
        ByteArrayClassLoader byteArrayClassLoader = cache.getByteArrayClassLoader();
        Map inspectors = cache.getInspectors();
        try {
            ClassFieldInspector inspector = (ClassFieldInspector)inspectors.get(clazz);
            if (inspector == null) {
                inspector = new ClassFieldInspectorImpl(clazz);
                inspectors.put(clazz, inspector);
            }
            Method setterMethod = (Method)inspector.getSetterMethods().get(fieldName);
            Integer index = (Integer)inspector.getFieldNames().get(fieldName);
            if (setterMethod == null && fieldName.length() > 1 && Character.isLowerCase(fieldName.charAt(0)) && Character.isUpperCase(fieldName.charAt(1))) {
                String altFieldName = Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
                setterMethod = (Method)inspector.getSetterMethods().get(altFieldName);
                index = (Integer)inspector.getFieldNames().get(altFieldName);
            }
            if (setterMethod != null) {
                Class<?> fieldType = setterMethod.getParameterTypes()[0];
                String className = "org/drools/base/" + Type.getInternalName(clazz) + Math.abs((long)System.identityHashCode(clazz)) + "$" + setterMethod.getName();
                byte[] bytes = ClassFieldAccessorFactory.dumpWriter(clazz, className, setterMethod, fieldType);
                Class newClass = byteArrayClassLoader.defineClass(className.replace('/', '.'), bytes, PROTECTION_DOMAIN);
                ValueType valueType = ValueType.determineValueType(fieldType);
                Object[] params = new Object[]{index, fieldType, valueType};
                return (BaseClassFieldWriter)newClass.getConstructors()[0].newInstance(params);
            }
            if (inspector.getFieldNames().containsKey(fieldName)) {
                return null;
            }
            throw new RuntimeException("Field/method '" + fieldName + "' not found for class '" + clazz.getName() + "'");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] dumpReader(Class<?> originalClass, String className, Method getterMethod, Class<?> fieldType) throws Exception {
        Class<?> superClass = ClassFieldAccessorFactory.getReaderSuperClassFor(fieldType);
        ClassWriter cw = ClassFieldAccessorFactory.buildClassHeader(superClass, className);
        ClassFieldAccessorFactory.build3ArgConstructor(superClass, className, cw);
        ClassFieldAccessorFactory.buildGetMethod(originalClass, className, superClass, getterMethod, cw);
        cw.visitEnd();
        return cw.toByteArray();
    }

    private static byte[] dumpWriter(Class<?> originalClass, String className, Method getterMethod, Class<?> fieldType) throws Exception {
        Class<?> superClass = ClassFieldAccessorFactory.getWriterSuperClassFor(fieldType);
        ClassWriter cw = ClassFieldAccessorFactory.buildClassHeader(superClass, className);
        ClassFieldAccessorFactory.build3ArgConstructor(superClass, className, cw);
        ClassFieldAccessorFactory.buildSetMethod(originalClass, className, superClass, getterMethod, fieldType, cw);
        cw.visitEnd();
        return cw.toByteArray();
    }

    protected static ClassWriter buildClassHeader(Class<?> superClass, String className) {
        ClassWriter cw = ClassGenerator.createClassWriter(superClass.getClassLoader(), 33, className, null, Type.getInternalName(superClass), null);
        cw.visitSource(null, null);
        return cw;
    }

    private static void build3ArgConstructor(Class<?> superClazz, String className, ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Integer.TYPE), Type.getType(Class.class), Type.getType(ValueType.class)}), null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(21, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(183, Type.getInternalName(superClazz), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Integer.TYPE), Type.getType(Class.class), Type.getType(ValueType.class)}));
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitInsn(177);
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitLocalVariable(SELF_REFERENCE_FIELD, "L" + className + ";", null, l0, l2, 0);
        mv.visitLocalVariable("index", Type.getDescriptor(Integer.TYPE), null, l0, l2, 1);
        mv.visitLocalVariable("fieldType", Type.getDescriptor(Class.class), null, l0, l2, 2);
        mv.visitLocalVariable("valueType", Type.getDescriptor(ValueType.class), null, l0, l2, 3);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected static void buildGetMethod(Class<?> originalClass, String className, Class<?> superClass, Method getterMethod, ClassWriter cw) {
        Method overridingMethod;
        Class<?> fieldType = getterMethod.getReturnType();
        try {
            overridingMethod = superClass.getMethod(ClassFieldAccessorFactory.getOverridingGetMethodName(fieldType), ValueResolver.class, Object.class);
        }
        catch (Exception e) {
            throw new RuntimeException("This is a bug. Please report back to JBoss Rules team.", e);
        }
        MethodVisitor mv = cw.visitMethod(1, overridingMethod.getName(), Type.getMethodDescriptor((Method)overridingMethod), null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 2);
        mv.visitTypeInsn(192, Type.getInternalName(originalClass));
        if (originalClass.isInterface()) {
            mv.visitMethodInsn(185, Type.getInternalName(originalClass), getterMethod.getName(), Type.getMethodDescriptor((Method)getterMethod), true);
        } else {
            mv.visitMethodInsn(182, Type.getInternalName(originalClass), getterMethod.getName(), Type.getMethodDescriptor((Method)getterMethod), false);
        }
        if (getterMethod.getReturnType() != overridingMethod.getReturnType()) {
            if (getterMethod.getReturnType() == Float.TYPE && overridingMethod.getReturnType() == Double.TYPE) {
                mv.visitInsn(141);
                mv.visitMethodInsn(184, "org/drools/util/FloatHelper", "cleanDouble", "(D)D", false);
            } else if (getterMethod.getReturnType() == Double.TYPE && overridingMethod.getReturnType() == Float.TYPE) {
                mv.visitInsn(144);
            } else if (getterMethod.getReturnType() == Byte.TYPE && overridingMethod.getReturnType() == Long.TYPE) {
                mv.visitInsn(133);
            } else if (getterMethod.getReturnType() == Short.TYPE && overridingMethod.getReturnType() == Long.TYPE) {
                mv.visitInsn(133);
            } else if (getterMethod.getReturnType() == Integer.TYPE && overridingMethod.getReturnType() == Long.TYPE) {
                mv.visitInsn(133);
            } else if (getterMethod.getReturnType() == Character.TYPE && overridingMethod.getReturnType() == Long.TYPE) {
                mv.visitInsn(133);
            }
        }
        mv.visitInsn(Type.getType(overridingMethod.getReturnType()).getOpcode(172));
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable(SELF_REFERENCE_FIELD, "L" + className + ";", null, l0, l1, 0);
        mv.visitLocalVariable("workingMemory", Type.getDescriptor(ValueResolver.class), null, l0, l1, 1);
        mv.visitLocalVariable("object", Type.getDescriptor(Object.class), null, l0, l1, 2);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected static void buildSetMethod(Class<?> originalClass, String className, Class<?> superClass, Method setterMethod, Class<?> fieldType, ClassWriter cw) {
        Method overridingMethod;
        try {
            Class<?> parameterType = ClassFieldAccessorFactory.getParameterType(fieldType);
            overridingMethod = superClass.getMethod(ClassFieldAccessorFactory.getOverridingSetMethodName(fieldType), Object.class, parameterType);
        }
        catch (Exception e) {
            throw new RuntimeException("This is a bug. Please report back to JBoss Rules team.", e);
        }
        MethodVisitor mv = cw.visitMethod(1, overridingMethod.getName(), Type.getMethodDescriptor((Method)overridingMethod), null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, Type.getInternalName(originalClass));
        Class<?> parameterType = ClassFieldAccessorFactory.getParameterType(fieldType);
        mv.visitVarInsn(Type.getType(parameterType).getOpcode(21), 2);
        if (fieldType == Float.TYPE && ClassFieldAccessorFactory.getOverridingSetMethodName(fieldType).equals("setDecimalValue")) {
            mv.visitInsn(144);
        }
        if (fieldType == Byte.TYPE && ClassFieldAccessorFactory.getOverridingSetMethodName(fieldType).equals("setWholeNumberValue")) {
            mv.visitInsn(136);
            mv.visitInsn(145);
        }
        if (fieldType == Short.TYPE && ClassFieldAccessorFactory.getOverridingSetMethodName(fieldType).equals("setWholeNumberValue")) {
            mv.visitInsn(136);
            mv.visitInsn(147);
        }
        if (fieldType == Integer.TYPE && ClassFieldAccessorFactory.getOverridingSetMethodName(fieldType).equals("setWholeNumberValue")) {
            mv.visitInsn(136);
        }
        if (fieldType == Character.TYPE && ClassFieldAccessorFactory.getOverridingSetMethodName(fieldType).equals("setWholeNumberValue")) {
            mv.visitInsn(136);
        }
        if (!fieldType.isPrimitive()) {
            mv.visitTypeInsn(192, Type.getInternalName(fieldType));
        }
        if (originalClass.isInterface()) {
            mv.visitMethodInsn(185, Type.getInternalName(originalClass), setterMethod.getName(), Type.getMethodDescriptor((Method)setterMethod), true);
        } else {
            mv.visitMethodInsn(182, Type.getInternalName(originalClass), setterMethod.getName(), Type.getMethodDescriptor((Method)setterMethod), false);
        }
        mv.visitInsn(177);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable(SELF_REFERENCE_FIELD, "L" + className + ";", null, l0, l1, 0);
        mv.visitLocalVariable("bean", Type.getDescriptor(Object.class), null, l0, l1, 1);
        Class<?> localVarType = ClassFieldAccessorFactory.getLocalVarType(fieldType);
        mv.visitLocalVariable("value", Type.getDescriptor(localVarType), null, l0, l1, 2);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static Class<?> getLocalVarType(Class<?> fieldType) {
        if ((fieldType == Byte.TYPE || fieldType == Short.TYPE || fieldType == Integer.TYPE || fieldType == Character.TYPE) && ClassFieldAccessorFactory.getOverridingSetMethodName(fieldType).equals("setWholeNumberValue")) {
            return Long.TYPE;
        }
        if (fieldType == Float.TYPE && ClassFieldAccessorFactory.getOverridingSetMethodName(fieldType).equals("setDecimalValue")) {
            return Double.TYPE;
        }
        return fieldType;
    }

    private static Class<?> getParameterType(Class<?> fieldType) {
        if (fieldType.isPrimitive()) {
            if (fieldType == Float.TYPE) {
                return Double.TYPE;
            }
            if (fieldType == Byte.TYPE || fieldType == Short.TYPE || fieldType == Integer.TYPE || fieldType == Character.TYPE) {
                return Long.TYPE;
            }
            return fieldType;
        }
        return Object.class;
    }

    private static String getOverridingGetMethodName(Class<?> fieldType) {
        String ret = null;
        if (fieldType.isPrimitive()) {
            if (fieldType == Character.TYPE || fieldType == Byte.TYPE || fieldType == Short.TYPE || fieldType == Integer.TYPE || fieldType == Long.TYPE) {
                ret = "getWholeNumberValue";
            } else if (fieldType == Float.TYPE || fieldType == Double.TYPE) {
                ret = "getDecimalValue";
            } else if (fieldType == Boolean.TYPE) {
                ret = "getBooleanValue";
            }
        } else {
            ret = "getValue";
        }
        return ret;
    }

    private static String getOverridingSetMethodName(Class<?> fieldType) {
        String ret = null;
        if (fieldType.isPrimitive()) {
            if (fieldType == Character.TYPE || fieldType == Byte.TYPE || fieldType == Short.TYPE || fieldType == Integer.TYPE || fieldType == Long.TYPE) {
                ret = "setWholeNumberValue";
            } else if (fieldType == Double.TYPE || fieldType == Float.TYPE) {
                ret = "setDecimalValue";
            } else if (fieldType == Boolean.TYPE) {
                ret = "setBooleanValue";
            }
        } else {
            ret = "setValue";
        }
        return ret;
    }

    private static Class<?> getReaderSuperClassFor(Class<?> fieldType) {
        Class ret = null;
        if (fieldType.isPrimitive()) {
            if (fieldType == Byte.TYPE || fieldType == Short.TYPE || fieldType == Integer.TYPE || fieldType == Long.TYPE || fieldType == Character.TYPE) {
                ret = BaseWholeNumberClassFieldReader.class;
            } else if (fieldType == Float.TYPE || fieldType == Double.TYPE) {
                ret = BaseDecimalClassFieldReader.class;
            } else if (fieldType == Boolean.TYPE) {
                ret = BaseBooleanClassFieldReader.class;
            }
        } else {
            ret = BaseObjectClassFieldReader.class;
        }
        return ret;
    }

    private static Class<?> getWriterSuperClassFor(Class<?> fieldType) {
        Class ret = null;
        if (fieldType.isPrimitive()) {
            if (fieldType == Byte.TYPE || fieldType == Short.TYPE || fieldType == Integer.TYPE || fieldType == Long.TYPE || fieldType == Character.TYPE) {
                ret = BaseWholeNumberClassFieldWriter.class;
            } else if (fieldType == Double.TYPE || fieldType == Float.TYPE) {
                ret = BaseDecimalClassFieldWriter.class;
            } else if (fieldType == Boolean.TYPE) {
                ret = BaseBooleanClassFieldWriter.class;
            }
        } else {
            ret = BaseObjectClassFieldWriter.class;
        }
        return ret;
    }
}

