/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.base.definitions.InternalKnowledgePackage;
import org.drools.base.factmodel.GeneratedFact;
import org.drools.base.util.Drools;
import org.drools.compiler.builder.DroolsAssemblerContext;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.kie.builder.impl.AbstractKieModule;
import org.drools.compiler.kie.builder.impl.BuildContext;
import org.drools.compiler.kie.builder.impl.FileKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBaseUpdater;
import org.drools.compiler.kie.builder.impl.KieBaseUpdaterImplContext;
import org.drools.compiler.kie.builder.impl.KieBaseUpdaterOptions;
import org.drools.compiler.kie.builder.impl.KieBaseUpdaters;
import org.drools.compiler.kie.builder.impl.KieBaseUpdatersContext;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.drools.compiler.kie.builder.impl.KieProject;
import org.drools.compiler.kie.builder.impl.MemoryKieModule;
import org.drools.compiler.kie.builder.impl.ResultsImpl;
import org.drools.compiler.kie.builder.impl.ZipKieModule;
import org.drools.compiler.kie.util.KieJarChangeSet;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.reteoo.CoreComponentFactory;
import org.drools.io.InternalResource;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.model.Model;
import org.drools.model.NamedModelItem;
import org.drools.model.impl.ModelComponent;
import org.drools.modelcompiler.CanonicalKieBaseUpdater;
import org.drools.modelcompiler.CanonicalKieModuleModel;
import org.drools.modelcompiler.CanonicalKiePackages;
import org.drools.modelcompiler.KieBaseBuilder;
import org.drools.modelcompiler.KiePackagesBuilder;
import org.drools.modelcompiler.util.StringUtil;
import org.drools.util.IoUtils;
import org.drools.util.PortablePath;
import org.drools.util.StringUtils;
import org.drools.wiring.api.ResourceProvider;
import org.drools.wiring.api.classloader.ProjectClassLoader;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.Results;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.conf.Option;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.process.Process;
import org.kie.api.internal.utils.KieService;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.ChangeType;
import org.kie.internal.builder.CompositeKnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.builder.ResourceChange;
import org.kie.internal.builder.ResourceChangeSet;
import org.kie.internal.builder.conf.AlphaNetworkCompilerOption;
import org.kie.util.maven.support.DependencyFilter;
import org.kie.util.maven.support.PomModel;

public class CanonicalKieModule
implements InternalKieModule {
    public static final String PROJECT_MODEL_CLASS = "org.drools.project.model.ProjectModel";
    public static final String MODEL_FILE_DIRECTORY = "META-INF/kie/";
    public static final String MODEL_FILE_NAME = "drools-model";
    public static final String SERVICES_DIRECTORY = "META-INF/services/";
    public static final String RULE_UNIT_SERVICES_FILE = "META-INF/services/org.drools.ruleunits.api.RuleUnit";
    public static final String ANC_FILE_NAME = "alpha-network-compiler";
    public static final String GENERATED_CLASS_NAMES = "generated-class-names";
    public static final String MODEL_VERSION = "Drools-Model-Version:";
    private static final Predicate<String> NON_MODEL_RESOURCES = res -> {
        ResourceType type = ResourceType.determineResourceType((String)res);
        return type != null && !type.isFullyCoveredByExecModel();
    };
    private final InternalKieModule internalKieModule;
    private final ConcurrentMap<String, CanonicalKiePackages> pkgsInKbase = new ConcurrentHashMap<String, CanonicalKiePackages>();
    private final Map<String, Model> models = new HashMap<String, Model>();
    private Collection<String> ruleClassesNames;
    private boolean incrementalUpdate = false;
    private Set<String> generatedClassNames;
    private ProjectClassLoader moduleClassLoader;
    private static final String GENERATED_FACT_MARKER = GeneratedFact.class.getCanonicalName().replace('.', '/');

    public CanonicalKieModule(ReleaseId releaseId, KieModuleModel kieProject, File file) {
        this(releaseId, kieProject, file, null);
    }

    public CanonicalKieModule(ReleaseId releaseId, KieModuleModel kieProject, File file, Collection<String> ruleClassesNames) {
        this((InternalKieModule)(file.isDirectory() ? new FileKieModule(releaseId, kieProject, file) : new ZipKieModule(releaseId, kieProject, file)), ruleClassesNames);
    }

    public CanonicalKieModule(InternalKieModule internalKieModule) {
        this(internalKieModule, null);
    }

    public CanonicalKieModule(InternalKieModule internalKieModule, Collection<String> ruleClassesNames) {
        this.internalKieModule = internalKieModule;
        this.ruleClassesNames = ruleClassesNames;
    }

    private static boolean areModelVersionsCompatible(String runtimeVersion, String compileVersion) {
        return true;
    }

    private CanonicalKieModuleModel getModuleModel() throws ClassNotFoundException {
        return (CanonicalKieModuleModel)CanonicalKieModule.createInstance((ClassLoader)this.getModuleClassLoader(), this.getProjectModelClassName());
    }

    private String getProjectModelClassName() {
        return this.getModuleClassLoader().isDynamic() ? CanonicalKieModule.getProjectModelClassNameNameWithReleaseId(this.internalKieModule.getReleaseId()) : PROJECT_MODEL_CLASS;
    }

    public static String getProjectModelClassNameNameWithReleaseId(ReleaseId releaseId) {
        return PROJECT_MODEL_CLASS + CanonicalKieModule.releaseId2JavaName(releaseId);
    }

    public static String releaseId2JavaName(ReleaseId releaseId) {
        return "_" + (releaseId.getGroupId() + "_" + releaseId.getArtifactId() + "_" + releaseId.getVersion()).replaceAll("\\W", "_");
    }

    private String getProjectModelResourceName() {
        return this.getProjectModelClassName().replace('.', '/') + ".class";
    }

    private static <T> T createInstance(ClassLoader cl, String className) throws ClassNotFoundException {
        try {
            return (T)cl.loadClass(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static KieBaseConfiguration getKieBaseConfiguration(KieBaseModelImpl kBaseModel, ClassLoader cl, KieBaseConfiguration conf) {
        if (conf == null) {
            conf = CanonicalKieModule.getKnowledgeBaseConfiguration(kBaseModel, cl);
        } else if (conf instanceof RuleBaseConfiguration) {
            ((RuleBaseConfiguration)conf).setClassLoader(cl);
        }
        return conf;
    }

    private static KieBaseConfiguration getKnowledgeBaseConfiguration(KieBaseModelImpl kBaseModel, ClassLoader cl) {
        KieBaseConfiguration kbConf = KieServices.get().newKieBaseConfiguration(null, cl);
        if (kBaseModel != null) {
            kbConf.setOption((Option)kBaseModel.getEqualsBehavior());
            kbConf.setOption((Option)kBaseModel.getEventProcessingMode());
            kbConf.setOption((Option)kBaseModel.getDeclarativeAgenda());
            kbConf.setOption((Option)kBaseModel.getSequential());
            kbConf.setOption((Option)kBaseModel.getMutability());
        }
        return kbConf;
    }

    public static String getModelFileWithGAV(ReleaseId releaseId) {
        return MODEL_FILE_DIRECTORY + releaseId.getGroupId() + "/" + releaseId.getArtifactId() + "/drools-model";
    }

    public static String getANCFile(ReleaseId releaseId) {
        return MODEL_FILE_DIRECTORY + releaseId.getGroupId() + "/" + releaseId.getArtifactId() + "/alpha-network-compiler";
    }

    public static String getGeneratedClassNamesFile(ReleaseId releaseId) {
        return MODEL_FILE_DIRECTORY + releaseId.getGroupId() + "/" + releaseId.getArtifactId() + "/generated-class-names";
    }

    public Map<String, byte[]> getClassesMap() {
        return this.internalKieModule.getClassesMap();
    }

    public void addGeneratedClassNames(Set<String> classNames) {
        this.generatedClassNames.addAll(classNames);
    }

    public Set<String> getGeneratedClassNames() {
        return this.generatedClassNames;
    }

    public ResultsImpl build() {
        return new ResultsImpl();
    }

    public InternalKnowledgeBase createKieBase(KieBaseModelImpl kBaseModel, KieProject kieProject, BuildContext buildContext, KieBaseConfiguration conf) {
        this.moduleClassLoader = (ProjectClassLoader)kieProject.getClassLoader();
        if (this.generatedClassNames == null) {
            this.generatedClassNames = this.findGeneratedClassNamesWithDependencies();
        }
        this.moduleClassLoader.setGeneratedClassNames(this.generatedClassNames);
        KieBaseConfiguration kBaseConf = CanonicalKieModule.getKieBaseConfiguration(kBaseModel, (ClassLoader)this.moduleClassLoader, conf);
        CanonicalKiePackages kpkgs = this.pkgsInKbase.computeIfAbsent(kBaseModel.getName(), k -> this.createKiePackages(kieProject, kBaseModel, buildContext, kBaseConf));
        AbstractKieModule.checkStreamMode((KieBaseModel)kBaseModel, (KieBaseConfiguration)conf, kpkgs.getKiePackages());
        InternalKnowledgeBase kieBase = new KieBaseBuilder((KieBaseModel)kBaseModel, kBaseConf).createKieBase(kpkgs);
        this.registerNonNativeResources(kBaseModel, kieProject, kieBase, buildContext);
        return kieBase;
    }

    public void afterKieBaseCreationUpdate(String name, InternalKnowledgeBase kBase) {
        List<Object> options;
        KnowledgeBuilder knowledgeBuilderForKieBase = this.getKnowledgeBuilderForKieBase(name);
        if (knowledgeBuilderForKieBase instanceof KnowledgeBuilderImpl) {
            KnowledgeBuilderImpl knowledgeBuilderForImpl = (KnowledgeBuilderImpl)knowledgeBuilderForKieBase;
            KnowledgeBuilderConfigurationImpl builderConfiguration = knowledgeBuilderForImpl.getBuilderConfiguration();
            options = Collections.singletonList(new KieBaseUpdaterOptions.OptionEntry(AlphaNetworkCompilerOption.class, (Option)builderConfiguration.getOption(AlphaNetworkCompilerOption.KEY)));
        } else {
            options = this.resourceFileExists(CanonicalKieModule.getANCFile(this.internalKieModule.getReleaseId())) ? Collections.singletonList(new KieBaseUpdaterOptions.OptionEntry(AlphaNetworkCompilerOption.class, (Option)AlphaNetworkCompilerOption.LOAD)) : Collections.emptyList();
        }
        KieContainerImpl.CompositeRunnable compositeUpdater = new KieContainerImpl.CompositeRunnable();
        KieBaseUpdaters updaters = (KieBaseUpdaters)KieService.load(KieBaseUpdaters.class);
        updaters.getChildren().stream().map(kbu -> kbu.create(new KieBaseUpdatersContext(new KieBaseUpdaterOptions(options), kBase.getRete(), kBase.getRootClassLoader()))).forEach(arg_0 -> ((KieContainerImpl.CompositeRunnable)compositeUpdater).add(arg_0));
        compositeUpdater.run();
    }

    private void registerNonNativeResources(KieBaseModelImpl kBaseModel, KieProject kieProject, InternalKnowledgeBase kieBase, BuildContext buildContext) {
        KnowledgeBuilder kbuilder = this.getKnowledgeBuilderForKieBase(kBaseModel.getName());
        if (kbuilder == null) {
            kbuilder = kieProject.buildKnowledgePackages(kBaseModel, buildContext, NON_MODEL_RESOURCES);
        }
        if (!kbuilder.hasErrors()) {
            for (KiePackage pk : kbuilder.getKnowledgePackages()) {
                boolean isInternalKnowldgePackage = pk instanceof InternalKnowledgePackage;
                InternalKnowledgePackage originalPackage = kieBase.getPackage(pk.getName());
                if (originalPackage != null && isInternalKnowldgePackage && ((InternalKnowledgePackage)pk).getResourceTypePackages().get(ResourceType.PMML) != null) {
                    originalPackage.getResourceTypePackages().put(ResourceType.PMML, ((InternalKnowledgePackage)pk).getResourceTypePackages().get(ResourceType.PMML));
                    continue;
                }
                if (originalPackage != null) continue;
                kieBase.addPackage(pk);
            }
        }
    }

    private CanonicalKiePackages createKiePackages(KieProject kieProject, KieBaseModelImpl kBaseModel, BuildContext buildContext, KieBaseConfiguration conf) {
        Collection<Model> modelsForKBase;
        Set includes = kieProject == null ? Collections.emptySet() : kieProject.getTransitiveIncludes((KieBaseModel)kBaseModel);
        List<Process> processes = this.findProcesses(this.internalKieModule, kBaseModel);
        if (includes.isEmpty()) {
            modelsForKBase = this.getModelForKBase(kBaseModel);
        } else {
            modelsForKBase = new ArrayList<Model>(this.getModelForKBase(kBaseModel));
            for (String include : includes) {
                String text;
                if (StringUtils.isEmpty((CharSequence)include)) continue;
                InternalKieModule includeModule = kieProject.getKieModuleForKBase(include);
                if (includeModule == null) {
                    text = "Unable to build KieBase, could not find include: " + include;
                    buildContext.getMessages().addMessage(Message.Level.ERROR, KieModuleModelImpl.KMODULE_SRC_PATH.asString(), text).setKieBaseName(kBaseModel.getName());
                    continue;
                }
                if (!(includeModule instanceof CanonicalKieModule)) {
                    text = "It is not possible to mix drl based and executable model based projects. Found a drl project: " + include;
                    buildContext.getMessages().addMessage(Message.Level.ERROR, KieModuleModelImpl.KMODULE_SRC_PATH.asString(), text).setKieBaseName(kBaseModel.getName());
                    continue;
                }
                KieBaseModelImpl includeKBaseModel = (KieBaseModelImpl)kieProject.getKieBaseModel(include);
                CanonicalKieModule canonicalInclude = (CanonicalKieModule)includeModule;
                canonicalInclude.setModuleClassLoader((ProjectClassLoader)kieProject.getClassLoader());
                modelsForKBase.addAll(canonicalInclude.getModelForKBase(includeKBaseModel));
                processes.addAll(this.findProcesses(includeModule, includeKBaseModel));
            }
        }
        CanonicalKiePackages canonicalKiePkgs = new KiePackagesBuilder(conf, this.getBuilderConfiguration(kBaseModel), modelsForKBase).build();
        CanonicalKiePackages canonicalKiePackages = this.mergeProcesses(processes, canonicalKiePkgs);
        modelsForKBase.clear();
        this.models.clear();
        return canonicalKiePackages;
    }

    private KnowledgeBuilderConfiguration getBuilderConfiguration(KieBaseModelImpl kBaseModel) {
        KnowledgeBuilder builder = this.getKnowledgeBuilderForKieBase(kBaseModel.getName());
        return builder != null ? ((DroolsAssemblerContext)builder).getBuilderConfiguration() : this.createBuilderConfiguration((KieBaseModel)kBaseModel, (ClassLoader)this.moduleClassLoader);
    }

    private CanonicalKiePackages mergeProcesses(List<Process> processes, CanonicalKiePackages canonicalKiePkgs) {
        for (Process process : processes) {
            InternalKnowledgePackage canonicalKiePkg = (InternalKnowledgePackage)canonicalKiePkgs.getKiePackage(process.getPackageName());
            if (canonicalKiePkg == null) {
                canonicalKiePkg = CoreComponentFactory.get().createKnowledgePackage(process.getPackageName());
                canonicalKiePkgs.addKiePackage(canonicalKiePkg);
            }
            canonicalKiePkg.addProcess(process);
        }
        return canonicalKiePkgs;
    }

    private List<Process> findProcesses(InternalKieModule kieModule, KieBaseModelImpl kBaseModel) {
        ArrayList<Process> processes;
        block4: {
            Collection pkgs;
            block3: {
                processes = new ArrayList<Process>();
                pkgs = kieModule.getKnowledgePackagesForKieBase(kBaseModel.getName());
                if (pkgs != null) break block3;
                List processResources = kieModule.getFileNames().stream().filter(fileName -> {
                    ResourceType resourceType = ResourceType.determineResourceType((String)fileName);
                    return resourceType == ResourceType.BPMN2;
                }).map(fileName -> {
                    InternalResource processResource = kieModule.getResource(fileName);
                    processResource.setResourceType(ResourceType.determineResourceType((String)fileName));
                    return processResource;
                }).collect(Collectors.toList());
                if (processResources.isEmpty()) break block4;
                KnowledgeBuilderImpl kbuilder = (KnowledgeBuilderImpl)KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)this.createBuilderConfiguration((KieBaseModel)kBaseModel, (ClassLoader)this.moduleClassLoader));
                for (Resource processResource : processResources) {
                    kbuilder.add(processResource, processResource.getResourceType());
                }
                for (InternalKnowledgePackage knowledgePackage : kbuilder.getPackages()) {
                    processes.addAll(knowledgePackage.getProcesses());
                }
                break block4;
            }
            for (KiePackage pkg : pkgs) {
                processes.addAll(pkg.getProcesses());
            }
        }
        return processes;
    }

    public CanonicalKiePackages getKiePackages(KieBaseModelImpl kBaseModel) {
        return this.pkgsInKbase.computeIfAbsent(kBaseModel.getName(), k -> this.createKiePackages(null, kBaseModel, null, CanonicalKieModule.getKnowledgeBaseConfiguration(kBaseModel, (ClassLoader)this.getModuleClassLoader())));
    }

    public ProjectClassLoader getModuleClassLoader() {
        if (this.moduleClassLoader == null) {
            this.moduleClassLoader = this.createModuleClassLoader(null);
            this.moduleClassLoader.storeClasses(this.getClassesMap());
        }
        return this.moduleClassLoader;
    }

    public void setModuleClassLoader(ProjectClassLoader moduleClassLoader) {
        this.pkgsInKbase.clear();
        this.models.clear();
        this.moduleClassLoader = moduleClassLoader;
    }

    public void setIncrementalUpdate(boolean incrementalUpdate) {
        this.incrementalUpdate = incrementalUpdate;
    }

    private Map<String, Model> getModels() {
        if (this.models.isEmpty()) {
            if (!this.incrementalUpdate) {
                try {
                    this.initModels(this.getModuleModel());
                    return this.models;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            try {
                this.initModelsFromProjectDescriptor();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return this.models;
    }

    private void initModelsFromProjectDescriptor() throws ClassNotFoundException {
        for (String rulesFile : this.getRuleClassNames()) {
            Model model = (Model)CanonicalKieModule.createInstance((ClassLoader)this.getModuleClassLoader(), rulesFile);
            this.models.put(model.getName(), model);
        }
    }

    private void initModels(CanonicalKieModuleModel kmodel) throws ClassNotFoundException {
        if (kmodel != null) {
            this.ruleClassesNames = new ArrayList<String>();
            for (Model model : kmodel.getModels()) {
                this.models.put(model.getName(), model);
                this.ruleClassesNames.add(model.getClass().getCanonicalName());
            }
        } else {
            this.initModelsFromProjectDescriptor();
        }
    }

    private Collection<String> getRuleClassNames() {
        if (this.ruleClassesNames == null) {
            this.ruleClassesNames = this.findRuleClassesNames();
        }
        return this.ruleClassesNames;
    }

    public Collection<Model> getModelForKBase(KieBaseModelImpl kBaseModel) {
        Map<String, Model> modelsMap = this.getModels();
        if (kBaseModel.getPackages().isEmpty()) {
            return modelsMap.values();
        }
        ArrayList<Model> models = new ArrayList<Model>();
        for (String pkg : kBaseModel.getPackages()) {
            if (pkg.equals("*")) {
                return modelsMap.values();
            }
            Model model = modelsMap.get(pkg);
            if (model == null) continue;
            models.add(model);
        }
        return models;
    }

    public boolean hasModelFile() {
        return this.resourceFileExists(CanonicalKieModule.getModelFileWithGAV(this.internalKieModule.getReleaseId()));
    }

    private Collection<String> findRuleClassesNames() {
        ReleaseId releaseId = this.internalKieModule.getReleaseId();
        String modelFiles = this.readExistingResourceWithName(CanonicalKieModule.getModelFileWithGAV(releaseId));
        String[] lines = modelFiles.split("\n");
        String header = lines[0];
        if (!header.startsWith(MODEL_VERSION)) {
            throw new RuntimeException("Malformed drools-model file");
        }
        String version = header.substring(MODEL_VERSION.length());
        if (!CanonicalKieModule.areModelVersionsCompatible(Drools.getFullVersion(), version)) {
            throw new RuntimeException("Kjar compiled with version " + version + " is not compatible with current runtime version " + Drools.getFullVersion());
        }
        return Stream.of(lines).skip(1L).collect(Collectors.toList());
    }

    private Set<String> findGeneratedClassNamesWithDependencies() {
        HashSet<String> generatedClassNames = new HashSet<String>(this.findGeneratedClassNames(this.internalKieModule));
        Map kieDependencies = this.internalKieModule.getKieDependencies();
        kieDependencies.values().forEach(depKieModule -> generatedClassNames.addAll(this.findGeneratedClassNames((InternalKieModule)depKieModule)));
        return generatedClassNames;
    }

    private Set<String> findGeneratedClassNames(InternalKieModule kieModule) {
        String generatedClassNamesFile = CanonicalKieModule.getGeneratedClassNamesFile(kieModule.getReleaseId());
        if (!kieModule.hasResource(generatedClassNamesFile)) {
            return new HashSet<String>();
        }
        String content = this.readExistingResourceWithName(kieModule, generatedClassNamesFile);
        if (content.trim().isEmpty()) {
            return new HashSet<String>();
        }
        String[] lines = content.split("\n");
        return Stream.of(lines).collect(Collectors.toSet());
    }

    private String readExistingResourceWithName(String fileName) {
        return this.readExistingResourceWithName(this.internalKieModule, fileName);
    }

    private String readExistingResourceWithName(InternalKieModule kieModule, String fileName) {
        String modelFiles;
        try {
            InternalResource modelFile = kieModule.getResource(fileName);
            modelFiles = new String(IoUtils.readBytesFromInputStream((InputStream)modelFile.getInputStream()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return modelFiles;
    }

    private boolean resourceFileExists(String fileName) {
        InternalResource modelFile = this.internalKieModule.getResource(fileName);
        return modelFile != null;
    }

    public KieJarChangeSet getChanges(InternalKieModule newKieModule) {
        KieJarChangeSet result = this.findChanges(newKieModule);
        Map<String, Model> oldModels = this.getModels();
        Map<String, Model> newModels = ((CanonicalKieModule)newKieModule).getModels();
        for (Map.Entry<String, Model> entry : oldModels.entrySet()) {
            Model newModel = newModels.get(entry.getKey());
            if (newModel == null) {
                result.registerChanges(entry.getKey(), this.buildAllItemsChangeSet(entry.getValue(), ChangeType.REMOVED));
                continue;
            }
            Model oldModel = entry.getValue();
            for (ResourceChangeSet changeSet : this.calculateResourceChangeSet(oldModel, newModel)) {
                if (changeSet.getChanges().isEmpty()) continue;
                result.registerChanges(entry.getKey(), changeSet);
            }
        }
        for (Map.Entry<String, Model> entry : newModels.entrySet()) {
            if (oldModels.get(entry.getKey()) != null) continue;
            result.registerChanges(entry.getKey(), this.buildAllItemsChangeSet(entry.getValue(), ChangeType.ADDED));
        }
        KieJarChangeSet internalChanges = this.internalKieModule.getChanges(((CanonicalKieModule)newKieModule).internalKieModule);
        internalChanges.removeFile(this.getProjectModelResourceName());
        return result.merge(internalChanges);
    }

    private ResourceChangeSet buildAllItemsChangeSet(Model oldModel, ChangeType changeType) {
        ResourceChangeSet changeSet = new ResourceChangeSet(oldModel.getName(), ChangeType.UPDATED);
        for (NamedModelItem item : oldModel.getRules()) {
            changeSet.getChanges().add(new ResourceChange(changeType, ResourceChange.Type.RULE, item.getName()));
        }
        for (NamedModelItem item : oldModel.getQueries()) {
            changeSet.getChanges().add(new ResourceChange(changeType, ResourceChange.Type.RULE, item.getName()));
        }
        for (NamedModelItem item : oldModel.getGlobals()) {
            changeSet.getChanges().add(new ResourceChange(changeType, ResourceChange.Type.GLOBAL, item.getName()));
        }
        for (NamedModelItem item : oldModel.getTypeMetaDatas()) {
            changeSet.getChanges().add(new ResourceChange(changeType, ResourceChange.Type.DECLARATION, item.getName()));
        }
        return changeSet;
    }

    private KieJarChangeSet findChanges(InternalKieModule newKieModule) {
        KieJarChangeSet result = new KieJarChangeSet();
        Collection<String> oldFiles = this.getFileNames();
        Collection newFiles = newKieModule.getFileNames();
        ArrayList<String> removedFiles = new ArrayList<String>(oldFiles);
        removedFiles.removeAll(newFiles);
        if (!removedFiles.isEmpty()) {
            for (String file : removedFiles) {
                if (!this.isChange(file, this)) continue;
                result.removeFile(file);
            }
        }
        for (String file : newFiles) {
            if (oldFiles.contains(file) && this.isChange(file, this)) {
                if (!this.isClassChanged(newKieModule, file)) continue;
                result.registerChanges(file, new ResourceChangeSet(file, ChangeType.UPDATED));
                continue;
            }
            if (!this.isChange(file, (CanonicalKieModule)newKieModule)) continue;
            result.addFile(file);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isChange(String fileName, CanonicalKieModule module) {
        if (!fileName.endsWith(".class")) return false;
        if (fileName.equals(this.getProjectModelResourceName())) return false;
        if (!module.getRuleClassNames().stream().noneMatch(StringUtil.fileNameToClass(fileName)::startsWith)) return false;
        return true;
    }

    private boolean isClassChanged(InternalKieModule newKieModule, String file) {
        byte[] oldBytes = this.getBytes(file);
        return new String(oldBytes).contains(GENERATED_FACT_MARKER) || !Arrays.equals(oldBytes, newKieModule.getBytes(file));
    }

    private Collection<ResourceChangeSet> calculateResourceChangeSet(Model oldModel, Model newModel) {
        ResourceChangeSet changeSet = new ResourceChangeSet(oldModel.getName(), ChangeType.UPDATED);
        changeSet.setPackageName(oldModel.getName());
        HashMap<String, ResourceChangeSet> changes = new HashMap<String, ResourceChangeSet>();
        changes.put(oldModel.getName(), changeSet);
        this.addModifiedItemsToChangeSet(changeSet, ResourceChange.Type.RULE, oldModel.getRules(), newModel.getRules());
        this.addModifiedItemsToChangeSet(changeSet, ResourceChange.Type.RULE, oldModel.getQueries(), newModel.getQueries());
        this.addModifiedItemsToChangeSet(changeSet, ResourceChange.Type.GLOBAL, oldModel.getGlobals(), newModel.getGlobals());
        this.addModifiedItemsToChangeSet(changeSet, changes, ResourceChange.Type.DECLARATION, oldModel.getTypeMetaDatas(), newModel.getTypeMetaDatas());
        return changes.values();
    }

    private void addModifiedItemsToChangeSet(ResourceChangeSet changeSet, ResourceChange.Type type, List<? extends NamedModelItem> oldItems, List<? extends NamedModelItem> newItems) {
        this.addModifiedItemsToChangeSet(changeSet, null, type, oldItems, newItems);
    }

    private void addModifiedItemsToChangeSet(ResourceChangeSet mainChangeSet, Map<String, ResourceChangeSet> changes, ResourceChange.Type type, List<? extends NamedModelItem> oldItems, List<? extends NamedModelItem> newItems) {
        Iterator<? extends NamedModelItem> iterator;
        Iterator<? extends NamedModelItem> oldRulesIterator;
        block14: {
            if (oldItems.isEmpty()) {
                if (!newItems.isEmpty()) {
                    for (NamedModelItem namedModelItem : newItems) {
                        this.registerChange(mainChangeSet, changes, type, ChangeType.ADDED, namedModelItem);
                    }
                }
                return;
            }
            if (newItems.isEmpty()) {
                for (NamedModelItem namedModelItem : oldItems) {
                    this.registerChange(mainChangeSet, changes, type, ChangeType.REMOVED, namedModelItem);
                }
                return;
            }
            oldItems.sort(Comparator.comparing(NamedModelItem::getName));
            newItems.sort(Comparator.comparing(NamedModelItem::getName));
            oldRulesIterator = oldItems.iterator();
            iterator = newItems.iterator();
            NamedModelItem currentOld = oldRulesIterator.next();
            NamedModelItem currentNew = iterator.next();
            while (true) {
                int compare;
                if ((compare = currentOld.getName().compareTo(currentNew.getName())) == 0) {
                    if (!ModelComponent.areEqualInModel((Object)currentOld, (Object)currentNew)) {
                        this.registerChange(mainChangeSet, changes, type, ChangeType.UPDATED, currentOld);
                    }
                    if (oldRulesIterator.hasNext()) {
                        currentOld = oldRulesIterator.next();
                        if (iterator.hasNext()) {
                            currentNew = iterator.next();
                            continue;
                        }
                        this.registerChange(mainChangeSet, changes, type, ChangeType.REMOVED, currentOld);
                    }
                    break block14;
                }
                if (compare < 0) {
                    this.registerChange(mainChangeSet, changes, type, ChangeType.REMOVED, currentOld);
                    if (oldRulesIterator.hasNext()) {
                        currentOld = oldRulesIterator.next();
                        continue;
                    }
                    this.registerChange(mainChangeSet, changes, type, ChangeType.ADDED, currentNew);
                    break block14;
                }
                this.registerChange(mainChangeSet, changes, type, ChangeType.ADDED, currentNew);
                if (!iterator.hasNext()) break;
                currentNew = iterator.next();
            }
            this.registerChange(mainChangeSet, changes, type, ChangeType.REMOVED, currentOld);
        }
        while (oldRulesIterator.hasNext()) {
            this.registerChange(mainChangeSet, changes, type, ChangeType.REMOVED, oldRulesIterator.next());
        }
        while (iterator.hasNext()) {
            this.registerChange(mainChangeSet, changes, type, ChangeType.ADDED, iterator.next());
        }
    }

    private void registerChange(ResourceChangeSet mainChangeSet, Map<String, ResourceChangeSet> changes, ResourceChange.Type resourceChangeType, ChangeType changeType, NamedModelItem item) {
        this.getChangeSetForItem(mainChangeSet, changes, item).getChanges().add(new ResourceChange(changeType, resourceChangeType, item.getName()));
    }

    private ResourceChangeSet getChangeSetForItem(ResourceChangeSet mainChangeSet, Map<String, ResourceChangeSet> changes, NamedModelItem item) {
        return changes != null ? changes.computeIfAbsent(item.getPackage(), pkg -> new ResourceChangeSet(pkg, ChangeType.UPDATED)) : mainChangeSet;
    }

    public KieBaseUpdater createKieBaseUpdater(KieBaseUpdaterImplContext context) {
        return new CanonicalKieBaseUpdater(context);
    }

    public void updateKieModule(InternalKieModule newKM) {
        CanonicalKieModule newCanonicalKieModule = (CanonicalKieModule)newKM;
        newCanonicalKieModule.setModuleClassLoader(this.getModuleClassLoader());
    }

    public InternalKieModule getInternalKieModule() {
        return this.internalKieModule;
    }

    public CanonicalKieModule cloneForIncrementalCompilation(ReleaseId releaseId, KieModuleModel kModuleModel, MemoryFileSystem newFs) {
        MemoryKieModule clonedInternal = ((MemoryKieModule)this.internalKieModule).cloneForIncrementalCompilation(releaseId, kModuleModel, newFs);
        return new CanonicalKieModule((InternalKieModule)clonedInternal);
    }

    public void cacheKnowledgeBuilderForKieBase(String kieBaseName, KnowledgeBuilder kbuilder) {
        this.internalKieModule.cacheKnowledgeBuilderForKieBase(kieBaseName, kbuilder);
    }

    public KnowledgeBuilder getKnowledgeBuilderForKieBase(String kieBaseName) {
        return this.internalKieModule.getKnowledgeBuilderForKieBase(kieBaseName);
    }

    public InternalKnowledgePackage getPackage(String packageName) {
        return this.internalKieModule.getPackage(packageName);
    }

    public Collection<KiePackage> getKnowledgePackagesForKieBase(String kieBaseName) {
        return this.internalKieModule.getKnowledgePackagesForKieBase(kieBaseName);
    }

    public void cacheResultsForKieBase(String kieBaseName, Results results) {
        this.internalKieModule.cacheResultsForKieBase(kieBaseName, results);
    }

    public Map<String, Results> getKnowledgeResultsCache() {
        return this.internalKieModule.getKnowledgeResultsCache();
    }

    public KieModuleModel getKieModuleModel() {
        return this.internalKieModule.getKieModuleModel();
    }

    public byte[] getBytes() {
        return this.internalKieModule.getBytes();
    }

    public boolean hasResource(String fileName) {
        return this.internalKieModule.hasResource(fileName);
    }

    public InternalResource getResource(String fileName) {
        return this.internalKieModule.getResource(fileName);
    }

    public ResourceConfiguration getResourceConfiguration(String fileName) {
        return this.internalKieModule.getResourceConfiguration(fileName);
    }

    public Map<ReleaseId, InternalKieModule> getKieDependencies() {
        return this.internalKieModule.getKieDependencies();
    }

    public void addKieDependency(InternalKieModule dependency) {
        this.internalKieModule.addKieDependency(dependency);
    }

    public Collection<ReleaseId> getJarDependencies(DependencyFilter filter) {
        return this.internalKieModule.getJarDependencies(filter);
    }

    public Collection<ReleaseId> getUnresolvedDependencies() {
        return this.internalKieModule.getUnresolvedDependencies();
    }

    public void setUnresolvedDependencies(Collection<ReleaseId> unresolvedDependencies) {
        this.internalKieModule.setUnresolvedDependencies(unresolvedDependencies);
    }

    public boolean isAvailable(String pResourceName) {
        return this.internalKieModule.isAvailable(pResourceName);
    }

    public byte[] getBytes(String pResourceName) {
        return this.internalKieModule.getBytes(pResourceName);
    }

    public byte[] getBytes(PortablePath resourcePath) {
        return this.internalKieModule.getBytes(resourcePath);
    }

    public Collection<String> getFileNames() {
        return this.internalKieModule.getFileNames();
    }

    public File getFile() {
        return this.internalKieModule.getFile();
    }

    public ResourceProvider createResourceProvider() {
        return this.internalKieModule.createResourceProvider();
    }

    public boolean addResourceToCompiler(CompositeKnowledgeBuilder ckbuilder, KieBaseModel kieBaseModel, String fileName) {
        return this.internalKieModule.addResourceToCompiler(ckbuilder, kieBaseModel, fileName);
    }

    public boolean addResourceToCompiler(CompositeKnowledgeBuilder ckbuilder, KieBaseModel kieBaseModel, String fileName, ResourceChangeSet rcs) {
        return this.internalKieModule.addResourceToCompiler(ckbuilder, kieBaseModel, fileName, rcs);
    }

    public long getCreationTimestamp() {
        return this.internalKieModule.getCreationTimestamp();
    }

    public InputStream getPomAsStream() {
        return this.internalKieModule.getPomAsStream();
    }

    public PomModel getPomModel() {
        return this.internalKieModule.getPomModel();
    }

    public KnowledgeBuilderConfiguration createBuilderConfiguration(KieBaseModel kBaseModel, ClassLoader classLoader) {
        return this.internalKieModule.createBuilderConfiguration(kBaseModel, classLoader);
    }

    public ReleaseId getReleaseId() {
        return this.internalKieModule.getReleaseId();
    }

    public boolean isVerifiable() {
        return false;
    }
}

