/*
 * Decompiled with CFR 0.152.
 */
package org.drools.codegen.common.di.impl;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.ConditionalExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.TypeExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.drools.codegen.common.di.DependencyInjectionAnnotator;

public class SpringDependencyInjectionAnnotator
implements DependencyInjectionAnnotator {
    @Override
    public <T extends NodeWithAnnotations<?>> T withProduces(T node, boolean isDefault) {
        node.addAnnotation("org.springframework.context.annotation.Bean");
        if (isDefault) {
            node.addAnnotation("org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean");
        }
        return node;
    }

    @Override
    public <T extends NodeWithAnnotations<?>> T withNamed(T node, String name) {
        node.addAnnotation((AnnotationExpr)new SingleMemberAnnotationExpr(new Name("org.springframework.beans.factory.annotation.Qualifier"), (Expression)new StringLiteralExpr(name)));
        return node;
    }

    @Override
    public <T extends NodeWithAnnotations<?>> T withApplicationComponent(T node) {
        node.addAnnotation("org.springframework.stereotype.Component");
        return node;
    }

    @Override
    public <T extends NodeWithAnnotations<?>> T withNamedApplicationComponent(T node, String name) {
        node.addAnnotation((AnnotationExpr)new SingleMemberAnnotationExpr(new Name("org.springframework.stereotype.Component"), (Expression)new StringLiteralExpr(name)));
        return node;
    }

    @Override
    public <T extends NodeWithAnnotations<?>> T withSingletonComponent(T node) {
        return this.withApplicationComponent(node);
    }

    @Override
    public <T extends NodeWithAnnotations<?>> T withNamedSingletonComponent(T node, String name) {
        return this.withNamedApplicationComponent(node, name);
    }

    @Override
    public <T extends NodeWithAnnotations<?>> T withInjection(T node, boolean lazy) {
        node.addAnnotation("org.springframework.beans.factory.annotation.Autowired");
        if (lazy) {
            node.addAnnotation("org.springframework.context.annotation.Lazy");
        }
        return node;
    }

    @Override
    public <T extends NodeWithAnnotations<?>> T withNamedInjection(T node, String name) {
        return this.withNamed(this.withInjection(node), name);
    }

    @Override
    public <T extends NodeWithAnnotations<?>> T withOptionalInjection(T node) {
        node.addAnnotation((AnnotationExpr)new NormalAnnotationExpr(new Name("org.springframework.beans.factory.annotation.Autowired"), NodeList.nodeList((Node[])new MemberValuePair[]{new MemberValuePair("required", (Expression)new BooleanLiteralExpr(false))})));
        node.addAnnotation("org.springframework.context.annotation.Lazy");
        return node;
    }

    @Override
    public <T extends NodeWithAnnotations<?>> T withIncomingMessage(T node, String channel) {
        node.addAnnotation((AnnotationExpr)new NormalAnnotationExpr(new Name("org.springframework.kafka.annotation.KafkaListener"), NodeList.nodeList((Node[])new MemberValuePair[]{new MemberValuePair("topics", (Expression)new StringLiteralExpr(channel))})));
        return node;
    }

    @Override
    public <T extends NodeWithAnnotations<?>> T withOutgoingMessage(T node, String channel) {
        return node;
    }

    @Override
    public MethodCallExpr withMessageProducer(MethodCallExpr produceMethod, String channel, Expression event) {
        ((MethodCallExpr)produceMethod.addArgument((Expression)new StringLiteralExpr(channel))).addArgument(event);
        return produceMethod;
    }

    @Override
    public String optionalInstanceInjectionType() {
        return Optional.class.getCanonicalName();
    }

    @Override
    public Expression optionalInstanceExists(String fieldName) {
        return new MethodCallExpr((Expression)new NameExpr(fieldName), "isPresent");
    }

    @Override
    public String multiInstanceInjectionType() {
        return Collection.class.getCanonicalName();
    }

    @Override
    public Expression getMultiInstance(String fieldName) {
        return new ConditionalExpr((Expression)new BinaryExpr((Expression)new NameExpr(fieldName), (Expression)new NullLiteralExpr(), BinaryExpr.Operator.NOT_EQUALS), (Expression)new NameExpr(fieldName), (Expression)new MethodCallExpr((Expression)new TypeExpr((Type)new ClassOrInterfaceType(null, Collections.class.getCanonicalName())), "emptyList"));
    }

    @Override
    public String applicationComponentType() {
        return "org.springframework.stereotype.Component";
    }

    @Override
    public String emitterType(String dataType) {
        return "org.springframework.kafka.core.KafkaTemplate<String, " + dataType + ">";
    }

    @Override
    public <T extends NodeWithAnnotations<?>> T withConfigInjection(T node, String configKey) {
        node.addAnnotation((AnnotationExpr)new SingleMemberAnnotationExpr(new Name("org.springframework.beans.factory.annotation.Value"), (Expression)new StringLiteralExpr("${" + configKey + ":#{null}}")));
        return node;
    }

    @Override
    public <T extends NodeWithAnnotations<?>> T withConfigInjection(T node, String configKey, String defaultValue) {
        node.addAnnotation((AnnotationExpr)new SingleMemberAnnotationExpr(new Name("org.springframework.beans.factory.annotation.Value"), (Expression)new StringLiteralExpr("${" + configKey + ":" + defaultValue + "}")));
        return node;
    }

    @Override
    public <T extends NodeWithAnnotations<?>> T withEagerStartup(T node) {
        return node;
    }

    @Override
    public <T extends NodeWithAnnotations<?>> T withFactoryClass(T node) {
        node.addAnnotation("org.springframework.context.annotation.Configuration");
        return node;
    }

    @Override
    public String getTransactionalAnnotation() {
        return "org.springframework.transaction.annotation.Transactional";
    }

    @Override
    public <T extends NodeWithAnnotations<?>> T withFactoryMethod(T node) {
        node.addAnnotation("org.springframework.context.annotation.Bean");
        return node;
    }
}

