/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.rule.accessor;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import org.drools.base.base.AcceptsClassObjectType;
import org.drools.base.base.ClassObjectType;
import org.drools.base.base.ObjectType;
import org.drools.base.base.ValueResolver;
import org.drools.base.base.extractors.BaseObjectClassFieldReader;
import org.drools.base.rule.accessor.ReadAccessor;
import org.drools.util.ClassUtils;
import org.kie.api.prototype.PrototypeFactInstance;

public class GlobalExtractor
extends BaseObjectClassFieldReader
implements ReadAccessor,
AcceptsClassObjectType,
Externalizable {
    private static final long serialVersionUID = 510L;
    private ObjectType objectType;
    private String identifier;

    public GlobalExtractor() {
    }

    public GlobalExtractor(String identifier, ObjectType objectType) {
        super(-1, ((ClassObjectType)objectType).getClassType(), objectType.getValueType());
        this.identifier = identifier;
        this.objectType = objectType;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.identifier = in.readUTF();
        this.objectType = (ObjectType)in.readObject();
        this.setIndex(-1);
        this.setFieldType(((ClassObjectType)this.objectType).getClassType());
        this.setValueType(this.objectType.getValueType());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.identifier);
        out.writeObject(this.objectType);
    }

    @Override
    public void setClassObjectType(ClassObjectType objectType) {
        this.objectType = objectType;
        this.setIndex(-1);
        this.setFieldType(objectType.getClassType());
        this.setValueType(objectType.getValueType());
    }

    @Override
    public Object getValue(ValueResolver valueResolver, Object object) {
        return valueResolver.getGlobal(this.identifier);
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    @Override
    public Class<?> getExtractToClass() {
        ObjectType objectType = this.objectType;
        if (objectType instanceof ClassObjectType) {
            ClassObjectType cot = (ClassObjectType)objectType;
            return cot.getClassType();
        }
        return PrototypeFactInstance.class;
    }

    @Override
    public String getExtractToClassName() {
        Class clazz;
        ObjectType objectType = this.objectType;
        if (objectType instanceof ClassObjectType) {
            ClassObjectType cot = (ClassObjectType)objectType;
            clazz = cot.getClassType();
        } else {
            clazz = PrototypeFactInstance.class;
        }
        return ClassUtils.canonicalName(clazz);
    }

    @Override
    public Method getNativeReadMethod() {
        try {
            return this.getClass().getDeclaredMethod("getValue", ValueResolver.class, Object.class);
        }
        catch (Exception e) {
            throw new RuntimeException("This is a bug. Please report to development team: " + e.getMessage(), e);
        }
    }

    @Override
    public String getNativeReadMethodName() {
        return "getValue";
    }

    @Override
    public int hashCode() {
        return this.objectType.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GlobalExtractor)) {
            return false;
        }
        GlobalExtractor other = (GlobalExtractor)obj;
        if (!this.identifier.equals(other.identifier)) {
            return false;
        }
        return this.objectType.equals(other.objectType);
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    @Override
    public boolean isSelfReference() {
        return false;
    }

    @Override
    public int getHashCode(Object object) {
        throw new RuntimeException("Can't extract a value from global " + this.identifier + " without a working memory reference");
    }

    @Override
    public int getIndex() {
        return -1;
    }

    @Override
    public Object getValue(Object object) {
        throw new RuntimeException("Can't extract a value from global " + this.identifier + " without a working memory reference");
    }
}

