/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.interval;

import org.apache.flink.streaming.api.functions.co.KeyedCoProcessFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.interval.IntervalJoinFunction;
import org.apache.flink.table.runtime.operators.join.interval.TimeIntervalJoin;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;

public final class RowTimeIntervalJoin
extends TimeIntervalJoin {
    private static final long serialVersionUID = -2923709329817468698L;
    private final int leftTimeIdx;
    private final int rightTimeIdx;

    public RowTimeIntervalJoin(FlinkJoinType joinType, long leftLowerBound, long leftUpperBound, long allowedLateness, long minCleanUpInterval, InternalTypeInfo<RowData> leftType, InternalTypeInfo<RowData> rightType, IntervalJoinFunction joinFunc, int leftTimeIdx, int rightTimeIdx) {
        super(joinType, leftLowerBound, leftUpperBound, allowedLateness, minCleanUpInterval, leftType, rightType, joinFunc);
        this.leftTimeIdx = leftTimeIdx;
        this.rightTimeIdx = rightTimeIdx;
    }

    public long getMaxOutputDelay() {
        return Math.max(this.leftRelativeSize, this.rightRelativeSize) + this.allowedLateness;
    }

    @Override
    void updateOperatorTime(KeyedCoProcessFunction.Context ctx) {
        this.rightOperatorTime = this.leftOperatorTime = ctx.timerService().currentWatermark() > 0L ? ctx.timerService().currentWatermark() : 0L;
    }

    @Override
    long getTimeForLeftStream(KeyedCoProcessFunction.Context ctx, RowData row) {
        return row.getLong(this.leftTimeIdx);
    }

    @Override
    long getTimeForRightStream(KeyedCoProcessFunction.Context ctx, RowData row) {
        return row.getLong(this.rightTimeIdx);
    }

    @Override
    void registerTimer(KeyedCoProcessFunction.Context ctx, long cleanupTime) {
        ctx.timerService().registerEventTimeTimer(cleanupTime);
    }
}

