/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import org.apache.flink.api.common.typeutils.SerializerTestBase;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.runtime.typeutils.TimestampDataSerializer;

abstract class TimestampDataSerializerTest
extends SerializerTestBase<TimestampData> {
    TimestampDataSerializerTest() {
    }

    protected TypeSerializer<TimestampData> createSerializer() {
        return new TimestampDataSerializer(this.getPrecision());
    }

    protected int getLength() {
        return this.getPrecision() <= 3 ? 8 : 12;
    }

    protected Class<TimestampData> getTypeClass() {
        return TimestampData.class;
    }

    protected TimestampData[] getTestData() {
        return new TimestampData[]{TimestampData.fromEpochMillis((long)1L), TimestampData.fromEpochMillis((long)2L), TimestampData.fromEpochMillis((long)3L), TimestampData.fromEpochMillis((long)4L)};
    }

    protected abstract int getPrecision();

    static final class TimestampSerializer8Test
    extends TimestampDataSerializerTest {
        TimestampSerializer8Test() {
        }

        @Override
        protected int getPrecision() {
            return 8;
        }
    }

    static final class TimestampSerializer6Test
    extends TimestampDataSerializerTest {
        TimestampSerializer6Test() {
        }

        @Override
        protected int getPrecision() {
            return 6;
        }
    }

    static final class TimestampSerializer3Test
    extends TimestampDataSerializerTest {
        TimestampSerializer3Test() {
        }

        @Override
        protected int getPrecision() {
            return 3;
        }
    }

    static final class TimestampSerializer0Test
    extends TimestampDataSerializerTest {
        TimestampSerializer0Test() {
        }

        @Override
        protected int getPrecision() {
            return 0;
        }
    }
}

