/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.wmassigners;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;
import org.apache.flink.table.data.RowData;
import org.assertj.core.api.Assertions;

abstract class WatermarkAssignerOperatorTestBase {
    WatermarkAssignerOperatorTestBase() {
    }

    protected Tuple2<Long, Long> validateElement(Object element, long nextElementValue, long currentWatermark) {
        if (element instanceof StreamRecord) {
            StreamRecord record = (StreamRecord)element;
            Assertions.assertThat((long)((RowData)record.getValue()).getLong(0)).isEqualTo(nextElementValue);
            return new Tuple2((Object)(nextElementValue + 1L), (Object)currentWatermark);
        }
        if (element instanceof Watermark) {
            long wt = ((Watermark)element).getTimestamp();
            Assertions.assertThat((long)wt).isGreaterThan(currentWatermark);
            return new Tuple2((Object)nextElementValue, (Object)wt);
        }
        throw new IllegalArgumentException("unrecognized element: " + element);
    }

    protected List<Watermark> extractWatermarks(Collection<Object> collection) {
        ArrayList<Watermark> watermarks = new ArrayList<Watermark>();
        for (Object obj : collection) {
            if (!(obj instanceof Watermark)) continue;
            watermarks.add((Watermark)obj);
        }
        return watermarks;
    }

    protected List<WatermarkStatus> extractWatermarkStatuses(Collection<Object> collection) {
        return collection.stream().filter(obj -> obj instanceof WatermarkStatus).map(obj -> (WatermarkStatus)obj).collect(Collectors.toList());
    }

    protected List<Object> filterOutRecords(Collection<Object> collection) {
        return collection.stream().filter(obj -> !(obj instanceof StreamElement) || !((StreamElement)obj).isRecord()).collect(Collectors.toList());
    }
}

