/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window.tvf.slicing;

import java.time.Duration;
import java.time.ZoneId;
import java.util.TimeZone;
import org.apache.flink.table.runtime.operators.window.tvf.slicing.SliceAssigner;
import org.apache.flink.table.runtime.operators.window.tvf.slicing.SliceAssignerTestBase;
import org.apache.flink.table.runtime.operators.window.tvf.slicing.SliceAssigners;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class TumblingSliceAssignerTest
extends SliceAssignerTestBase {
    TumblingSliceAssignerTest() {
    }

    @ParameterizedTest(name="timezone = {0}")
    @MethodSource(value={"zoneIds"})
    void testSliceAssignment(ZoneId zoneId) {
        SliceAssigners.TumblingSliceAssigner assigner = SliceAssigners.tumbling((int)0, (ZoneId)zoneId, (Duration)Duration.ofHours(5L));
        Assertions.assertThat((long)TumblingSliceAssignerTest.assignSliceEnd((SliceAssigner)assigner, this.localMills("1970-01-01T00:00:00", zoneId))).isEqualTo(this.utcMills("1970-01-01T05:00:00"));
        Assertions.assertThat((long)TumblingSliceAssignerTest.assignSliceEnd((SliceAssigner)assigner, this.localMills("1970-01-01T04:59:59.999", zoneId))).isEqualTo(this.utcMills("1970-01-01T05:00:00"));
        Assertions.assertThat((long)TumblingSliceAssignerTest.assignSliceEnd((SliceAssigner)assigner, this.localMills("1970-01-01T05:00:00", zoneId))).isEqualTo(this.utcMills("1970-01-01T10:00:00"));
    }

    @ParameterizedTest(name="timezone = {0}")
    @MethodSource(value={"zoneIds"})
    void testSliceAssignmentWithOffset(ZoneId zoneId) {
        SliceAssigners.TumblingSliceAssigner assigner = SliceAssigners.tumbling((int)0, (ZoneId)zoneId, (Duration)Duration.ofHours(5L)).withOffset(Duration.ofMillis(100L));
        Assertions.assertThat((long)TumblingSliceAssignerTest.assignSliceEnd((SliceAssigner)assigner, this.localMills("1970-01-01T00:00:00.1", zoneId))).isEqualTo(this.utcMills("1970-01-01T05:00:00.1"));
        Assertions.assertThat((long)TumblingSliceAssignerTest.assignSliceEnd((SliceAssigner)assigner, this.localMills("1970-01-01T05:00:00.099", zoneId))).isEqualTo(this.utcMills("1970-01-01T05:00:00.1"));
        Assertions.assertThat((long)TumblingSliceAssignerTest.assignSliceEnd((SliceAssigner)assigner, this.localMills("1970-01-01T05:00:00.1", zoneId))).isEqualTo(this.utcMills("1970-01-01T10:00:00.1"));
    }

    @ParameterizedTest(name="timezone = {0}")
    @MethodSource(value={"zoneIds"})
    void testDstSaving(ZoneId zoneId) {
        if (!TimeZone.getTimeZone(zoneId).useDaylightTime()) {
            return;
        }
        SliceAssigners.TumblingSliceAssigner assigner = SliceAssigners.tumbling((int)0, (ZoneId)zoneId, (Duration)Duration.ofHours(4L));
        long epoch1 = 1615708800000L;
        long epoch2 = 1615712400000L;
        long epoch3 = 1615716000000L;
        long epoch4 = 1615719600000L;
        TumblingSliceAssignerTest.assertSliceStartEnd("2021-03-14T00:00", "2021-03-14T04:00", epoch1, (SliceAssigner)assigner);
        TumblingSliceAssignerTest.assertSliceStartEnd("2021-03-14T00:00", "2021-03-14T04:00", epoch2, (SliceAssigner)assigner);
        TumblingSliceAssignerTest.assertSliceStartEnd("2021-03-14T00:00", "2021-03-14T04:00", epoch3, (SliceAssigner)assigner);
        TumblingSliceAssignerTest.assertSliceStartEnd("2021-03-14T04:00", "2021-03-14T08:00", epoch4, (SliceAssigner)assigner);
        long epoch5 = 1636268400000L;
        long epoch6 = 1636272000000L;
        long epoch7 = 1636275600000L;
        long epoch8 = 1636279200000L;
        long epoch9 = 1636282800000L;
        long epoch10 = 1636286400000L;
        TumblingSliceAssignerTest.assertSliceStartEnd("2021-11-07T00:00", "2021-11-07T04:00", epoch5, (SliceAssigner)assigner);
        TumblingSliceAssignerTest.assertSliceStartEnd("2021-11-07T00:00", "2021-11-07T04:00", epoch6, (SliceAssigner)assigner);
        TumblingSliceAssignerTest.assertSliceStartEnd("2021-11-07T00:00", "2021-11-07T04:00", epoch7, (SliceAssigner)assigner);
        TumblingSliceAssignerTest.assertSliceStartEnd("2021-11-07T00:00", "2021-11-07T04:00", epoch8, (SliceAssigner)assigner);
        TumblingSliceAssignerTest.assertSliceStartEnd("2021-11-07T00:00", "2021-11-07T04:00", epoch9, (SliceAssigner)assigner);
        TumblingSliceAssignerTest.assertSliceStartEnd("2021-11-07T04:00", "2021-11-07T08:00", epoch10, (SliceAssigner)assigner);
    }

    @ParameterizedTest(name="timezone = {0}")
    @MethodSource(value={"zoneIds"})
    void testGetWindowStart(ZoneId zoneId) {
        SliceAssigners.TumblingSliceAssigner assigner = SliceAssigners.tumbling((int)0, (ZoneId)zoneId, (Duration)Duration.ofHours(5L));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T00:00:00"))).isEqualTo(this.utcMills("1969-12-31T19:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T05:00:00"))).isEqualTo(this.utcMills("1970-01-01T00:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T10:00:00"))).isEqualTo(this.utcMills("1970-01-01T05:00:00"));
    }

    @ParameterizedTest(name="timezone = {0}")
    @MethodSource(value={"zoneIds"})
    void testExpiredSlices(ZoneId zoneId) {
        SliceAssigners.TumblingSliceAssigner assigner = SliceAssigners.tumbling((int)0, (ZoneId)zoneId, (Duration)Duration.ofHours(5L));
        Assertions.assertThat(TumblingSliceAssignerTest.expiredSlices((SliceAssigner)assigner, this.utcMills("1970-01-01T00:00:00"))).containsExactly((Object[])new Long[]{this.utcMills("1970-01-01T00:00:00")});
        Assertions.assertThat(TumblingSliceAssignerTest.expiredSlices((SliceAssigner)assigner, this.utcMills("1970-01-01T05:00:00"))).containsExactly((Object[])new Long[]{this.utcMills("1970-01-01T05:00:00")});
        Assertions.assertThat(TumblingSliceAssignerTest.expiredSlices((SliceAssigner)assigner, this.utcMills("1970-01-01T10:00:00"))).containsExactly((Object[])new Long[]{this.utcMills("1970-01-01T10:00:00")});
    }

    @ParameterizedTest(name="timezone = {0}")
    @MethodSource(value={"zoneIds"})
    void testEventTime(ZoneId zoneId) {
        SliceAssigners.TumblingSliceAssigner assigner1 = SliceAssigners.tumbling((int)0, (ZoneId)zoneId, (Duration)Duration.ofHours(5L));
        Assertions.assertThat((boolean)assigner1.isEventTime()).isTrue();
        SliceAssigners.TumblingSliceAssigner assigner2 = SliceAssigners.tumbling((int)-1, (ZoneId)zoneId, (Duration)Duration.ofHours(5L));
        Assertions.assertThat((boolean)assigner2.isEventTime()).isFalse();
    }

    @ParameterizedTest(name="timezone = {0}")
    @MethodSource(value={"zoneIds"})
    void testInvalidParameters(ZoneId zoneId) {
        TumblingSliceAssignerTest.assertErrorMessage(() -> SliceAssigners.tumbling((int)0, (ZoneId)zoneId, (Duration)Duration.ofSeconds(-1L)), "Tumbling Window parameters must satisfy size > 0, but got size -1000ms.");
        TumblingSliceAssignerTest.assertErrorMessage(() -> SliceAssigners.tumbling((int)0, (ZoneId)zoneId, (Duration)Duration.ofSeconds(10L)).withOffset(Duration.ofSeconds(20L)), "Tumbling Window parameters must satisfy abs(offset) < size, but got size 10000ms and offset 20000ms.");
        SliceAssigners.tumbling((int)0, (ZoneId)zoneId, (Duration)Duration.ofSeconds(10L)).withOffset(Duration.ofSeconds(-1L));
    }
}

