/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntComparator;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.runtime.TupleComparator;
import org.apache.flink.runtime.operators.sort.MergeIterator;
import org.apache.flink.runtime.operators.testutils.Match;
import org.apache.flink.runtime.operators.testutils.TestData;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.Int2SortMergeJoinOperatorTest;
import org.apache.flink.table.runtime.operators.join.RandomSortMergeInnerJoinTest;
import org.apache.flink.util.MutableObjectIterator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class RandomSortMergeOuterJoinTest {
    private static final long SEED1 = 561349061987311L;
    private static final long SEED2 = 231434613412342L;

    RandomSortMergeOuterJoinTest() {
    }

    @Test
    void testFullOuterJoinWithHighNumberOfCommonKeys() throws Exception {
        this.testOuterJoinWithHighNumberOfCommonKeys(FlinkJoinType.FULL, 200, 500, 2048, 0.02f, 200, 500, 2048, 0.02f);
    }

    @Test
    void testLeftOuterJoinWithHighNumberOfCommonKeys() throws Exception {
        this.testOuterJoinWithHighNumberOfCommonKeys(FlinkJoinType.LEFT, 200, 10, 4096, 0.02f, 100, 4000, 2048, 0.02f);
    }

    @Test
    void testRightOuterJoinWithHighNumberOfCommonKeys() throws Exception {
        this.testOuterJoinWithHighNumberOfCommonKeys(FlinkJoinType.RIGHT, 100, 10, 2048, 0.02f, 200, 4000, 4096, 0.02f);
    }

    protected void testOuterJoinWithHighNumberOfCommonKeys(FlinkJoinType outerJoinType, int input1Size, int input1Duplicates, int input1ValueLength, float input1KeyDensity, int input2Size, int input2Duplicates, int input2ValueLength, float input2KeyDensity) throws Exception {
        TupleComparator comparator1 = new TupleComparator(new int[]{0}, new TypeComparator[]{new IntComparator(true)}, new TypeSerializer[]{IntSerializer.INSTANCE});
        TupleComparator comparator2 = new TupleComparator(new int[]{0}, new TypeComparator[]{new IntComparator(true)}, new TypeSerializer[]{IntSerializer.INSTANCE});
        int duplicateKey = 13;
        TestData.TupleGenerator generator1 = new TestData.TupleGenerator(561349061987311L, 500, input1KeyDensity, input1ValueLength, TestData.TupleGenerator.KeyMode.SORTED_SPARSE, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH, null);
        TestData.TupleGenerator generator2 = new TestData.TupleGenerator(231434613412342L, 500, input2KeyDensity, input2ValueLength, TestData.TupleGenerator.KeyMode.SORTED_SPARSE, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH, null);
        TestData.TupleGeneratorIterator gen1Iter = new TestData.TupleGeneratorIterator(generator1, input1Size);
        TestData.TupleGeneratorIterator gen2Iter = new TestData.TupleGeneratorIterator(generator2, input2Size);
        TestData.TupleConstantValueIterator const1Iter = new TestData.TupleConstantValueIterator(13, "LEFT String for Duplicate Keys", input1Duplicates);
        TestData.TupleConstantValueIterator const2Iter = new TestData.TupleConstantValueIterator(13, "RIGHT String for Duplicate Keys", input2Duplicates);
        ArrayList<Object> inList1 = new ArrayList<Object>();
        inList1.add(gen1Iter);
        inList1.add(const1Iter);
        ArrayList<Object> inList2 = new ArrayList<Object>();
        inList2.add(gen2Iter);
        inList2.add(const2Iter);
        MergeIterator input1 = new MergeIterator(inList1, comparator1.duplicate());
        MergeIterator input2 = new MergeIterator(inList2, comparator2.duplicate());
        Map<Integer, Collection<Match>> expectedMatchesMap = this.joinValues(RandomSortMergeInnerJoinTest.collectData((MutableObjectIterator<Tuple2<Integer, String>>)input1), RandomSortMergeInnerJoinTest.collectData((MutableObjectIterator<Tuple2<Integer, String>>)input2), outerJoinType);
        generator1.reset();
        generator2.reset();
        const1Iter.reset();
        const2Iter.reset();
        gen1Iter.reset();
        gen2Iter.reset();
        inList1.clear();
        inList1.add(gen1Iter);
        inList1.add(const1Iter);
        inList2.clear();
        inList2.add(gen2Iter);
        inList2.add(const2Iter);
        input1 = new MergeIterator(inList1, comparator1.duplicate());
        input2 = new MergeIterator(inList2, comparator2.duplicate());
        StreamOperator operator = this.getOperator(outerJoinType);
        RandomSortMergeInnerJoinTest.match(expectedMatchesMap, RandomSortMergeInnerJoinTest.transformToBinary(this.myJoin(operator, (MutableObjectIterator<Tuple2<Integer, String>>)input1, (MutableObjectIterator<Tuple2<Integer, String>>)input2)));
        Assertions.assertThat(expectedMatchesMap).allSatisfy((i, e) -> Assertions.assertThat((Collection)e).isEmpty());
    }

    public LinkedBlockingQueue<Object> myJoin(StreamOperator operator, MutableObjectIterator<Tuple2<Integer, String>> input1, MutableObjectIterator<Tuple2<Integer, String>> input2) throws Exception {
        return RandomSortMergeInnerJoinTest.join(operator, input1, input2);
    }

    private Map<Integer, Collection<Match>> joinValues(Map<Integer, Collection<String>> leftMap, Map<Integer, Collection<String>> rightMap, FlinkJoinType outerJoinType) {
        Collection joinedValues;
        Collection<String> rightValues;
        Collection<String> leftValues;
        HashMap<Integer, Collection<Match>> map = new HashMap<Integer, Collection<Match>>();
        for (Integer key : leftMap.keySet()) {
            leftValues = leftMap.get(key);
            rightValues = rightMap.get(key);
            if (outerJoinType == FlinkJoinType.RIGHT && rightValues == null) continue;
            if (!map.containsKey(key)) {
                map.put(key, new ArrayList());
            }
            joinedValues = (Collection)map.get(key);
            for (String leftValue : leftValues) {
                if (rightValues != null) {
                    for (String rightValue : rightValues) {
                        joinedValues.add(new Match(leftValue, rightValue));
                    }
                    continue;
                }
                joinedValues.add(new Match(leftValue, null));
            }
        }
        if (outerJoinType == FlinkJoinType.RIGHT || outerJoinType == FlinkJoinType.FULL) {
            for (Integer key : rightMap.keySet()) {
                leftValues = leftMap.get(key);
                rightValues = rightMap.get(key);
                if (leftValues != null) continue;
                if (!map.containsKey(key)) {
                    map.put(key, new ArrayList());
                }
                joinedValues = (Collection)map.get(key);
                for (String rightValue : rightValues) {
                    joinedValues.add(new Match(null, rightValue));
                }
            }
        }
        return map;
    }

    protected StreamOperator getOperator(FlinkJoinType outerJoinType) {
        return Int2SortMergeJoinOperatorTest.newOperator(outerJoinType, false);
    }
}

