/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.deduplicate;

import java.util.ArrayList;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.operators.KeyedProcessOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.util.KeyedOneInputStreamOperatorTestHarness;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.deduplicate.ProcTimeDeduplicateFunctionTestBase;
import org.apache.flink.table.runtime.operators.deduplicate.ProcTimeDeduplicateKeepFirstRowFunction;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.junit.jupiter.api.Test;

class ProcTimeDeduplicateKeepFirstRowFunctionTest
extends ProcTimeDeduplicateFunctionTestBase {
    ProcTimeDeduplicateKeepFirstRowFunctionTest() {
    }

    private OneInputStreamOperatorTestHarness<RowData, RowData> createTestHarness(ProcTimeDeduplicateKeepFirstRowFunction func) throws Exception {
        KeyedProcessOperator operator = new KeyedProcessOperator((KeyedProcessFunction)func);
        return new KeyedOneInputStreamOperatorTestHarness((OneInputStreamOperator)operator, (KeySelector)this.rowKeySelector, (TypeInformation)this.rowKeySelector.getProducedType());
    }

    @Test
    void test() throws Exception {
        ProcTimeDeduplicateKeepFirstRowFunction func = new ProcTimeDeduplicateKeepFirstRowFunction(this.minTime.toMillis());
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 1L, 12));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 2L, 11));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 1L, 13));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 1L, 12));
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 2L, 11));
        this.assertor.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Test
    void testWithStateTtl() throws Exception {
        ProcTimeDeduplicateKeepFirstRowFunction func = new ProcTimeDeduplicateKeepFirstRowFunction(this.minTime.toMillis());
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 1L, 12));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 2L, 11));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 1L, 13));
        testHarness.setStateTtlProcessingTime(30L);
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 1L, 17));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 2L, 18));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 1L, 19));
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 1L, 12));
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 2L, 11));
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 1L, 17));
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 2L, 18));
        this.assertor.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
        testHarness.close();
    }
}

