/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.table.fullcache;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.functions.table.lookup.fullcache.CacheLoader;
import org.apache.flink.table.runtime.util.StreamRecordUtils;

public class TestCacheLoader
extends CacheLoader {
    public static final Map<RowData, Collection<RowData>> DATA = new HashMap<RowData, Collection<RowData>>();
    private final Consumer<Map<RowData, Collection<RowData>>> secondLoadDataChange;
    private int numLoads;
    private boolean isAwaitTriggered;

    public TestCacheLoader(Consumer<Map<RowData, Collection<RowData>>> secondLoadDataChange) {
        this.secondLoadDataChange = secondLoadDataChange;
    }

    public int getNumLoads() {
        return this.numLoads;
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public boolean isAwaitTriggered() {
        return this.isAwaitTriggered;
    }

    public void awaitFirstLoad() {
        this.isAwaitTriggered = true;
    }

    protected boolean updateCache() {
        this.cache = new ConcurrentHashMap<RowData, Collection<RowData>>(DATA);
        ++this.numLoads;
        if (this.numLoads == 2) {
            this.secondLoadDataChange.accept(this.cache);
        }
        return true;
    }

    static {
        DATA.put(StreamRecordUtils.row(1), Collections.singletonList(StreamRecordUtils.row(1, "Julian")));
        DATA.put(StreamRecordUtils.row(3), Arrays.asList(StreamRecordUtils.row(3, "Jark"), StreamRecordUtils.row(3, "Jackson")));
        DATA.put(StreamRecordUtils.row(4), Collections.singletonList(StreamRecordUtils.row(4, "Fabian")));
    }
}

