/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util.collections.binary;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.disk.RandomAccessInputView;
import org.apache.flink.runtime.memory.AbstractPagedInputView;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.memory.MemoryManagerBuilder;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.runtime.typeutils.BinaryRowDataSerializer;
import org.apache.flink.table.runtime.typeutils.PagedTypeSerializer;
import org.apache.flink.table.runtime.util.KeyValueIterator;
import org.apache.flink.table.runtime.util.collections.binary.AbstractBytesHashMap;
import org.apache.flink.table.runtime.util.collections.binary.BytesMap;
import org.apache.flink.table.runtime.util.collections.binary.BytesMapTestBase;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.VarCharType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

abstract class BytesHashMapTestBase<K>
extends BytesMapTestBase {
    private static final int NUM_REWRITES = 10;
    static final LogicalType[] KEY_TYPES = new LogicalType[]{new IntType(), VarCharType.STRING_TYPE, new DoubleType(), new BigIntType(), new BooleanType(), new FloatType(), new SmallIntType()};
    static final LogicalType[] VALUE_TYPES = new LogicalType[]{new DoubleType(), new BigIntType(), new BooleanType(), new FloatType(), new SmallIntType()};
    protected final BinaryRowData defaultValue;
    protected final PagedTypeSerializer<K> keySerializer;
    protected final BinaryRowDataSerializer valueSerializer;

    public BytesHashMapTestBase(PagedTypeSerializer<K> keySerializer) {
        this.keySerializer = keySerializer;
        this.valueSerializer = new BinaryRowDataSerializer(VALUE_TYPES.length);
        this.defaultValue = this.valueSerializer.createInstance();
        int valueSize = this.defaultValue.getFixedLengthPartSize();
        this.defaultValue.pointTo(MemorySegmentFactory.wrap((byte[])new byte[valueSize]), 0, valueSize);
    }

    public abstract AbstractBytesHashMap<K> createBytesHashMap(MemoryManager var1, int var2, LogicalType[] var3, LogicalType[] var4);

    public abstract K[] generateRandomKeys(int var1);

    @Test
    void testHashSetMode() throws IOException {
        int numMemSegments = this.needNumMemSegments(10000, this.rowLength(RowType.of((LogicalType[])VALUE_TYPES)), this.rowLength(RowType.of((LogicalType[])KEY_TYPES)), 32768);
        int memorySize = numMemSegments * 32768;
        MemoryManager memoryManager = MemoryManagerBuilder.newBuilder().setMemorySize((long)(numMemSegments * 32768)).build();
        AbstractBytesHashMap<K> table = this.createBytesHashMap(memoryManager, memorySize, KEY_TYPES, new LogicalType[0]);
        Assertions.assertThat((boolean)table.isHashSetMode()).isTrue();
        K[] keys = this.generateRandomKeys(10000);
        this.verifyKeyInsert(keys, table);
        this.verifyKeyPresent(keys, table);
        table.free();
    }

    @Test
    void testBuildAndRetrieve() throws Exception {
        int numMemSegments = this.needNumMemSegments(10000, this.rowLength(RowType.of((LogicalType[])VALUE_TYPES)), this.rowLength(RowType.of((LogicalType[])KEY_TYPES)), 32768);
        int memorySize = numMemSegments * 32768;
        MemoryManager memoryManager = MemoryManagerBuilder.newBuilder().setMemorySize((long)memorySize).build();
        AbstractBytesHashMap<K> table = this.createBytesHashMap(memoryManager, memorySize, KEY_TYPES, VALUE_TYPES);
        K[] keys = this.generateRandomKeys(10000);
        ArrayList<BinaryRowData> expected = new ArrayList<BinaryRowData>(10000);
        this.verifyInsert(keys, expected, table);
        this.verifyRetrieve(table, keys, expected);
        table.free();
    }

    @Test
    void testBuildAndUpdate() throws Exception {
        int numMemSegments = this.needNumMemSegments(10000, this.rowLength(RowType.of((LogicalType[])VALUE_TYPES)), this.rowLength(RowType.of((LogicalType[])KEY_TYPES)), 32768);
        int memorySize = numMemSegments * 32768;
        MemoryManager memoryManager = MemoryManagerBuilder.newBuilder().setMemorySize((long)memorySize).build();
        AbstractBytesHashMap<K> table = this.createBytesHashMap(memoryManager, memorySize, KEY_TYPES, VALUE_TYPES);
        K[] keys = this.generateRandomKeys(10000);
        ArrayList<BinaryRowData> expected = new ArrayList<BinaryRowData>(10000);
        this.verifyInsertAndUpdate(keys, expected, table);
        this.verifyRetrieve(table, keys, expected);
        table.free();
    }

    @Test
    void testRest() throws Exception {
        int numMemSegments = this.needNumMemSegments(10000, this.rowLength(RowType.of((LogicalType[])VALUE_TYPES)), this.rowLength(RowType.of((LogicalType[])KEY_TYPES)), 32768);
        int memorySize = numMemSegments * 32768;
        MemoryManager memoryManager = MemoryManagerBuilder.newBuilder().setMemorySize((long)memorySize).build();
        AbstractBytesHashMap<K> table = this.createBytesHashMap(memoryManager, memorySize, KEY_TYPES, VALUE_TYPES);
        K[] keys = this.generateRandomKeys(10000);
        ArrayList<BinaryRowData> expected = new ArrayList<BinaryRowData>(10000);
        this.verifyInsertAndUpdate(keys, expected, table);
        this.verifyRetrieve(table, keys, expected);
        table.reset();
        Assertions.assertThat((long)table.getNumElements()).isEqualTo(0L);
        Assertions.assertThat((List)table.getRecordAreaMemorySegments()).hasSize(1);
        expected.clear();
        this.verifyInsertAndUpdate(keys, expected, table);
        this.verifyRetrieve(table, keys, expected);
        table.free();
    }

    @Test
    void testResetAndOutput() throws Exception {
        Random rnd = new Random(76518743207143L);
        int reservedMemSegments = 64;
        int minMemorySize = 0x200000;
        MemoryManager memoryManager = MemoryManagerBuilder.newBuilder().setMemorySize((long)minMemorySize).build();
        AbstractBytesHashMap<K> table = this.createBytesHashMap(memoryManager, minMemorySize, KEY_TYPES, VALUE_TYPES);
        K[] keys = this.generateRandomKeys(10000);
        ArrayList<BinaryRowData> expected = new ArrayList<BinaryRowData>(10000);
        ArrayList<BinaryRowData> actualValues = new ArrayList<BinaryRowData>(10000);
        ArrayList<Object> actualKeys = new ArrayList<Object>(10000);
        for (int i = 0; i < 10000; ++i) {
            K groupKey = keys[i];
            BytesMap.LookupInfo lookupInfo = table.lookup(groupKey);
            Assertions.assertThat((boolean)lookupInfo.isFound()).isFalse();
            try {
                BinaryRowData entry = table.append(lookupInfo, this.defaultValue);
                Assertions.assertThat((Object)entry).isNotNull();
                for (int j = 0; j < 10; ++j) {
                    this.updateOutputBuffer(entry, rnd);
                }
                expected.add(entry.copy());
                continue;
            }
            catch (Exception e) {
                ArrayList segments = table.getRecordAreaMemorySegments();
                RandomAccessInputView inView = new RandomAccessInputView(segments, ((MemorySegment)segments.get(0)).size());
                Object reuseKey = this.keySerializer.createInstance();
                BinaryRowData reuseValue = this.valueSerializer.createInstance();
                int index = 0;
                while ((long)index < table.getNumElements()) {
                    reuseKey = this.keySerializer.mapFromPages(reuseKey, (AbstractPagedInputView)inView);
                    reuseValue = this.valueSerializer.mapFromPages(reuseValue, (AbstractPagedInputView)inView);
                    actualKeys.add(this.keySerializer.copy(reuseKey));
                    actualValues.add(reuseValue.copy());
                    ++index;
                }
                table.reset();
                lookupInfo = table.lookup(groupKey);
                BinaryRowData entry = table.append(lookupInfo, this.defaultValue);
                Assertions.assertThat((Object)entry).isNotNull();
                for (int j = 0; j < 10; ++j) {
                    this.updateOutputBuffer(entry, rnd);
                }
                expected.add(entry.copy());
            }
        }
        KeyValueIterator iter = table.getEntryIterator(false);
        while (iter.advanceNext()) {
            actualKeys.add(this.keySerializer.copy(iter.getKey()));
            actualValues.add(((BinaryRowData)iter.getValue()).copy());
        }
        Assertions.assertThat(expected).hasSize(10000);
        Assertions.assertThat(actualKeys).hasSize(10000);
        Assertions.assertThat(actualValues).hasSize(10000);
        Assertions.assertThat(actualValues).isEqualTo(expected);
        table.free();
    }

    @Test
    void testSingleKeyMultipleOps() throws Exception {
        BytesMap.LookupInfo lookupInfo;
        int i;
        int numMemSegments = this.needNumMemSegments(10000, this.rowLength(RowType.of((LogicalType[])VALUE_TYPES)), this.rowLength(RowType.of((LogicalType[])KEY_TYPES)), 32768);
        int memorySize = numMemSegments * 32768;
        MemoryManager memoryManager = MemoryManagerBuilder.newBuilder().setMemorySize((long)memorySize).build();
        AbstractBytesHashMap<K> table = this.createBytesHashMap(memoryManager, memorySize, KEY_TYPES, VALUE_TYPES);
        K key = this.generateRandomKeys(1)[0];
        for (i = 0; i < 3; ++i) {
            lookupInfo = table.lookup(key);
            Assertions.assertThat((boolean)lookupInfo.isFound()).isFalse();
        }
        for (i = 0; i < 3; ++i) {
            lookupInfo = table.lookup(key);
            BinaryRowData entry = (BinaryRowData)lookupInfo.getValue();
            if (i == 0) {
                Assertions.assertThat((boolean)lookupInfo.isFound()).isFalse();
                entry = table.append(lookupInfo, this.defaultValue);
            } else {
                Assertions.assertThat((boolean)lookupInfo.isFound()).isTrue();
            }
            Assertions.assertThat((Object)entry).isNotNull();
        }
        table.free();
    }

    private void updateOutputBuffer(BinaryRowData reuse, Random rnd) {
        long longVal = rnd.nextLong();
        double doubleVal = rnd.nextDouble();
        boolean boolVal = longVal % 2L == 0L;
        reuse.setDouble(2, doubleVal);
        reuse.setLong(3, longVal);
        reuse.setBoolean(4, boolVal);
    }

    private void verifyRetrieve(AbstractBytesHashMap<K> table, K[] keys, List<BinaryRowData> expected) {
        Assertions.assertThat((long)table.getNumElements()).isEqualTo(10000L);
        for (int i = 0; i < 10000; ++i) {
            K groupKey = keys[i];
            BytesMap.LookupInfo lookupInfo = table.lookup(groupKey);
            Assertions.assertThat((boolean)lookupInfo.isFound()).isTrue();
            Assertions.assertThat((Object)((BinaryRowData)lookupInfo.getValue())).isNotNull();
            Assertions.assertThat((Object)((BinaryRowData)lookupInfo.getValue())).isEqualTo((Object)expected.get(i));
        }
    }

    private void verifyInsert(K[] keys, List<BinaryRowData> inserted, AbstractBytesHashMap<K> table) throws IOException {
        for (int i = 0; i < 10000; ++i) {
            K groupKey = keys[i];
            BytesMap.LookupInfo lookupInfo = table.lookup(groupKey);
            Assertions.assertThat((boolean)lookupInfo.isFound()).isFalse();
            BinaryRowData entry = table.append(lookupInfo, this.defaultValue);
            Assertions.assertThat((Object)entry).isNotNull();
            Assertions.assertThat((Object)this.defaultValue).isEqualTo((Object)entry);
            inserted.add(entry.copy());
        }
        Assertions.assertThat((long)table.getNumElements()).isEqualTo(10000L);
    }

    private void verifyInsertAndUpdate(K[] keys, List<BinaryRowData> inserted, AbstractBytesHashMap<K> table) throws IOException {
        Random rnd = new Random(76518743207143L);
        for (int i = 0; i < 10000; ++i) {
            K groupKey = keys[i];
            BytesMap.LookupInfo lookupInfo = table.lookup(groupKey);
            Assertions.assertThat((boolean)lookupInfo.isFound()).isFalse();
            BinaryRowData entry = table.append(lookupInfo, this.defaultValue);
            Assertions.assertThat((Object)entry).isNotNull();
            for (int j = 0; j < 10; ++j) {
                this.updateOutputBuffer(entry, rnd);
            }
            inserted.add(entry.copy());
        }
        Assertions.assertThat((long)table.getNumElements()).isEqualTo(10000L);
    }

    private void verifyKeyPresent(K[] keys, AbstractBytesHashMap<K> table) {
        Assertions.assertThat((long)table.getNumElements()).isEqualTo(10000L);
        BinaryRowData present = new BinaryRowData(0);
        present.pointTo(MemorySegmentFactory.wrap((byte[])new byte[8]), 0, 8);
        for (int i = 0; i < 10000; ++i) {
            K groupKey = keys[i];
            BytesMap.LookupInfo lookupInfo = table.lookup(groupKey);
            Assertions.assertThat((boolean)lookupInfo.isFound()).isTrue();
            Assertions.assertThat((Object)((BinaryRowData)lookupInfo.getValue())).isNotNull();
            Assertions.assertThat((Object)((BinaryRowData)lookupInfo.getValue())).isEqualTo((Object)present);
        }
    }

    private void verifyKeyInsert(K[] keys, AbstractBytesHashMap<K> table) throws IOException {
        BinaryRowData present = new BinaryRowData(0);
        present.pointTo(MemorySegmentFactory.wrap((byte[])new byte[8]), 0, 8);
        for (int i = 0; i < 10000; ++i) {
            K groupKey = keys[i];
            BytesMap.LookupInfo lookupInfo = table.lookup(groupKey);
            Assertions.assertThat((boolean)lookupInfo.isFound()).isFalse();
            BinaryRowData entry = table.append(lookupInfo, this.defaultValue);
            Assertions.assertThat((Object)entry).isNotNull();
            Assertions.assertThat((Object)present).isEqualTo((Object)entry);
        }
        Assertions.assertThat((long)table.getNumElements()).isEqualTo(10000L);
    }
}

