/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window.groupwindow.assigners;

import java.time.Duration;
import java.util.Collection;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.window.TimeWindow;
import org.apache.flink.table.runtime.operators.window.groupwindow.assigners.SlidingWindowAssigner;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SlidingWindowAssignerTest {
    private static final RowData ELEMENT = GenericRowData.of((Object[])new Object[]{"String"});

    SlidingWindowAssignerTest() {
    }

    @Test
    void testWindowAssignment() {
        SlidingWindowAssigner assigner = SlidingWindowAssigner.of((Duration)Duration.ofMillis(5000L), (Duration)Duration.ofMillis(1000L));
        Assertions.assertThat((Collection)assigner.assignWindows(ELEMENT, 0L)).containsExactlyInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(-4000L, 1000L), new TimeWindow(-3000L, 2000L), new TimeWindow(-2000L, 3000L), new TimeWindow(-1000L, 4000L), new TimeWindow(0L, 5000L)});
        Assertions.assertThat((Collection)assigner.assignWindows(ELEMENT, 4999L)).containsExactlyInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(0L, 5000L), new TimeWindow(1000L, 6000L), new TimeWindow(2000L, 7000L), new TimeWindow(3000L, 8000L), new TimeWindow(4000L, 9000L)});
        Assertions.assertThat((Collection)assigner.assignWindows(ELEMENT, 5000L)).containsExactlyInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(1000L, 6000L), new TimeWindow(2000L, 7000L), new TimeWindow(3000L, 8000L), new TimeWindow(4000L, 9000L), new TimeWindow(5000L, 10000L)});
        Assertions.assertThat((Comparable)new TimeWindow(0L, 1000L)).isEqualTo((Object)assigner.assignPane((Object)ELEMENT, 0L));
        Assertions.assertThat((Comparable)new TimeWindow(4000L, 5000L)).isEqualTo((Object)assigner.assignPane((Object)ELEMENT, 4999L));
        Assertions.assertThat((Comparable)new TimeWindow(5000L, 6000L)).isEqualTo((Object)assigner.assignPane((Object)ELEMENT, 5000L));
        Assertions.assertThat((Iterable)assigner.splitIntoPanes(new TimeWindow(0L, 5000L))).contains((Object[])new TimeWindow[]{new TimeWindow(0L, 1000L), new TimeWindow(1000L, 2000L), new TimeWindow(2000L, 3000L), new TimeWindow(3000L, 4000L), new TimeWindow(4000L, 5000L)});
        Assertions.assertThat((Iterable)assigner.splitIntoPanes(new TimeWindow(3000L, 8000L))).contains((Object[])new TimeWindow[]{new TimeWindow(3000L, 4000L), new TimeWindow(4000L, 5000L), new TimeWindow(5000L, 6000L), new TimeWindow(6000L, 7000L), new TimeWindow(7000L, 8000L)});
        Assertions.assertThat((Comparable)new TimeWindow(4000L, 9000L)).isEqualTo((Object)assigner.getLastWindow(new TimeWindow(4000L, 5000L)));
        Assertions.assertThat((Comparable)new TimeWindow(2000L, 7000L)).isEqualTo((Object)assigner.getLastWindow(new TimeWindow(2000L, 3000L)));
    }

    @Test
    void testWindowAssignmentWithOffset() {
        SlidingWindowAssigner assigner = SlidingWindowAssigner.of((Duration)Duration.ofMillis(5000L), (Duration)Duration.ofMillis(1000L)).withOffset(Duration.ofMillis(100L));
        Assertions.assertThat((Collection)assigner.assignWindows(ELEMENT, 100L)).containsExactlyInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(-3900L, 1100L), new TimeWindow(-2900L, 2100L), new TimeWindow(-1900L, 3100L), new TimeWindow(-900L, 4100L), new TimeWindow(100L, 5100L)});
        Assertions.assertThat((Collection)assigner.assignWindows(ELEMENT, 5099L)).containsExactlyInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(100L, 5100L), new TimeWindow(1100L, 6100L), new TimeWindow(2100L, 7100L), new TimeWindow(3100L, 8100L), new TimeWindow(4100L, 9100L)});
        Assertions.assertThat((Collection)assigner.assignWindows(ELEMENT, 5100L)).containsExactlyInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(1100L, 6100L), new TimeWindow(2100L, 7100L), new TimeWindow(3100L, 8100L), new TimeWindow(4100L, 9100L), new TimeWindow(5100L, 10100L)});
        Assertions.assertThat((Comparable)new TimeWindow(100L, 1100L)).isEqualTo((Object)assigner.assignPane((Object)ELEMENT, 100L));
        Assertions.assertThat((Comparable)new TimeWindow(4100L, 5100L)).isEqualTo((Object)assigner.assignPane((Object)ELEMENT, 5099L));
        Assertions.assertThat((Comparable)new TimeWindow(5100L, 6100L)).isEqualTo((Object)assigner.assignPane((Object)ELEMENT, 5100L));
        Assertions.assertThat((Iterable)assigner.splitIntoPanes(new TimeWindow(1100L, 6100L))).contains((Object[])new TimeWindow[]{new TimeWindow(1100L, 2100L), new TimeWindow(2100L, 3100L), new TimeWindow(3100L, 4100L), new TimeWindow(4100L, 5100L), new TimeWindow(5100L, 6100L)});
        Assertions.assertThat((Iterable)assigner.splitIntoPanes(new TimeWindow(3100L, 8100L))).contains((Object[])new TimeWindow[]{new TimeWindow(3100L, 4100L), new TimeWindow(4100L, 5100L), new TimeWindow(5100L, 6100L), new TimeWindow(6100L, 7100L), new TimeWindow(7100L, 8100L)});
        Assertions.assertThat((Comparable)new TimeWindow(4100L, 9100L)).isEqualTo((Object)assigner.getLastWindow(new TimeWindow(4100L, 5100L)));
        Assertions.assertThat((Comparable)new TimeWindow(2100L, 7100L)).isEqualTo((Object)assigner.getLastWindow(new TimeWindow(2100L, 3100L)));
    }

    @Test
    void testInvalidParameters() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SlidingWindowAssigner.of((Duration)Duration.ofSeconds(-2L), (Duration)Duration.ofSeconds(1L))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("slide > 0 and size > 0");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SlidingWindowAssigner.of((Duration)Duration.ofSeconds(2L), (Duration)Duration.ofSeconds(-1L))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("slide > 0 and size > 0");
        SlidingWindowAssigner.of((Duration)Duration.ofSeconds(20L), (Duration)Duration.ofSeconds(10L)).withOffset(Duration.ofSeconds(-1L));
    }

    @Test
    void testProperties() {
        SlidingWindowAssigner assigner = SlidingWindowAssigner.of((Duration)Duration.ofMillis(5000L), (Duration)Duration.ofMillis(1000L));
        Assertions.assertThat((boolean)assigner.isEventTime()).isTrue();
        Assertions.assertThat((Object)assigner.getWindowSerializer(new ExecutionConfig())).isEqualTo((Object)new TimeWindow.Serializer());
        Assertions.assertThat((boolean)assigner.withEventTime().isEventTime()).isTrue();
        Assertions.assertThat((boolean)assigner.withProcessingTime().isEventTime()).isFalse();
    }
}

