/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.stream.multijoin;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.stream.keyselector.AttributeBasedJoinKeyExtractor;
import org.apache.flink.table.runtime.operators.join.stream.multijoin.StreamingMultiJoinOperatorTestBase;
import org.apache.flink.table.runtime.util.StateParameterizedHarnessTestBase;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
class StreamingThreeWayOuterJoinCustomConditionOperatorTest
extends StreamingMultiJoinOperatorTestBase {
    private static final List<GeneratedJoinCondition> customJoinCondition = Arrays.asList(null, StreamingThreeWayOuterJoinCustomConditionOperatorTest.createJoinCondition(1, 0), StreamingThreeWayOuterJoinCustomConditionOperatorTest.createJoinCondition(2, 0));
    private static final Map<Integer, List<AttributeBasedJoinKeyExtractor.ConditionAttributeRef>> customAttributeMap = new HashMap<Integer, List<AttributeBasedJoinKeyExtractor.ConditionAttributeRef>>();

    public StreamingThreeWayOuterJoinCustomConditionOperatorTest(StateParameterizedHarnessTestBase.StateBackendMode stateBackendMode) {
        super(stateBackendMode, 3, List.of(FlinkJoinType.INNER, FlinkJoinType.LEFT, FlinkJoinType.LEFT), customJoinCondition, customAttributeMap, false);
    }

    @TestTemplate
    void testThreeWayLeftOuterJoinCustomCondition() throws Exception {
        this.insertPayment("1", "payment_1", "Payment 1 Details");
        this.emitsNothing();
        this.insertOrder("1", "order_1", "Order 1 Details");
        this.emitsNothing();
        this.insertUser("1", "Gus", "User 1 Details");
        this.emits(INSERT, this.r("1", "Gus", "User 1 Details", "1", "order_1", "Order 1 Details", "1", "payment_1", "Payment 1 Details"));
        this.updateBeforeOrder("1", "order_1", "Order 1 Details");
        this.emits(UPDATE_BEFORE, this.r("1", "Gus", "User 1 Details", "1", "order_1", "Order 1 Details", "1", "payment_1", "Payment 1 Details"), INSERT, this.r("1", "Gus", "User 1 Details", null, null, null, "1", "payment_1", "Payment 1 Details"));
        this.updateAfterOrder("1", "order_1", "Order 1 Details Updated");
        this.emits(DELETE, this.r("1", "Gus", "User 1 Details", null, null, null, "1", "payment_1", "Payment 1 Details"), UPDATE_AFTER, this.r("1", "Gus", "User 1 Details", "1", "order_1", "Order 1 Details Updated", "1", "payment_1", "Payment 1 Details"));
    }

    static {
        customAttributeMap.put(1, Collections.singletonList(new AttributeBasedJoinKeyExtractor.ConditionAttributeRef(0, 0, 1, 0)));
        customAttributeMap.put(2, Collections.singletonList(new AttributeBasedJoinKeyExtractor.ConditionAttributeRef(0, 0, 2, 0)));
    }
}

