/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.stream.multijoin;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.stream.keyselector.AttributeBasedJoinKeyExtractor;
import org.apache.flink.table.runtime.operators.join.stream.multijoin.StreamingMultiJoinOperatorTestBase;
import org.apache.flink.table.runtime.operators.join.stream.utils.JoinInputSideSpec;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.util.StateParameterizedHarnessTestBase;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
class StreamingFourWayMixedOuterJoinOperatorTest
extends StreamingMultiJoinOperatorTestBase {
    private static final List<GeneratedJoinCondition> customJoinConditions;
    private static final Map<Integer, List<AttributeBasedJoinKeyExtractor.ConditionAttributeRef>> customAttributeMap;

    public StreamingFourWayMixedOuterJoinOperatorTest(StateParameterizedHarnessTestBase.StateBackendMode stateBackendMode) {
        super(stateBackendMode, 4, List.of(FlinkJoinType.INNER, FlinkJoinType.LEFT, FlinkJoinType.INNER, FlinkJoinType.LEFT), customJoinConditions, customAttributeMap, false);
        this.inputSpecs.set(3, JoinInputSideSpec.withoutUniqueKey());
    }

    @TestTemplate
    void testFourWayMixedJoin() throws Exception {
        this.insertUser("1", "user1", 100L);
        this.emitsNothing();
        this.insertOrder("99", "order99", "Order 99");
        this.emitsNothing();
        this.insertPayment("99", "payment99", "Payment 99");
        this.emitsNothing();
        this.insertShipment("99", "shipment99", 50L);
        this.emitsNothing();
        this.insertOrder("1", "order1", "Order 1");
        this.emitsNothing();
        this.insertPayment("1", "payment1", "Payment 1");
        this.emits(INSERT, this.r("1", "user1", 100L, "1", "order1", "Order 1", "1", "payment1", "Payment 1", null, null, null));
        this.insertShipment("1", "shipment1", 50L);
        this.emits(DELETE, this.r("1", "user1", 100L, "1", "order1", "Order 1", "1", "payment1", "Payment 1", null, null, null), INSERT, this.r("1", "user1", 100L, "1", "order1", "Order 1", "1", "payment1", "Payment 1", "1", "shipment1", 50L));
        this.insertShipment("1", "shipment2_no_join", 150L);
        this.emitsNothing();
        this.deleteShipment("1", "shipment1", 50L);
        this.emits(DELETE, this.r("1", "user1", 100L, "1", "order1", "Order 1", "1", "payment1", "Payment 1", "1", "shipment1", 50L), INSERT, this.r("1", "user1", 100L, "1", "order1", "Order 1", "1", "payment1", "Payment 1", null, null, null));
        this.deletePayment("1", "payment1", "Payment 1");
        this.emits(DELETE, this.r("1", "user1", 100L, "1", "order1", "Order 1", "1", "payment1", "Payment 1", null, null, null));
        this.deleteOrder("1", "order1", "Order 1");
        this.emitsNothing();
        this.insertOrder("1", "order2", "Order 2 for User 1");
        this.emitsNothing();
        this.insertPayment("1", "payment2", "Payment 2 for User 1");
        this.emits(INSERT, this.r("1", "user1", 100L, "1", "order2", "Order 2 for User 1", "1", "payment2", "Payment 2 for User 1", null, null, null));
        this.insertShipment("1", "shipment3_joins", 75L);
        this.emits(DELETE, this.r("1", "user1", 100L, "1", "order2", "Order 2 for User 1", "1", "payment2", "Payment 2 for User 1", null, null, null), INSERT, this.r("1", "user1", 100L, "1", "order2", "Order 2 for User 1", "1", "payment2", "Payment 2 for User 1", "1", "shipment3_joins", 75L));
        this.deleteUser("1", "user1", 100L);
        this.emits(DELETE, this.r("1", "user1", 100L, "1", "order2", "Order 2 for User 1", "1", "payment2", "Payment 2 for User 1", "1", "shipment3_joins", 75L));
        this.insertUser("2", "user2", 200L);
        this.emitsNothing();
        this.insertOrder("2", "order3", "Order 3 for User 2");
        this.emitsNothing();
        this.insertPayment("2", "payment3", "Payment 3 for User 2");
        this.emits(INSERT, this.r("2", "user2", 200L, "2", "order3", "Order 3 for User 2", "2", "payment3", "Payment 3 for User 2", null, null, null));
        this.insertShipment("2", "shipment_low_detail", 50L);
        this.emits(DELETE, this.r("2", "user2", 200L, "2", "order3", "Order 3 for User 2", "2", "payment3", "Payment 3 for User 2", null, null, null), INSERT, this.r("2", "user2", 200L, "2", "order3", "Order 3 for User 2", "2", "payment3", "Payment 3 for User 2", "2", "shipment_low_detail", 50L));
        this.insertShipment("2", "shipment_high_detail", 250L);
        this.emitsNothing();
        this.updateBeforeUser("2", "user2", 200L);
        this.emits(UPDATE_BEFORE, this.r("2", "user2", 200L, "2", "order3", "Order 3 for User 2", "2", "payment3", "Payment 3 for User 2", "2", "shipment_low_detail", 50L));
        this.updateAfterUser("2", "user2_updated", 300L);
        this.emits(UPDATE_AFTER, this.r("2", "user2_updated", 300L, "2", "order3", "Order 3 for User 2", "2", "payment3", "Payment 3 for User 2", "2", "shipment_low_detail", 50L), UPDATE_AFTER, this.r("2", "user2_updated", 300L, "2", "order3", "Order 3 for User 2", "2", "payment3", "Payment 3 for User 2", "2", "shipment_high_detail", 250L));
        this.updateBeforeOrder("2", "order3", "Order 3 for User 2");
        this.emits(UPDATE_BEFORE, this.r("2", "user2_updated", 300L, "2", "order3", "Order 3 for User 2", "2", "payment3", "Payment 3 for User 2", "2", "shipment_low_detail", 50L), UPDATE_BEFORE, this.r("2", "user2_updated", 300L, "2", "order3", "Order 3 for User 2", "2", "payment3", "Payment 3 for User 2", "2", "shipment_high_detail", 250L), INSERT, this.r("2", "user2_updated", 300L, null, null, null, "2", "payment3", "Payment 3 for User 2", "2", "shipment_low_detail", 50L), INSERT, this.r("2", "user2_updated", 300L, null, null, null, "2", "payment3", "Payment 3 for User 2", "2", "shipment_high_detail", 250L));
        this.updateAfterOrder("2", "order3_updated", "Order 3 Updated");
        this.emits(DELETE, this.r("2", "user2_updated", 300L, null, null, null, "2", "payment3", "Payment 3 for User 2", "2", "shipment_low_detail", 50L), DELETE, this.r("2", "user2_updated", 300L, null, null, null, "2", "payment3", "Payment 3 for User 2", "2", "shipment_high_detail", 250L), UPDATE_AFTER, this.r("2", "user2_updated", 300L, "2", "order3_updated", "Order 3 Updated", "2", "payment3", "Payment 3 for User 2", "2", "shipment_low_detail", 50L), UPDATE_AFTER, this.r("2", "user2_updated", 300L, "2", "order3_updated", "Order 3 Updated", "2", "payment3", "Payment 3 for User 2", "2", "shipment_high_detail", 250L));
        this.updateBeforePayment("2", "payment3", "Payment 3 for User 2");
        this.emits(UPDATE_BEFORE, this.r("2", "user2_updated", 300L, "2", "order3_updated", "Order 3 Updated", "2", "payment3", "Payment 3 for User 2", "2", "shipment_low_detail", 50L), UPDATE_BEFORE, this.r("2", "user2_updated", 300L, "2", "order3_updated", "Order 3 Updated", "2", "payment3", "Payment 3 for User 2", "2", "shipment_high_detail", 250L));
        this.updateAfterPayment("2", "payment3_updated", "Payment 3 Updated");
        this.emits(UPDATE_AFTER, this.r("2", "user2_updated", 300L, "2", "order3_updated", "Order 3 Updated", "2", "payment3_updated", "Payment 3 Updated", "2", "shipment_low_detail", 50L), UPDATE_AFTER, this.r("2", "user2_updated", 300L, "2", "order3_updated", "Order 3 Updated", "2", "payment3_updated", "Payment 3 Updated", "2", "shipment_high_detail", 250L));
        this.deleteShipment("2", "shipment_low_detail", 50L);
        this.emits(DELETE, this.r("2", "user2_updated", 300L, "2", "order3_updated", "Order 3 Updated", "2", "payment3_updated", "Payment 3 Updated", "2", "shipment_low_detail", 50L));
        this.insertShipment("2", "shipment_low_now_high_detail", 350L);
        this.emitsNothing();
        this.insertShipment("2", "shipment_another_low_detail", 100L);
        this.emits(INSERT, this.r("2", "user2_updated", 300L, "2", "order3_updated", "Order 3 Updated", "2", "payment3_updated", "Payment 3 Updated", "2", "shipment_another_low_detail", 100L));
        this.deleteShipment("2", "shipment_high_detail", 250L);
        this.emits(DELETE, this.r("2", "user2_updated", 300L, "2", "order3_updated", "Order 3 Updated", "2", "payment3_updated", "Payment 3 Updated", "2", "shipment_high_detail", 250L));
        this.insertShipment("2", "shipment_high_detail_updated", 350L);
        this.emitsNothing();
        this.deleteShipment("2", "shipment_another_low_detail", 100L);
        this.emits(DELETE, this.r("2", "user2_updated", 300L, "2", "order3_updated", "Order 3 Updated", "2", "payment3_updated", "Payment 3 Updated", "2", "shipment_another_low_detail", 100L), INSERT, this.r("2", "user2_updated", 300L, "2", "order3_updated", "Order 3 Updated", "2", "payment3_updated", "Payment 3 Updated", null, null, null));
        this.insertShipment("2", "shipment_another_low_detail_updated", 50L);
        this.emits(DELETE, this.r("2", "user2_updated", 300L, "2", "order3_updated", "Order 3 Updated", "2", "payment3_updated", "Payment 3 Updated", null, null, null), INSERT, this.r("2", "user2_updated", 300L, "2", "order3_updated", "Order 3 Updated", "2", "payment3_updated", "Payment 3 Updated", "2", "shipment_another_low_detail_updated", 50L));
        this.updateBeforeUser("2", "user2_updated", 300L);
        this.emits(UPDATE_BEFORE, this.r("2", "user2_updated", 300L, "2", "order3_updated", "Order 3 Updated", "2", "payment3_updated", "Payment 3 Updated", "2", "shipment_another_low_detail_updated", 50L));
        this.updateAfterUser("2", "user2_updated_again", 400L);
        this.emits(UPDATE_AFTER, this.r("2", "user2_updated_again", 400L, "2", "order3_updated", "Order 3 Updated", "2", "payment3_updated", "Payment 3 Updated", "2", "shipment_another_low_detail_updated", 50L), UPDATE_AFTER, this.r("2", "user2_updated_again", 400L, "2", "order3_updated", "Order 3 Updated", "2", "payment3_updated", "Payment 3 Updated", "2", "shipment_high_detail_updated", 350L), UPDATE_AFTER, this.r("2", "user2_updated_again", 400L, "2", "order3_updated", "Order 3 Updated", "2", "payment3_updated", "Payment 3 Updated", "2", "shipment_low_now_high_detail", 350L));
        this.insertUser("jk1", "user1", 100L);
        this.emitsNothing();
        this.insertOrder("jk1", "order1", "Order 1");
        this.emitsNothing();
        this.insertPayment("jk1", "payment1", "Payment 1");
        this.emits(INSERT, this.r("jk1", "user1", 100L, "jk1", "order1", "Order 1", "jk1", "payment1", "Payment 1", null, null, null));
        this.deleteUser("jk1", "user1", 100L);
        this.emits(DELETE, this.r("jk1", "user1", 100L, "jk1", "order1", "Order 1", "jk1", "payment1", "Payment 1", null, null, null));
        this.insertUser("jk2", "user1", 100L);
        this.emitsNothing();
        this.insertOrder("jk2", "order2", "Order 2");
        this.emitsNothing();
        this.insertPayment("jk2", "payment2", "Payment 2");
        this.emits(INSERT, this.r("jk2", "user1", 100L, "jk2", "order2", "Order 2", "jk2", "payment2", "Payment 2", null, null, null));
        this.updateBeforeOrder("jk2", "order2", "Order 2");
        this.emits(UPDATE_BEFORE, this.r("jk2", "user1", 100L, "jk2", "order2", "Order 2", "jk2", "payment2", "Payment 2", null, null, null), INSERT, this.r("jk2", "user1", 100L, null, null, null, "jk2", "payment2", "Payment 2", null, null, null));
        this.updateAfterOrder("jk3", "order2", "Order 2 Updated");
        this.emitsNothing();
        this.updateBeforePayment("jk2", "payment2", "Payment 2");
        this.emits(UPDATE_BEFORE, this.r("jk2", "user1", 100L, null, null, null, "jk2", "payment2", "Payment 2", null, null, null));
        this.updateAfterPayment("jk4", "payment2", "Payment 2 Updated");
        this.emitsNothing();
        this.insertUser("3", "user3", 100L);
        this.emitsNothing();
        this.insertOrder("3", "order3", "Order 3");
        this.emitsNothing();
        this.insertPayment("3", "payment3", "Payment 3");
        this.emits(INSERT, this.r("3", "user3", 100L, "3", "order3", "Order 3", "3", "payment3", "Payment 3", null, null, null));
        this.insertShipment("3", "shipment1", 50L);
        this.emits(DELETE, this.r("3", "user3", 100L, "3", "order3", "Order 3", "3", "payment3", "Payment 3", null, null, null), INSERT, this.r("3", "user3", 100L, "3", "order3", "Order 3", "3", "payment3", "Payment 3", "3", "shipment1", 50L));
        this.insertShipment("3", "shipment2", 60L);
        this.emits(INSERT, this.r("3", "user3", 100L, "3", "order3", "Order 3", "3", "payment3", "Payment 3", "3", "shipment2", 60L));
        this.deleteShipment("3", "shipment1", 50L);
        this.emits(DELETE, this.r("3", "user3", 100L, "3", "order3", "Order 3", "3", "payment3", "Payment 3", "3", "shipment1", 50L));
        this.deleteShipment("3", "shipment2", 60L);
        this.emits(DELETE, this.r("3", "user3", 100L, "3", "order3", "Order 3", "3", "payment3", "Payment 3", "3", "shipment2", 60L), INSERT, this.r("3", "user3", 100L, "3", "order3", "Order 3", "3", "payment3", "Payment 3", null, null, null));
        this.insertShipment("3", "shipment3", 150L);
        this.emitsNothing();
        this.updateBeforeUser("3", "user3", 100L);
        this.emits(UPDATE_BEFORE, this.r("3", "user3", 100L, "3", "order3", "Order 3", "3", "payment3", "Payment 3", null, null, null));
        this.updateAfterUser("3", "user3", 200L);
        this.emits(UPDATE_AFTER, this.r("3", "user3", 200L, "3", "order3", "Order 3", "3", "payment3", "Payment 3", "3", "shipment3", 150L));
    }

    @Override
    protected RowType createInputTypeInfo(int inputIndex) {
        String userIdFieldName = String.format("user_id_%d", inputIndex);
        String pkFieldName = String.format("pk_%d", inputIndex);
        if (inputIndex == 0) {
            return RowType.of((LogicalType[])new LogicalType[]{new CharType(false, 20), VarCharType.STRING_TYPE, new BigIntType()}, (String[])new String[]{userIdFieldName, pkFieldName, String.format("details_%d", inputIndex)});
        }
        if (inputIndex == 3) {
            return RowType.of((LogicalType[])new LogicalType[]{new CharType(false, 20), VarCharType.STRING_TYPE, new BigIntType()}, (String[])new String[]{userIdFieldName, pkFieldName, String.format("details_%d", inputIndex)});
        }
        return super.createInputTypeInfo(inputIndex);
    }

    @Override
    protected InternalTypeInfo<RowData> createUniqueKeyType(int inputIndex) {
        if (inputIndex == 3) {
            return null;
        }
        return super.createUniqueKeyType(inputIndex);
    }

    static {
        GeneratedJoinCondition shipmentsJoinCondition = StreamingFourWayMixedOuterJoinOperatorTest.createAndCondition(StreamingFourWayMixedOuterJoinOperatorTest.createJoinCondition(3, 0), StreamingFourWayMixedOuterJoinOperatorTest.createFieldLongGreaterThanCondition(2, 2));
        customJoinConditions = Arrays.asList(null, StreamingFourWayMixedOuterJoinOperatorTest.createJoinCondition(1, 0), StreamingFourWayMixedOuterJoinOperatorTest.createJoinCondition(2, 0), shipmentsJoinCondition);
        customAttributeMap = new HashMap<Integer, List<AttributeBasedJoinKeyExtractor.ConditionAttributeRef>>();
        customAttributeMap.put(1, Collections.singletonList(new AttributeBasedJoinKeyExtractor.ConditionAttributeRef(0, 0, 1, 0)));
        customAttributeMap.put(2, Collections.singletonList(new AttributeBasedJoinKeyExtractor.ConditionAttributeRef(0, 0, 2, 0)));
        customAttributeMap.put(3, Collections.singletonList(new AttributeBasedJoinKeyExtractor.ConditionAttributeRef(0, 0, 3, 0)));
    }
}

