/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.DefaultCatalogMaterializedTable;
import org.apache.flink.table.catalog.IntervalFreshness;
import org.apache.flink.table.catalog.TableDistribution;
import org.apache.flink.table.utils.IntervalFreshnessUtils;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public interface CatalogMaterializedTable
extends CatalogBaseTable {
    @PublicEvolving
    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    default public CatalogBaseTable.TableKind getTableKind() {
        return CatalogBaseTable.TableKind.MATERIALIZED_TABLE;
    }

    default public Optional<TableDistribution> getDistribution() {
        return Optional.empty();
    }

    public boolean isPartitioned();

    public List<String> getPartitionKeys();

    public CatalogMaterializedTable copy(Map<String, String> var1);

    public CatalogMaterializedTable copy(RefreshStatus var1, String var2, byte[] var3);

    public Optional<Long> getSnapshot();

    public String getDefinitionQuery();

    public IntervalFreshness getDefinitionFreshness();

    default public Duration getFreshness() {
        return IntervalFreshnessUtils.convertFreshnessToDuration(this.getDefinitionFreshness());
    }

    public LogicalRefreshMode getLogicalRefreshMode();

    public RefreshMode getRefreshMode();

    public RefreshStatus getRefreshStatus();

    public Optional<String> getRefreshHandlerDescription();

    @Nullable
    public byte[] getSerializedRefreshHandler();

    @PublicEvolving
    public static class Builder {
        private Schema schema;
        private String comment;
        private TableDistribution distribution = null;
        private List<String> partitionKeys = Collections.emptyList();
        private Map<String, String> options = Collections.emptyMap();
        @Nullable
        private Long snapshot;
        private String definitionQuery;
        private IntervalFreshness freshness;
        private LogicalRefreshMode logicalRefreshMode;
        private RefreshMode refreshMode;
        private RefreshStatus refreshStatus;
        @Nullable
        private String refreshHandlerDescription;
        @Nullable
        private byte[] serializedRefreshHandler;

        private Builder() {
        }

        public Builder schema(Schema schema) {
            this.schema = (Schema)Preconditions.checkNotNull((Object)schema, (String)"Schema must not be null.");
            return this;
        }

        public Builder comment(@Nullable String comment) {
            this.comment = comment;
            return this;
        }

        public Builder partitionKeys(List<String> partitionKeys) {
            this.partitionKeys = (List)Preconditions.checkNotNull(partitionKeys, (String)"Partition keys must not be null.");
            return this;
        }

        public Builder options(Map<String, String> options) {
            this.options = (Map)Preconditions.checkNotNull(options, (String)"Options must not be null.");
            return this;
        }

        public Builder snapshot(@Nullable Long snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        public Builder definitionQuery(String definitionQuery) {
            this.definitionQuery = (String)Preconditions.checkNotNull((Object)definitionQuery, (String)"Definition query must not be null.");
            return this;
        }

        public Builder freshness(IntervalFreshness freshness) {
            this.freshness = (IntervalFreshness)Preconditions.checkNotNull((Object)freshness, (String)"Freshness must not be null.");
            return this;
        }

        public Builder logicalRefreshMode(LogicalRefreshMode logicalRefreshMode) {
            this.logicalRefreshMode = (LogicalRefreshMode)((Object)Preconditions.checkNotNull((Object)((Object)logicalRefreshMode), (String)"Logical refresh mode must not be null."));
            return this;
        }

        public Builder refreshMode(RefreshMode refreshMode) {
            this.refreshMode = (RefreshMode)((Object)Preconditions.checkNotNull((Object)((Object)refreshMode), (String)"Refresh mode must not be null."));
            return this;
        }

        public Builder refreshStatus(RefreshStatus refreshStatus) {
            this.refreshStatus = (RefreshStatus)((Object)Preconditions.checkNotNull((Object)((Object)refreshStatus), (String)"Refresh status must not be null."));
            return this;
        }

        public Builder refreshHandlerDescription(@Nullable String refreshHandlerDescription) {
            this.refreshHandlerDescription = refreshHandlerDescription;
            return this;
        }

        public Builder serializedRefreshHandler(@Nullable byte[] serializedRefreshHandler) {
            this.serializedRefreshHandler = serializedRefreshHandler;
            return this;
        }

        public Builder distribution(@Nullable TableDistribution distribution) {
            this.distribution = distribution;
            return this;
        }

        public CatalogMaterializedTable build() {
            return new DefaultCatalogMaterializedTable(this.schema, this.comment, this.distribution, this.partitionKeys, this.options, this.snapshot, this.definitionQuery, this.freshness, this.logicalRefreshMode, this.refreshMode, this.refreshStatus, this.refreshHandlerDescription, this.serializedRefreshHandler);
        }
    }

    @PublicEvolving
    public static enum RefreshStatus {
        INITIALIZING,
        ACTIVATED,
        SUSPENDED;

    }

    @PublicEvolving
    public static enum RefreshMode {
        CONTINUOUS,
        FULL;

    }

    @PublicEvolving
    public static enum LogicalRefreshMode {
        CONTINUOUS,
        FULL,
        AUTOMATIC;

    }
}

