/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.dataview;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.dataview.DataView;
import org.apache.flink.table.types.DataType;

@PublicEvolving
public class MapView<K, V>
implements DataView {
    private Map<K, V> map = new HashMap();

    public Map<K, V> getMap() {
        return this.map;
    }

    public void setMap(Map<K, V> map) {
        this.map = map;
    }

    public V get(K key) throws Exception {
        return this.map.get(key);
    }

    public void put(K key, V value) throws Exception {
        this.map.put(key, value);
    }

    public void putAll(Map<K, V> map) throws Exception {
        this.map.putAll(map);
    }

    public void remove(K key) throws Exception {
        this.map.remove(key);
    }

    public boolean contains(K key) throws Exception {
        return this.map.containsKey(key);
    }

    public Iterable<Map.Entry<K, V>> entries() throws Exception {
        return this.map.entrySet();
    }

    public Iterable<K> keys() throws Exception {
        return this.map.keySet();
    }

    public Iterable<V> values() throws Exception {
        return this.map.values();
    }

    public Iterator<Map.Entry<K, V>> iterator() throws Exception {
        return this.map.entrySet().iterator();
    }

    public boolean isEmpty() throws Exception {
        return this.map.isEmpty();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MapView)) {
            return false;
        }
        MapView mapView = (MapView)o;
        return this.getMap().equals(mapView.getMap());
    }

    public int hashCode() {
        return Objects.hash(this.getMap());
    }

    public static DataType newMapViewDataType(DataType keyDataType, DataType valueDataType) {
        return DataTypes.STRUCTURED(MapView.class, DataTypes.FIELD("map", (DataType)DataTypes.MAP(keyDataType, valueDataType).bridgedTo(Map.class)));
    }
}

