/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.stream.Stream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.TypeStrategiesTestBase;
import org.apache.flink.table.types.inference.strategies.SpecificTypeStrategies;

class ToTimestampLtzTypeStrategyTest
extends TypeStrategiesTestBase {
    ToTimestampLtzTypeStrategyTest() {
    }

    @Override
    protected Stream<TypeStrategiesTestBase.TestSpec> testData() {
        return Stream.of(TypeStrategiesTestBase.TestSpec.forStrategy("Valid single argument of type <VARCHAR> or <CHAR>", SpecificTypeStrategies.TO_TIMESTAMP_LTZ).inputTypes(DataTypes.STRING()).expectDataType((DataType)DataTypes.TIMESTAMP_LTZ((int)3).nullable()), TypeStrategiesTestBase.TestSpec.forStrategy("TO_TIMESTAMP_LTZ(<NUMERIC>)", SpecificTypeStrategies.TO_TIMESTAMP_LTZ).inputTypes(DataTypes.BIGINT()).expectDataType((DataType)DataTypes.TIMESTAMP_LTZ((int)3).nullable()), TypeStrategiesTestBase.TestSpec.forStrategy("Invalid single argument type", SpecificTypeStrategies.TO_TIMESTAMP_LTZ).inputTypes(DataTypes.BOOLEAN()).expectErrorMessage("Unsupported argument type. When taking 1 argument, TO_TIMESTAMP_LTZ accepts an argument of type <VARCHAR>, <CHAR>, or <NUMERIC>."), TypeStrategiesTestBase.TestSpec.forStrategy("TO_TIMESTAMP_LTZ(<NUMERIC>, <INTEGER>)", SpecificTypeStrategies.TO_TIMESTAMP_LTZ).inputTypes(DataTypes.DOUBLE(), DataTypes.INT()).expectDataType((DataType)DataTypes.TIMESTAMP_LTZ((int)3).nullable()), TypeStrategiesTestBase.TestSpec.forStrategy("Valid two arguments of <VARCHAR> or <CHAR>", SpecificTypeStrategies.TO_TIMESTAMP_LTZ).inputTypes(DataTypes.STRING(), DataTypes.STRING()).expectDataType((DataType)DataTypes.TIMESTAMP_LTZ((int)3).nullable()), TypeStrategiesTestBase.TestSpec.forStrategy("Invalid second argument when the first argument is <NUMERIC>", SpecificTypeStrategies.TO_TIMESTAMP_LTZ).inputTypes(DataTypes.BIGINT(), DataTypes.STRING()).expectErrorMessage("Unsupported argument type. TO_TIMESTAMP_LTZ(<NUMERIC>, <INTEGER>) requires the second argument to be <INTEGER>."), TypeStrategiesTestBase.TestSpec.forStrategy("Invalid second argument when the first argument is <VARCHAR> or <CHAR>", SpecificTypeStrategies.TO_TIMESTAMP_LTZ).inputTypes(DataTypes.STRING(), DataTypes.FLOAT()).expectErrorMessage("Unsupported argument type. If the first argument is of type <VARCHAR> or <CHAR>, TO_TIMESTAMP_LTZ requires the second argument to be of type <VARCHAR> or <CHAR>."), TypeStrategiesTestBase.TestSpec.forStrategy("Invalid first argument when taking 2 arguments", SpecificTypeStrategies.TO_TIMESTAMP_LTZ).inputTypes(DataTypes.BOOLEAN(), DataTypes.FLOAT()).expectErrorMessage("Unsupported argument type. When taking 2 arguments, TO_TIMESTAMP_LTZ requires the first argument to be of type <VARCHAR>, <CHAR>, or <NUMERIC>."), TypeStrategiesTestBase.TestSpec.forStrategy("Valid three arguments", SpecificTypeStrategies.TO_TIMESTAMP_LTZ).inputTypes(DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING()).expectDataType((DataType)DataTypes.TIMESTAMP_LTZ((int)3).nullable()), TypeStrategiesTestBase.TestSpec.forStrategy("Invalid three arguments", SpecificTypeStrategies.TO_TIMESTAMP_LTZ).inputTypes(DataTypes.STRING(), DataTypes.INT(), DataTypes.STRING()).expectErrorMessage("Unsupported argument type. When taking 3 arguments, TO_TIMESTAMP_LTZ requires all three arguments to be of type <VARCHAR> or <CHAR>."), TypeStrategiesTestBase.TestSpec.forStrategy("No arguments", SpecificTypeStrategies.TO_TIMESTAMP_LTZ).inputTypes(new DataType[0]).expectErrorMessage("Unsupported argument type. TO_TIMESTAMP_LTZ requires 1 to 3 arguments, but 0 were provided."), TypeStrategiesTestBase.TestSpec.forStrategy("Too many arguments", SpecificTypeStrategies.TO_TIMESTAMP_LTZ).inputTypes(DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING()).expectErrorMessage("Unsupported argument type. TO_TIMESTAMP_LTZ requires 1 to 3 arguments, but 4 were provided."));
    }
}

