/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.test;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.test.ArrayDataAssert;
import org.apache.flink.table.test.DataTypeAssert;
import org.apache.flink.table.test.LogicalTypeAssert;
import org.apache.flink.table.test.MapDataAssert;
import org.apache.flink.table.test.RowAssert;
import org.apache.flink.table.test.RowDataAssert;
import org.apache.flink.table.test.RowDataListAssert;
import org.apache.flink.table.test.StringDataAssert;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.types.Row;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;

@Experimental
public class TableAssertions {
    private TableAssertions() {
    }

    public static RowAssert assertThat(Row row) {
        return new RowAssert(row);
    }

    public static ArrayDataAssert assertThat(ArrayData actual) {
        return new ArrayDataAssert(actual);
    }

    public static MapDataAssert assertThat(MapData actual) {
        return new MapDataAssert(actual);
    }

    public static RowDataAssert assertThat(RowData actual) {
        return new RowDataAssert(actual);
    }

    public static RowDataListAssert assertThatRows(Iterator<RowData> actual) {
        return new RowDataListAssert(StreamSupport.stream(Spliterators.spliteratorUnknownSize(actual, 16), false).collect(Collectors.toList()));
    }

    public static RowDataListAssert assertThatRows(Iterable<RowData> actual) {
        if (actual instanceof List) {
            return new RowDataListAssert((List)actual);
        }
        return new RowDataListAssert(StreamSupport.stream(actual.spliterator(), false).collect(Collectors.toList()));
    }

    public static RowDataListAssert assertThatRows(Stream<RowData> actual) {
        return new RowDataListAssert(actual.collect(Collectors.toList()));
    }

    public static RowDataListAssert assertThatRows(RowData ... rows) {
        return new RowDataListAssert(Arrays.asList(rows));
    }

    public static StringDataAssert assertThat(StringData actual) {
        return new StringDataAssert(actual);
    }

    public static AbstractAssert<?, ?> assertThatGenericDataOfType(Object actual, LogicalType logicalType) {
        if (actual instanceof ArrayData) {
            return new ArrayDataAssert((ArrayData)actual).asGeneric(logicalType);
        }
        if (actual instanceof MapData) {
            return new MapDataAssert((MapData)actual).asGeneric(logicalType);
        }
        if (actual instanceof RowData) {
            return new RowDataAssert((RowData)actual).asGeneric(logicalType);
        }
        if (actual instanceof StringData) {
            return new StringDataAssert((StringData)actual);
        }
        return Assertions.assertThatObject((Object)actual);
    }

    public static AbstractAssert<?, ?> assertThatGenericDataOfType(Object actual, DataType dataType) {
        return TableAssertions.assertThatGenericDataOfType(actual, dataType.getLogicalType());
    }

    public static DataTypeAssert assertThat(DataType actual) {
        return new DataTypeAssert(actual);
    }

    public static LogicalTypeAssert assertThat(LogicalType actual) {
        return new LogicalTypeAssert(actual);
    }
}

