/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.materializedtable;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.internal.TableResultImpl;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogMaterializedTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.TableChange;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.ddl.AlterTableChangeOperation;
import org.apache.flink.table.operations.materializedtable.AlterMaterializedTableOperation;

@Internal
public class AlterMaterializedTableChangeOperation
extends AlterMaterializedTableOperation {
    private final List<TableChange.MaterializedTableChange> tableChanges;
    private final CatalogMaterializedTable catalogMaterializedTable;

    public AlterMaterializedTableChangeOperation(ObjectIdentifier tableIdentifier, List<TableChange.MaterializedTableChange> tableChanges, CatalogMaterializedTable catalogMaterializedTable) {
        super(tableIdentifier);
        this.tableChanges = tableChanges;
        this.catalogMaterializedTable = catalogMaterializedTable;
    }

    public List<TableChange.MaterializedTableChange> getTableChanges() {
        return this.tableChanges;
    }

    public CatalogMaterializedTable getCatalogMaterializedTable() {
        return this.catalogMaterializedTable;
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        ctx.getCatalogManager().alterTable((CatalogBaseTable)this.getCatalogMaterializedTable(), this.getTableChanges().stream().map(TableChange.class::cast).collect(Collectors.toList()), this.getTableIdentifier(), false);
        return TableResultImpl.TABLE_RESULT_OK;
    }

    @Override
    public String asSummaryString() {
        String changes = this.tableChanges.stream().map(AlterMaterializedTableChangeOperation::toString).collect(Collectors.joining(",\n"));
        return String.format("ALTER MATERIALIZED TABLE %s\n%s", this.tableIdentifier.asSummaryString(), changes);
    }

    private static String toString(TableChange.MaterializedTableChange tableChange) {
        if (tableChange instanceof TableChange.ModifyRefreshStatus) {
            TableChange.ModifyRefreshStatus refreshStatus = (TableChange.ModifyRefreshStatus)tableChange;
            return String.format("  MODIFY REFRESH STATUS TO '%s'", refreshStatus.getRefreshStatus());
        }
        if (tableChange instanceof TableChange.ModifyRefreshHandler) {
            TableChange.ModifyRefreshHandler refreshHandler = (TableChange.ModifyRefreshHandler)tableChange;
            return String.format("  MODIFY REFRESH HANDLER DESCRIPTION TO '%s'", refreshHandler.getRefreshHandlerDesc());
        }
        if (tableChange instanceof TableChange.ModifyDefinitionQuery) {
            TableChange.ModifyDefinitionQuery definitionQuery = (TableChange.ModifyDefinitionQuery)tableChange;
            return String.format(" MODIFY DEFINITION QUERY TO '%s'", definitionQuery.getDefinitionQuery());
        }
        return AlterTableChangeOperation.toString((TableChange)tableChange);
    }
}

