/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.internal.TableResultImpl;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.module.Module;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.utils.EncodingUtils;
import org.apache.flink.util.Preconditions;

@Internal
public class LoadModuleOperation
implements Operation,
ExecutableOperation {
    private final String moduleName;
    private final Map<String, String> options;

    public LoadModuleOperation(String moduleName, Map<String, String> options) {
        this.moduleName = (String)Preconditions.checkNotNull((Object)moduleName);
        this.options = (Map)Preconditions.checkNotNull(options);
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public Map<String, String> getOptions() {
        return Collections.unmodifiableMap(this.options);
    }

    @Override
    public String asSummaryString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LOAD MODULE ");
        sb.append(EncodingUtils.escapeIdentifier((String)this.moduleName));
        if (!this.options.isEmpty()) {
            sb.append(" WITH (");
            sb.append(this.options.entrySet().stream().map(entry -> String.format("'%s' = '%s'", EncodingUtils.escapeSingleQuotes((String)((String)entry.getKey())), EncodingUtils.escapeSingleQuotes((String)((String)entry.getValue())))).collect(Collectors.joining(", ")));
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        try {
            Module module = FactoryUtil.createModule((String)this.getModuleName(), this.getOptions(), (ReadableConfig)ctx.getTableConfig(), (ClassLoader)ctx.getResourceManager().getUserClassLoader());
            ctx.getModuleManager().loadModule(this.getModuleName(), module);
            return TableResultImpl.TABLE_RESULT_OK;
        }
        catch (ValidationException e) {
            throw new ValidationException(String.format("Could not execute %s. %s", this.asSummaryString(), e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            throw new TableException(String.format("Could not execute %s. %s", this.asSummaryString(), e.getMessage()), (Throwable)e);
        }
    }
}

