/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ObjectToExpressionTest {
    ObjectToExpressionTest() {
    }

    @Test
    void testListConversion() {
        Expression expr = ApiExpressionUtils.objectToExpression(Arrays.asList(1, 2));
        ObjectToExpressionTest.assertThatEquals(expr, (Expression)Expressions.array((Object)1, (Object[])new Object[]{2}));
    }

    @Test
    void testNestedListConversion() {
        Expression expr = ApiExpressionUtils.objectToExpression(Arrays.asList(Collections.singletonList(1), Collections.singletonList(2)));
        ObjectToExpressionTest.assertThatEquals(expr, (Expression)Expressions.array((Object)Expressions.array((Object)1, (Object[])new Object[0]), (Object[])new Object[]{Expressions.array((Object)2, (Object[])new Object[0])}));
    }

    @Test
    void testMapConversion() {
        HashMap<String, List<Integer>> map = new HashMap<String, List<Integer>>();
        map.put("key1", Collections.singletonList(2));
        map.put("key2", Arrays.asList(1, 2));
        Expression expr = ApiExpressionUtils.objectToExpression(map);
        ObjectToExpressionTest.assertThatEquals(expr, (Expression)Expressions.map((Object)"key1", (Object)Expressions.array((Object)2, (Object[])new Object[0]), (Object[])new Object[]{"key2", Expressions.array((Object)1, (Object[])new Object[]{2})}));
    }

    @Test
    void testRowConversion() {
        Expression expr = ApiExpressionUtils.objectToExpression((Object)Row.of((Object[])new Object[]{1, "ABC", new int[]{1, 2, 3}, new byte[]{1, 2, 3}, null}));
        ObjectToExpressionTest.assertThatEquals(expr, (Expression)Expressions.row((Object)1, (Object[])new Object[]{"ABC", Expressions.array((Object)1, (Object[])new Object[]{2, 3}), Expressions.lit((Object)new byte[]{1, 2, 3}, (DataType)((DataType)DataTypes.BINARY((int)3).notNull())), Expressions.nullOf((DataType)DataTypes.NULL())}));
    }

    @Test
    void testRowWithDeleteKindConversion() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ApiExpressionUtils.objectToExpression((Object)Row.ofKind((RowKind)RowKind.DELETE, (Object[])new Object[]{1}))).isInstanceOf(ValidationException.class)).hasMessage("Unsupported kind 'DELETE' of a row [-D[1]]. Only rows with 'INSERT' kind are supported when converting to an expression.");
    }

    @Test
    void testRowWithUpdateBeforeKindConversion() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ApiExpressionUtils.objectToExpression((Object)Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{1}))).isInstanceOf(ValidationException.class)).hasMessage("Unsupported kind 'UPDATE_BEFORE' of a row [-U[1]]. Only rows with 'INSERT' kind are supported when converting to an expression.");
    }

    @Test
    void testRowWithUpdateAfterKindConversion() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ApiExpressionUtils.objectToExpression((Object)Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{1}))).isInstanceOf(ValidationException.class)).hasMessage("Unsupported kind 'UPDATE_AFTER' of a row [+U[1]]. Only rows with 'INSERT' kind are supported when converting to an expression.");
    }

    private static void assertThatEquals(Expression actual, Expression expected) {
        Assertions.assertThat((Object)ApiExpressionUtils.unwrapFromApi((Expression)actual)).isEqualTo((Object)ApiExpressionUtils.unwrapFromApi((Expression)expected));
    }
}

