/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.HashMap;
import java.util.List;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CommonCatalogOptions;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.catalog.GenericInMemoryCatalogFactoryOptions;
import org.apache.flink.table.factories.FactoryUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class GenericInMemoryCatalogFactoryTest {
    GenericInMemoryCatalogFactoryTest() {
    }

    @Test
    void test() throws Exception {
        String catalogName = "mycatalog";
        String databaseName = "mydatabase";
        GenericInMemoryCatalog expectedCatalog = new GenericInMemoryCatalog("mycatalog", "mydatabase");
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(CommonCatalogOptions.CATALOG_TYPE.key(), "generic_in_memory");
        options.put(GenericInMemoryCatalogFactoryOptions.DEFAULT_DATABASE.key(), "mydatabase");
        Catalog actualCatalog = FactoryUtil.createCatalog((String)"mycatalog", options, null, (ClassLoader)Thread.currentThread().getContextClassLoader());
        GenericInMemoryCatalogFactoryTest.checkEquals(expectedCatalog, (GenericInMemoryCatalog)actualCatalog);
    }

    private static void checkEquals(GenericInMemoryCatalog c1, GenericInMemoryCatalog c2) throws Exception {
        Assertions.assertThat((String)c2.getName()).isEqualTo(c1.getName());
        Assertions.assertThat((String)c2.getDefaultDatabase()).isEqualTo(c1.getDefaultDatabase());
        Assertions.assertThat((List)c2.listDatabases()).isEqualTo((Object)c1.listDatabases());
        String database = c1.getDefaultDatabase();
        Assertions.assertThat((List)c2.listTables(database)).isEqualTo((Object)c1.listTables(database));
        Assertions.assertThat((List)c2.listViews(database)).isEqualTo((Object)c1.listViews(database));
        Assertions.assertThat((List)c2.listFunctions(database)).isEqualTo((Object)c1.listFunctions(database));
    }
}

