/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.util.Map;
import java.util.Optional;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ModelDescriptor;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogModel;
import org.apache.flink.table.types.AbstractDataType;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ModelDescriptorTest {
    private static final ConfigOption<Boolean> OPTION_A = ConfigOptions.key((String)"a").booleanType().noDefaultValue();
    private static final ConfigOption<Integer> OPTION_B = ConfigOptions.key((String)"b").intType().noDefaultValue();
    private static final ConfigOption<String> TASK_OPTION = ConfigOptions.key((String)"task").stringType().noDefaultValue();

    ModelDescriptorTest() {
    }

    @Test
    void testBasic() {
        Schema inputSchema = Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.STRING()).column("f1", (AbstractDataType)DataTypes.BIGINT()).build();
        Schema outputSchema = Schema.newBuilder().column("response", (AbstractDataType)DataTypes.DOUBLE()).build();
        ModelDescriptor descriptor = ModelDescriptor.forProvider((String)"test-provider").inputSchema(inputSchema).outputSchema(outputSchema).comment("Test Model Comment").build();
        Assertions.assertThat((Optional)descriptor.getInputSchema()).isPresent();
        Assertions.assertThat((Object)((Schema)descriptor.getInputSchema().get())).isEqualTo((Object)inputSchema);
        Assertions.assertThat((Optional)descriptor.getOutputSchema()).isPresent();
        Assertions.assertThat((Object)((Schema)descriptor.getOutputSchema().get())).isEqualTo((Object)outputSchema);
        Assertions.assertThat((Map)descriptor.getOptions()).hasSize(1);
        Assertions.assertThat((Map)descriptor.getOptions()).containsEntry((Object)"provider", (Object)"test-provider");
        Assertions.assertThat((String)descriptor.getComment().orElse(null)).isEqualTo("Test Model Comment");
    }

    @Test
    void testNoSchemas() {
        ModelDescriptor descriptor = ModelDescriptor.forProvider((String)"test-provider").build();
        Assertions.assertThat((Optional)descriptor.getInputSchema()).isNotPresent();
        Assertions.assertThat((Optional)descriptor.getOutputSchema()).isNotPresent();
    }

    @Test
    void testOptions() {
        ModelDescriptor descriptor = ModelDescriptor.forProvider((String)"test-provider").inputSchema(Schema.newBuilder().build()).outputSchema(Schema.newBuilder().build()).option(OPTION_A, (Object)false).option(OPTION_B, (Object)42).option("task", "embedding").build();
        Assertions.assertThat((Map)descriptor.getOptions()).hasSize(4);
        Assertions.assertThat((Map)descriptor.getOptions()).containsEntry((Object)"provider", (Object)"test-provider");
        Assertions.assertThat((Map)descriptor.getOptions()).containsEntry((Object)"a", (Object)"false");
        Assertions.assertThat((Map)descriptor.getOptions()).containsEntry((Object)"b", (Object)"42");
        Assertions.assertThat((Map)descriptor.getOptions()).containsEntry((Object)"task", (Object)"embedding");
    }

    @Test
    void testToCatalogModel() {
        Schema inputSchema = Schema.newBuilder().column("feature1", (AbstractDataType)DataTypes.DOUBLE()).column("feature2", (AbstractDataType)DataTypes.DOUBLE()).build();
        Schema outputSchema = Schema.newBuilder().column("response", (AbstractDataType)DataTypes.STRING()).build();
        ModelDescriptor descriptor = ModelDescriptor.forProvider((String)"test-provider").inputSchema(inputSchema).outputSchema(outputSchema).option("task", "classification").comment("Test Model").build();
        CatalogModel catalogModel = descriptor.toCatalogModel();
        Assertions.assertThat((Object)catalogModel.getInputSchema()).isEqualTo((Object)inputSchema);
        Assertions.assertThat((Object)catalogModel.getOutputSchema()).isEqualTo((Object)outputSchema);
        Assertions.assertThat((Map)catalogModel.getOptions()).containsEntry((Object)"provider", (Object)"test-provider");
        Assertions.assertThat((Map)catalogModel.getOptions()).containsEntry((Object)"task", (Object)"classification");
        Assertions.assertThat((String)catalogModel.getComment()).isEqualTo("Test Model");
    }

    @Test
    void testToCatalogModelMissingInputSchema() {
        ModelDescriptor descriptor = ModelDescriptor.forProvider((String)"test-provider").outputSchema(Schema.newBuilder().column("output", (AbstractDataType)DataTypes.STRING()).build()).build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((ModelDescriptor)descriptor).toCatalogModel()).isInstanceOf(ValidationException.class)).hasMessage("Input schema missing in ModelDescriptor. Input schema cannot be null.");
    }

    @Test
    void testToCatalogModelMissingOutputSchema() {
        ModelDescriptor descriptor = ModelDescriptor.forProvider((String)"test-provider").inputSchema(Schema.newBuilder().column("input", (AbstractDataType)DataTypes.STRING()).build()).build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((ModelDescriptor)descriptor).toCatalogModel()).isInstanceOf(ValidationException.class)).hasMessage("Output schema missing in ModelDescriptor. Output schema cannot be null.");
    }

    @Test
    void testToString() {
        Schema inputSchema = Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.STRING()).column("f1", (AbstractDataType)DataTypes.INT()).build();
        Schema outputSchema = Schema.newBuilder().column("prediction", (AbstractDataType)DataTypes.DOUBLE()).build();
        ModelDescriptor modelDescriptor = ModelDescriptor.forProvider((String)"test-provider").inputSchema(inputSchema).outputSchema(outputSchema).option(OPTION_A, (Object)true).option("task", "regression").comment("Test Model Comment").build();
        Assertions.assertThat((String)modelDescriptor.toString()).isEqualTo("(\n  `f0` STRING,\n  `f1` INT\n)\n(\n  `prediction` DOUBLE\n)\nCOMMENT 'Test Model Comment'\nWITH (\n  'a' = 'true',\n  'task' = 'regression',\n  'provider' = 'test-provider'\n)");
    }

    @Test
    void testToBuilder() {
        Schema inputSchema = Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.STRING()).build();
        Schema outputSchema = Schema.newBuilder().column("prediction", (AbstractDataType)DataTypes.DOUBLE()).build();
        ModelDescriptor original = ModelDescriptor.forProvider((String)"test-provider").inputSchema(inputSchema).outputSchema(outputSchema).option("task", "classification").comment("Original Comment").build();
        ModelDescriptor modified = original.toBuilder().option("new-option", "new-value").comment("Modified Comment").build();
        Assertions.assertThat((String)original.getComment().orElse(null)).isEqualTo("Original Comment");
        Assertions.assertThat((Map)original.getOptions()).doesNotContainKey((Object)"new-option");
        Assertions.assertThat((String)modified.getComment().orElse(null)).isEqualTo("Modified Comment");
        Assertions.assertThat((Map)modified.getOptions()).containsEntry((Object)"new-option", (Object)"new-value");
        Assertions.assertThat((Map)modified.getOptions()).containsEntry((Object)"task", (Object)"classification");
        Assertions.assertThat((Map)modified.getOptions()).containsEntry((Object)"provider", (Object)"test-provider");
        Assertions.assertThat((Optional)modified.getInputSchema()).isEqualTo((Object)original.getInputSchema());
        Assertions.assertThat((Optional)modified.getOutputSchema()).isEqualTo((Object)original.getOutputSchema());
    }

    @Test
    void testEqualsAndHashCode() {
        Schema inputSchema = Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.STRING()).build();
        Schema outputSchema = Schema.newBuilder().column("prediction", (AbstractDataType)DataTypes.DOUBLE()).build();
        ModelDescriptor descriptor1 = ModelDescriptor.forProvider((String)"test-provider").inputSchema(inputSchema).outputSchema(outputSchema).option("task", "regression").comment("Test Comment").build();
        ModelDescriptor descriptor2 = ModelDescriptor.forProvider((String)"test-provider").inputSchema(inputSchema).outputSchema(outputSchema).option("task", "regression").comment("Test Comment").build();
        ModelDescriptor descriptor3 = ModelDescriptor.forProvider((String)"different-provider").inputSchema(inputSchema).outputSchema(outputSchema).option("task", "regression").comment("Test Comment").build();
        Assertions.assertThat((Object)descriptor1).isEqualTo((Object)descriptor2);
        Assertions.assertThat((Object)descriptor1).isNotEqualTo((Object)descriptor3);
        Assertions.assertThat((Object)descriptor1).isNotEqualTo(null);
        Assertions.assertThat((Object)descriptor1).isNotEqualTo((Object)"not a model descriptor");
        Assertions.assertThat((int)descriptor1.hashCode()).isEqualTo(descriptor2.hashCode());
    }

    @Test
    void testBuilderExceptions() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ModelDescriptor.forProvider(null)).isInstanceOf(NullPointerException.class)).hasMessage("Model descriptors require a provider value.");
        ModelDescriptor.Builder builder = ModelDescriptor.forProvider((String)"test-provider");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> builder.option((ConfigOption)null, (Object)"value")).isInstanceOf(NullPointerException.class)).hasMessage("Config option must not be null.");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> builder.option(TASK_OPTION, null)).isInstanceOf(NullPointerException.class)).hasMessage("Value must not be null.");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> builder.option((String)null, "value")).isInstanceOf(NullPointerException.class)).hasMessage("Key must not be null.");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> builder.option("key", null)).isInstanceOf(NullPointerException.class)).hasMessage("Value must not be null.");
    }

    @Test
    void testNullComment() {
        ModelDescriptor descriptor = ModelDescriptor.forProvider((String)"test-provider").comment(null).build();
        Assertions.assertThat((Optional)descriptor.getComment()).isNotPresent();
    }
}

