/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ModelDescriptor;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogModel;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.ContextResolvedModel;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.ResolvedCatalogBaseTable;
import org.apache.flink.table.catalog.ResolvedCatalogModel;
import org.apache.flink.table.catalog.exceptions.ModelNotExistException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.operations.SourceQueryOperation;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.utils.TableEnvironmentMock;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

class TableEnvironmentTest {
    private TableEnvironmentMock tEnv;
    private static final Schema TEST_SCHEMA = Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.INT()).build();
    private static final Schema TEST_SCHEMA_2 = Schema.newBuilder().column("f1", (AbstractDataType)DataTypes.INT()).build();
    private static final TableDescriptor TEST_DESCRIPTOR = TableDescriptor.forConnector((String)"fake").schema(TEST_SCHEMA).option("a", "Test").build();
    private static final ModelDescriptor TEST_MODEL_DESCRIPTOR = ModelDescriptor.forProvider((String)"TestProvider").option("a", "Test").inputSchema(TEST_SCHEMA).outputSchema(TEST_SCHEMA).build();
    private static final ModelDescriptor TEST_MODEL_DESCRIPTOR_2 = ModelDescriptor.forProvider((String)"TestProvider").option("a", "Test").inputSchema(TEST_SCHEMA).outputSchema(TEST_SCHEMA_2).build();

    TableEnvironmentTest() {
    }

    private static Stream<Arguments> getModelNamesAndDescriptors() {
        return Stream.of(Arguments.of((Object[])new Object[]{"M", TEST_MODEL_DESCRIPTOR}), Arguments.of((Object[])new Object[]{"M2", TEST_MODEL_DESCRIPTOR_2}));
    }

    @BeforeEach
    void setUp() {
        this.tEnv = TableEnvironmentMock.getStreamingInstance();
    }

    @Test
    void testCreateTemporaryTableFromDescriptor() {
        TableEnvironmentTest.assertTemporaryCreateTableFromDescriptor(this.tEnv, TEST_SCHEMA, false);
    }

    @Test
    void testCreateTemporaryTableIfNotExistsFromDescriptor() {
        TableEnvironmentTest.assertTemporaryCreateTableFromDescriptor(this.tEnv, TEST_SCHEMA, true);
        Assertions.assertThatNoException().isThrownBy(() -> this.tEnv.createTemporaryTable("T", TEST_DESCRIPTOR, true));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tEnv.createTemporaryTable("T", TEST_DESCRIPTOR, false)).isInstanceOf(ValidationException.class)).hasMessageContaining("Temporary table '`default_catalog`.`default_database`.`T`' already exists");
    }

    @Test
    void testCreateTableFromDescriptor() throws Exception {
        TableEnvironmentTest.assertCreateTableFromDescriptor(this.tEnv, TEST_SCHEMA, false);
    }

    @ParameterizedTest(name="{index}: ignoreIfExists ({0})")
    @ValueSource(booleans={true, false})
    void testCreateViewFromTable(boolean ignoreIfExists) throws Exception {
        String catalog = this.tEnv.getCurrentCatalog();
        String database = this.tEnv.getCurrentDatabase();
        this.tEnv.createTable("T", TEST_DESCRIPTOR);
        Assertions.assertThat((boolean)this.tEnv.createView("V", this.tEnv.from("T"), ignoreIfExists)).isTrue();
        ObjectPath objectPath = new ObjectPath(database, "V");
        CatalogBaseTable catalogView = ((Catalog)this.tEnv.getCatalog(catalog).orElseThrow(AssertionError::new)).getTable(objectPath);
        Assertions.assertThat((Object)catalogView).isInstanceOf(CatalogView.class);
        Assertions.assertThat((Object)catalogView.getUnresolvedSchema()).isEqualTo((Object)TEST_SCHEMA);
    }

    @Test
    void testCreateViewWithSameNameIgnoreIfExists() {
        this.tEnv.createTable("T", TEST_DESCRIPTOR);
        this.tEnv.createView("V", this.tEnv.from("T"));
        Assertions.assertThat((boolean)this.tEnv.createView("V", this.tEnv.from("T"), true)).isFalse();
    }

    @Test
    void testCreateViewWithSameName() {
        this.tEnv.createTable("T", TEST_DESCRIPTOR);
        this.tEnv.createView("V", this.tEnv.from("T"));
        Assertions.assertThatThrownBy(() -> this.tEnv.createView("V", this.tEnv.from("T"), false)).hasCauseInstanceOf(TableAlreadyExistException.class).hasMessageContaining("Could not execute CreateTable in path `default_catalog`.`default_database`.`V`");
        Assertions.assertThatThrownBy(() -> this.tEnv.createView("V", this.tEnv.from("T"))).hasCauseInstanceOf(TableAlreadyExistException.class).hasMessageContaining("Could not execute CreateTable in path `default_catalog`.`default_database`.`V`");
    }

    @Test
    void testCreateTableIfNotExistsFromDescriptor() throws Exception {
        TableEnvironmentTest.assertCreateTableFromDescriptor(this.tEnv, TEST_SCHEMA, true);
        Assertions.assertThatNoException().isThrownBy(() -> this.tEnv.createTable("T", TEST_DESCRIPTOR, true));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tEnv.createTable("T", TEST_DESCRIPTOR, false)).isInstanceOf(ValidationException.class)).hasMessageContaining("Could not execute CreateTable in path `default_catalog`.`default_database`.`T`");
    }

    @Test
    void testTableFromDescriptor() {
        Table table = this.tEnv.from(TEST_DESCRIPTOR);
        Assertions.assertThat((Object)Schema.newBuilder().fromResolvedSchema(table.getResolvedSchema()).build()).isEqualTo((Object)TEST_SCHEMA);
        ((ObjectAssert)Assertions.assertThat((Object)table.getQueryOperation()).asInstanceOf(InstanceOfAssertFactories.type(SourceQueryOperation.class))).extracting(SourceQueryOperation::getContextResolvedTable).satisfies(new ThrowingConsumer[]{crs -> {
            Assertions.assertThat((boolean)crs.isAnonymous()).isTrue();
            Assertions.assertThat((List)crs.getIdentifier().toList()).hasSize(1);
            Assertions.assertThat((Map)crs.getResolvedTable().getOptions()).containsEntry((Object)"connector", (Object)"fake");
        }});
        Assertions.assertThat((Collection)this.tEnv.getCatalogManager().listTables()).isEmpty();
    }

    @ParameterizedTest
    @MethodSource(value={"getModelNamesAndDescriptors"})
    void testCreateModelFromDescriptor(String modelPath, ModelDescriptor modelDescriptor) throws Exception {
        TableEnvironmentTest.assertCreateModelFromDescriptor(this.tEnv, modelPath, modelDescriptor);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testCreateModelWithSameNameWithIgnoreIfExists(boolean ignoreIfExists) throws Exception {
        TableEnvironmentTest.assertCreateModelFromDescriptor(this.tEnv, "M", TEST_MODEL_DESCRIPTOR);
        if (ignoreIfExists) {
            Assertions.assertThatNoException().isThrownBy(() -> this.tEnv.createModel("M", TEST_MODEL_DESCRIPTOR, true));
        } else {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tEnv.createModel("M", TEST_MODEL_DESCRIPTOR, false)).isInstanceOf(ValidationException.class)).hasMessage("Could not execute CreateModel in path `default_catalog`.`default_database`.`M`");
        }
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tEnv.createModel("M", TEST_MODEL_DESCRIPTOR)).isInstanceOf(ValidationException.class)).hasMessage("Could not execute CreateModel in path `default_catalog`.`default_database`.`M`");
    }

    @Test
    void testDropModel() throws Exception {
        this.tEnv.createModel("M", TEST_MODEL_DESCRIPTOR);
        String catalog = this.tEnv.getCurrentCatalog();
        String database = this.tEnv.getCurrentDatabase();
        ObjectPath objectPath = new ObjectPath(database, "M");
        CatalogModel catalogModel = ((Catalog)this.tEnv.getCatalog(catalog).orElseThrow(AssertionError::new)).getModel(objectPath);
        Assertions.assertThat((Object)catalogModel).isInstanceOf(CatalogModel.class);
        Assertions.assertThat((boolean)this.tEnv.dropModel("M", true)).isTrue();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Catalog)this.tEnv.getCatalog(catalog).orElseThrow(AssertionError::new)).getModel(objectPath)).isInstanceOf(ModelNotExistException.class)).hasMessage("Model '`default_catalog`.`default_database`.`M`' does not exist.");
    }

    @Test
    void testNonExistingDropModel() throws Exception {
        Assertions.assertThat((boolean)this.tEnv.dropModel("M", true)).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tEnv.dropModel("M", false)).isInstanceOf(ValidationException.class)).hasMessage("Model with identifier 'default_catalog.default_database.M' does not exist.");
    }

    @ParameterizedTest
    @MethodSource(value={"getModelNamesAndDescriptors"})
    void testCreateTemporaryModelFromDescriptor(String modelPath, ModelDescriptor modelDescriptor) {
        TableEnvironmentTest.assertTemporaryCreateModelFromDescriptor(this.tEnv, modelPath, modelDescriptor);
        Assertions.assertThatNoException().isThrownBy(() -> this.tEnv.createTemporaryModel(modelPath, modelDescriptor, true));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tEnv.createTemporaryModel(modelPath, modelDescriptor, false)).isInstanceOf(ValidationException.class)).hasMessage(String.format("Temporary model '`default_catalog`.`default_database`.`%s`' already exists", modelPath));
    }

    @Test
    void testListModels() {
        this.tEnv.createModel("M1", TEST_MODEL_DESCRIPTOR);
        this.tEnv.createModel("M2", TEST_MODEL_DESCRIPTOR);
        Assertions.assertThat((Object[])this.tEnv.listModels()).containsExactly((Object[])new String[]{"M1", "M2"});
    }

    private static void assertCreateTableFromDescriptor(TableEnvironmentMock tEnv, Schema schema, boolean ignoreIfExists) throws TableNotExistException {
        String catalog = tEnv.getCurrentCatalog();
        String database = tEnv.getCurrentDatabase();
        if (ignoreIfExists) {
            Assertions.assertThat((boolean)tEnv.createTable("T", TEST_DESCRIPTOR, true)).isTrue();
        } else {
            tEnv.createTable("T", TEST_DESCRIPTOR);
        }
        ObjectPath objectPath = new ObjectPath(database, "T");
        Assertions.assertThat((boolean)((Catalog)tEnv.getCatalog(catalog).orElseThrow(AssertionError::new)).tableExists(objectPath)).isTrue();
        CatalogBaseTable catalogTable = ((Catalog)tEnv.getCatalog(catalog).orElseThrow(AssertionError::new)).getTable(objectPath);
        Assertions.assertThat((Object)catalogTable).isInstanceOf(CatalogTable.class);
        Assertions.assertThat((Object)catalogTable.getUnresolvedSchema()).isEqualTo((Object)schema);
        Assertions.assertThat((Map)catalogTable.getOptions()).contains(new Map.Entry[]{Assertions.entry((Object)"connector", (Object)"fake"), Assertions.entry((Object)"a", (Object)"Test")});
    }

    private static void assertTemporaryCreateTableFromDescriptor(TableEnvironmentMock tEnv, Schema schema, boolean ignoreIfExists) {
        String catalog = tEnv.getCurrentCatalog();
        String database = tEnv.getCurrentDatabase();
        if (ignoreIfExists) {
            tEnv.createTemporaryTable("T", TEST_DESCRIPTOR, true);
        } else {
            tEnv.createTemporaryTable("T", TEST_DESCRIPTOR);
        }
        Assertions.assertThat((boolean)((Catalog)tEnv.getCatalog(catalog).orElseThrow(AssertionError::new)).tableExists(new ObjectPath(database, "T"))).isFalse();
        Optional lookupResult = tEnv.getCatalogManager().getTable(ObjectIdentifier.of((String)catalog, (String)database, (String)"T"));
        Assertions.assertThat((Optional)lookupResult).isPresent();
        ResolvedCatalogBaseTable catalogTable = ((ContextResolvedTable)lookupResult.get()).getResolvedTable();
        Assertions.assertThat((boolean)(catalogTable instanceof CatalogTable)).isTrue();
        Assertions.assertThat((Object)catalogTable.getUnresolvedSchema()).isEqualTo((Object)schema);
        Assertions.assertThat((String)((String)catalogTable.getOptions().get("connector"))).isEqualTo("fake");
        Assertions.assertThat((String)((String)catalogTable.getOptions().get("a"))).isEqualTo("Test");
    }

    private static void assertCreateModelFromDescriptor(TableEnvironmentMock tEnv, String modelPath, ModelDescriptor modelDescriptor) throws ModelNotExistException {
        String catalog = tEnv.getCurrentCatalog();
        String database = tEnv.getCurrentDatabase();
        tEnv.createModel(modelPath, modelDescriptor, true);
        ObjectPath objectPath = new ObjectPath(database, modelPath);
        CatalogModel catalogModel = ((Catalog)tEnv.getCatalog(catalog).orElseThrow(AssertionError::new)).getModel(objectPath);
        TableEnvironmentTest.assertCatalogModelWithModelDescriptor(catalogModel, modelDescriptor);
    }

    private static void assertTemporaryCreateModelFromDescriptor(TableEnvironmentMock tEnv, String modelPath, ModelDescriptor modelDescriptor) {
        String catalog = tEnv.getCurrentCatalog();
        String database = tEnv.getCurrentDatabase();
        tEnv.createTemporaryModel(modelPath, modelDescriptor, true);
        Optional lookupResult = tEnv.getCatalogManager().getModel(ObjectIdentifier.of((String)catalog, (String)database, (String)modelPath));
        Assertions.assertThat((Optional)lookupResult).isPresent();
        ResolvedCatalogModel catalogModel = ((ContextResolvedModel)lookupResult.get()).getResolvedModel();
        TableEnvironmentTest.assertCatalogModelWithModelDescriptor((CatalogModel)catalogModel, modelDescriptor);
    }

    private static void assertCatalogModelWithModelDescriptor(CatalogModel catalogModel, ModelDescriptor modelDescriptor) {
        Assertions.assertThat((Object)catalogModel).isNotNull();
        Assertions.assertThat((Object)catalogModel).isInstanceOf(CatalogModel.class);
        Assertions.assertThat((Object)catalogModel.getInputSchema()).isEqualTo(modelDescriptor.getInputSchema().get());
        Assertions.assertThat((Object)catalogModel.getOutputSchema()).isEqualTo(modelDescriptor.getOutputSchema().get());
        for (Map.Entry entry : modelDescriptor.getOptions().entrySet()) {
            Assertions.assertThat((Map)catalogModel.getOptions()).contains(new Map.Entry[]{entry});
            Assertions.assertThat((Map)catalogModel.getOptions()).containsEntry((Object)((String)entry.getKey()), (Object)((String)entry.getValue()));
        }
    }
}

