/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.FunctionLanguage;
import org.apache.flink.table.resource.ResourceUri;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

@Internal
public class CatalogFunctionImpl
implements CatalogFunction {
    private final String className;
    private final FunctionLanguage functionLanguage;
    private final List<ResourceUri> resourceUris;
    private final Map<String, String> options;

    public CatalogFunctionImpl(String className) {
        this(className, FunctionLanguage.JAVA, Collections.emptyList());
    }

    public CatalogFunctionImpl(String className, FunctionLanguage functionLanguage) {
        this(className, functionLanguage, Collections.emptyList());
    }

    public CatalogFunctionImpl(String className, FunctionLanguage functionLanguage, List<ResourceUri> resourceUris) {
        this(className, functionLanguage, resourceUris, Collections.emptyMap());
    }

    public CatalogFunctionImpl(String className, FunctionLanguage functionLanguage, List<ResourceUri> resourceUris, Map<String, String> options) {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)className) ? 1 : 0) != 0, (Object)"className cannot be null or empty");
        this.className = className;
        this.functionLanguage = (FunctionLanguage)Preconditions.checkNotNull((Object)functionLanguage, (String)"functionLanguage cannot be null");
        this.resourceUris = resourceUris;
        this.options = (Map)Preconditions.checkNotNull(options, (String)"options cannot be null");
    }

    public String getClassName() {
        return this.className;
    }

    public CatalogFunction copy() {
        return new CatalogFunctionImpl(this.getClassName(), this.functionLanguage, Collections.unmodifiableList(this.resourceUris), Collections.unmodifiableMap(this.options));
    }

    public Optional<String> getDescription() {
        return Optional.of("This is a user-defined function");
    }

    public Optional<String> getDetailedDescription() {
        return Optional.of("This is a user-defined function");
    }

    public FunctionLanguage getFunctionLanguage() {
        return this.functionLanguage;
    }

    public List<ResourceUri> getFunctionResources() {
        return this.resourceUris;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogFunctionImpl that = (CatalogFunctionImpl)o;
        return Objects.equals(this.className, that.className) && this.functionLanguage == that.functionLanguage && Objects.equals(this.resourceUris, that.resourceUris) && Objects.equals(this.options, that.options);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.className);
        result = 31 * result + Objects.hashCode(this.functionLanguage);
        result = 31 * result + Objects.hashCode(this.resourceUris);
        result = 31 * result + Objects.hashCode(this.options);
        return result;
    }

    public String toString() {
        return "CatalogFunctionImpl{className='" + this.getClassName() + "', functionLanguage='" + this.getFunctionLanguage() + "', functionResource='" + this.getFunctionResources() + "', options='" + this.getOptions() + "'}";
    }
}

