/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.PojoField;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.api.ApiExpression;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.typeutils.FieldInfoUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class FieldInfoUtilsTest {
    private final RowTypeInfo rowTypeInfo = new RowTypeInfo(new TypeInformation[]{Types.INT, Types.LONG, Types.SQL_TIMESTAMP}, new String[]{"f0", "f1", "f2"});

    FieldInfoUtilsTest() {
    }

    private static Stream<TypeInformation> parameters() throws Exception {
        return Stream.of(new RowTypeInfo(new TypeInformation[]{Types.INT, Types.LONG, Types.SQL_TIMESTAMP}, new String[]{"f0", "f1", "f2"}), new PojoTypeInfo(MyPojo.class, Arrays.asList(new PojoField(MyPojo.class.getDeclaredField("f0"), Types.INT), new PojoField(MyPojo.class.getDeclaredField("f1"), Types.LONG), new PojoField(MyPojo.class.getDeclaredField("f2"), Types.SQL_TIMESTAMP))));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    void testByNameModeReorder(TypeInformation typeInfo) {
        FieldInfoUtils.TypeInfoSchema schema = FieldInfoUtils.getFieldsInfo((TypeInformation)typeInfo, (Expression[])new Expression[]{Expressions.$((String)"f2"), Expressions.$((String)"f1"), Expressions.$((String)"f0")});
        Assertions.assertThat((Object[])schema.getFieldNames()).isEqualTo((Object)new String[]{"f2", "f1", "f0"});
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    void testByNameModeReorderAndRename(TypeInformation typeInfo) {
        FieldInfoUtils.TypeInfoSchema schema = FieldInfoUtils.getFieldsInfo((TypeInformation)typeInfo, (Expression[])new Expression[]{(Expression)Expressions.$((String)"f1").as("aa", new String[0]), (Expression)Expressions.$((String)"f0").as("bb", new String[0]), (Expression)Expressions.$((String)"f2").as("cc", new String[0])});
        Assertions.assertThat((Object[])schema.getFieldNames()).isEqualTo((Object)new String[]{"aa", "bb", "cc"});
    }

    @Test
    void testByPositionMode() {
        FieldInfoUtils.TypeInfoSchema schema = FieldInfoUtils.getFieldsInfo((TypeInformation)this.rowTypeInfo, (Expression[])new Expression[]{Expressions.$((String)"aa"), Expressions.$((String)"bb"), Expressions.$((String)"cc")});
        Assertions.assertThat((Object[])schema.getFieldNames()).isEqualTo((Object)new String[]{"aa", "bb", "cc"});
    }

    @Test
    void testByPositionModeProcTime() {
        FieldInfoUtils.TypeInfoSchema schema = FieldInfoUtils.getFieldsInfo((TypeInformation)this.rowTypeInfo, (Expression[])new Expression[]{Expressions.$((String)"aa"), Expressions.$((String)"bb"), Expressions.$((String)"cc"), (Expression)((ApiExpression)Expressions.$((String)"cc").proctime()).as("proctime", new String[0])});
        Assertions.assertThat((Object[])schema.getFieldNames()).isEqualTo((Object)new String[]{"aa", "bb", "cc", "proctime"});
    }

    public static class MyPojo {
        public int f0;
        public long f1;
        public Timestamp f2;
    }
}

