/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.test.program;

import java.util.List;
import org.apache.flink.table.api.CompiledPlan;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.test.program.TestStep;

public final class StatementSetTestStep
implements TestStep {
    private StatementSet statementSet = null;
    public final List<String> statements;

    StatementSetTestStep(List<String> statements) {
        this.statements = statements;
    }

    @Override
    public TestStep.TestKind getKind() {
        return TestStep.TestKind.STATEMENT_SET;
    }

    public CompiledPlan compiledPlan(TableEnvironment env) {
        this.statementSet = env.createStatementSet();
        this.statements.forEach(arg_0 -> ((StatementSet)this.statementSet).addInsertSql(arg_0));
        return this.statementSet.compilePlan();
    }

    public TableResult apply(TableEnvironment env) {
        if (this.statementSet == null) {
            this.statementSet = env.createStatementSet();
            this.statements.forEach(arg_0 -> ((StatementSet)this.statementSet).addInsertSql(arg_0));
        }
        return this.statementSet.execute();
    }
}

