/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.internal.ShowCreateUtil;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDescriptor;
import org.apache.flink.table.catalog.CatalogMaterializedTable;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.IntervalFreshness;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogBaseTable;
import org.apache.flink.table.catalog.ResolvedCatalogMaterializedTable;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedCatalogView;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.TableDistribution;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.expressions.DefaultSqlFactory;
import org.apache.flink.table.expressions.SqlFactory;
import org.apache.flink.table.types.DataType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class ShowCreateUtilTest {
    private static final ObjectIdentifier TABLE_IDENTIFIER = ObjectIdentifier.of((String)"catalogName", (String)"dbName", (String)"tableName");
    private static final ObjectIdentifier VIEW_IDENTIFIER = ObjectIdentifier.of((String)"catalogName", (String)"dbName", (String)"viewName");
    private static final ObjectIdentifier MATERIALIZED_TABLE_IDENTIFIER = ObjectIdentifier.of((String)"catalogName", (String)"dbName", (String)"materializedTableName");
    private static final ResolvedSchema ONE_COLUMN_SCHEMA = ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"id", (DataType)DataTypes.INT())});
    private static final ResolvedSchema ONE_COLUMN_SCHEMA_WITH_PRIMARY_KEY = new ResolvedSchema(List.of(Column.physical((String)"id", (DataType)DataTypes.INT())), List.of(), UniqueConstraint.primaryKey((String)"pk", List.of("id")), List.of());
    private static final ResolvedSchema TWO_COLUMNS_SCHEMA = ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"id", (DataType)DataTypes.INT()), Column.physical((String)"name", (DataType)DataTypes.STRING())});

    ShowCreateUtilTest() {
    }

    @ParameterizedTest(name="{index}: {2}")
    @MethodSource(value={"argsForShowCreateTable"})
    void showCreateTable(ResolvedCatalogTable resolvedCatalogTable, boolean isTemporary, String expected) {
        String createTableString = ShowCreateUtil.buildShowCreateTableRow((ResolvedCatalogBaseTable)resolvedCatalogTable, (ObjectIdentifier)TABLE_IDENTIFIER, (boolean)isTemporary, (SqlFactory)DefaultSqlFactory.INSTANCE);
        Assertions.assertThat((String)createTableString).isEqualTo(expected);
    }

    @ParameterizedTest(name="{index}: {2}")
    @MethodSource(value={"argsForShowCreateView"})
    void showCreateView(ResolvedCatalogView resolvedCatalogView, boolean isTemporary, String expected) {
        String createViewString = ShowCreateUtil.buildShowCreateViewRow((ResolvedCatalogBaseTable)resolvedCatalogView, (ObjectIdentifier)VIEW_IDENTIFIER, (boolean)isTemporary);
        Assertions.assertThat((String)createViewString).isEqualTo(expected);
    }

    @ParameterizedTest(name="{index}: {2}")
    @MethodSource(value={"argsForShowCreateMaterializedTable"})
    void showCreateMaterializedTable(ResolvedCatalogMaterializedTable materializedTable, boolean isTemporary, String expected) {
        String createMaterializedTableString = ShowCreateUtil.buildShowCreateMaterializedTableRow((ResolvedCatalogMaterializedTable)materializedTable, (ObjectIdentifier)MATERIALIZED_TABLE_IDENTIFIER, (boolean)isTemporary);
        Assertions.assertThat((String)createMaterializedTableString).isEqualTo(expected);
    }

    @ParameterizedTest(name="{index}: {1}")
    @MethodSource(value={"argsForShowCreateCatalog"})
    void showCreateCatalog(CatalogDescriptor catalogDescriptor, String expected) {
        String createCatalogString = ShowCreateUtil.buildShowCreateCatalogRow((CatalogDescriptor)catalogDescriptor);
        Assertions.assertThat((String)createCatalogString).isEqualTo(expected);
    }

    private static Collection<Arguments> argsForShowCreateCatalog() {
        ArrayList<Arguments> argList = new ArrayList<Arguments>();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("k_a", "v_a");
        options.put("k_b", "v_b");
        options.put("k_c", "v_c");
        Configuration configuration = Configuration.fromMap(options);
        argList.add(Arguments.of((Object[])new Object[]{CatalogDescriptor.of((String)"catalogName", (Configuration)configuration), "CREATE CATALOG `catalogName`\nWITH (\n  'k_a' = 'v_a',\n  'k_b' = 'v_b',\n  'k_c' = 'v_c'\n)\n"}));
        argList.add(Arguments.of((Object[])new Object[]{CatalogDescriptor.of((String)"catalogName", (Configuration)configuration).setComment("Catalog comment"), "CREATE CATALOG `catalogName`\nCOMMENT 'Catalog comment'\nWITH (\n  'k_a' = 'v_a',\n  'k_b' = 'v_b',\n  'k_c' = 'v_c'\n)\n"}));
        return argList;
    }

    private static Collection<Arguments> argsForShowCreateView() {
        ArrayList<Arguments> argList = new ArrayList<Arguments>();
        ShowCreateUtilTest.addTemporaryAndPermanent(argList, (CatalogBaseTable)ShowCreateUtilTest.createResolvedView(ONE_COLUMN_SCHEMA, "SELECT 1", "SELECT 1", null), "CREATE %sVIEW `catalogName`.`dbName`.`viewName` (\n  `id`\n)\nAS SELECT 1\n");
        ShowCreateUtilTest.addTemporaryAndPermanent(argList, (CatalogBaseTable)ShowCreateUtilTest.createResolvedView(TWO_COLUMNS_SCHEMA, "SELECT id, name FROM tbl_a", "SELECT id, name FROM `catalogName`.`dbName`.`tbl_a`", "View comment"), "CREATE %sVIEW `catalogName`.`dbName`.`viewName` (\n  `id`,\n  `name`\n)\nCOMMENT 'View comment'\nAS SELECT id, name FROM `catalogName`.`dbName`.`tbl_a`\n");
        return argList;
    }

    private static Collection<Arguments> argsForShowCreateTable() {
        ArrayList<Arguments> argList = new ArrayList<Arguments>();
        ShowCreateUtilTest.addTemporaryAndPermanent(argList, (CatalogBaseTable)ShowCreateUtilTest.createResolvedTable(ONE_COLUMN_SCHEMA, Collections.emptyMap(), Collections.emptyList(), TableDistribution.of((TableDistribution.Kind)TableDistribution.Kind.HASH, (Integer)2, Arrays.asList("key1", "key2")), null), "CREATE %sTABLE `catalogName`.`dbName`.`tableName` (\n  `id` INT\n)\nDISTRIBUTED BY HASH(`key1`, `key2`) INTO 2 BUCKETS\n");
        ShowCreateUtilTest.addTemporaryAndPermanent(argList, (CatalogBaseTable)ShowCreateUtilTest.createResolvedTable(ONE_COLUMN_SCHEMA, Collections.emptyMap(), Collections.emptyList(), TableDistribution.of((TableDistribution.Kind)TableDistribution.Kind.RANGE, (Integer)2, Arrays.asList("1", "10")), "Table comment"), "CREATE %sTABLE `catalogName`.`dbName`.`tableName` (\n  `id` INT\n)\nCOMMENT 'Table comment'\nDISTRIBUTED BY RANGE(`1`, `10`) INTO 2 BUCKETS\n");
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("option_key_a", "option_value_a");
        options.put("option_key_b", "option_value_b");
        options.put("option_key_c", "option_value_c");
        ShowCreateUtilTest.addTemporaryAndPermanent(argList, (CatalogBaseTable)ShowCreateUtilTest.createResolvedTable(TWO_COLUMNS_SCHEMA, options, Collections.emptyList(), null, "Another table comment"), "CREATE %sTABLE `catalogName`.`dbName`.`tableName` (\n  `id` INT,\n  `name` VARCHAR(2147483647)\n)\nCOMMENT 'Another table comment'\nWITH (\n  'option_key_a' = 'option_value_a',\n  'option_key_b' = 'option_value_b',\n  'option_key_c' = 'option_value_c'\n)\n");
        ShowCreateUtilTest.addTemporaryAndPermanent(argList, (CatalogBaseTable)ShowCreateUtilTest.createResolvedTable(ONE_COLUMN_SCHEMA, Collections.emptyMap(), Arrays.asList("key1", "key2"), null, "comment"), "CREATE %sTABLE `catalogName`.`dbName`.`tableName` (\n  `id` INT\n)\nCOMMENT 'comment'\nPARTITIONED BY (`key1`, `key2`)\n");
        ShowCreateUtilTest.addTemporaryAndPermanent(argList, (CatalogBaseTable)ShowCreateUtilTest.createResolvedTable(TWO_COLUMNS_SCHEMA, options, Arrays.asList("key1", "key2"), TableDistribution.of((TableDistribution.Kind)TableDistribution.Kind.UNKNOWN, (Integer)3, Arrays.asList("1", "2", "3")), "table comment"), "CREATE %sTABLE `catalogName`.`dbName`.`tableName` (\n  `id` INT,\n  `name` VARCHAR(2147483647)\n)\nCOMMENT 'table comment'\nDISTRIBUTED BY (`1`, `2`, `3`) INTO 3 BUCKETS\nPARTITIONED BY (`key1`, `key2`)\nWITH (\n  'option_key_a' = 'option_value_a',\n  'option_key_b' = 'option_value_b',\n  'option_key_c' = 'option_value_c'\n)\n");
        return argList;
    }

    private static Collection<Arguments> argsForShowCreateMaterializedTable() {
        ArrayList<Arguments> argList = new ArrayList<Arguments>();
        ShowCreateUtilTest.addTemporaryAndPermanent(argList, (CatalogBaseTable)ShowCreateUtilTest.createResolvedMaterialized(ONE_COLUMN_SCHEMA, null, List.of(), null, IntervalFreshness.ofMinute((String)"1"), CatalogMaterializedTable.RefreshMode.CONTINUOUS, "SELECT 1"), "CREATE %sMATERIALIZED TABLE `catalogName`.`dbName`.`materializedTableName`\nFRESHNESS = INTERVAL '1' MINUTE\nREFRESH_MODE = CONTINUOUS\nAS SELECT 1\n");
        ShowCreateUtilTest.addTemporaryAndPermanent(argList, (CatalogBaseTable)ShowCreateUtilTest.createResolvedMaterialized(ONE_COLUMN_SCHEMA_WITH_PRIMARY_KEY, null, List.of(), null, IntervalFreshness.ofMinute((String)"1"), CatalogMaterializedTable.RefreshMode.CONTINUOUS, "SELECT 1"), "CREATE %sMATERIALIZED TABLE `catalogName`.`dbName`.`materializedTableName` (\n  CONSTRAINT `pk` PRIMARY KEY (`id`) NOT ENFORCED\n)\nFRESHNESS = INTERVAL '1' MINUTE\nREFRESH_MODE = CONTINUOUS\nAS SELECT 1\n");
        ShowCreateUtilTest.addTemporaryAndPermanent(argList, (CatalogBaseTable)ShowCreateUtilTest.createResolvedMaterialized(TWO_COLUMNS_SCHEMA, "Materialized table comment", List.of("id"), TableDistribution.of((TableDistribution.Kind)TableDistribution.Kind.HASH, (Integer)5, List.of("id")), IntervalFreshness.ofMinute((String)"3"), CatalogMaterializedTable.RefreshMode.FULL, "SELECT id, name FROM tbl_a"), "CREATE %sMATERIALIZED TABLE `catalogName`.`dbName`.`materializedTableName`\nCOMMENT 'Materialized table comment'\nDISTRIBUTED BY HASH(`id`) INTO 5 BUCKETS\nPARTITIONED BY (`id`)\nFRESHNESS = INTERVAL '3' MINUTE\nREFRESH_MODE = FULL\nAS SELECT id, name FROM tbl_a\n");
        return argList;
    }

    private static void addTemporaryAndPermanent(Collection<Arguments> argList, CatalogBaseTable catalogBaseTable, String sql) {
        argList.add(Arguments.of((Object[])new Object[]{catalogBaseTable, false, String.format(sql, "")}));
        argList.add(Arguments.of((Object[])new Object[]{catalogBaseTable, true, String.format(sql, "TEMPORARY ")}));
    }

    private static ResolvedCatalogTable createResolvedTable(ResolvedSchema resolvedSchema, Map<String, String> options, List<String> partitionKeys, TableDistribution tableDistribution, String comment) {
        CatalogTable.Builder tableBuilder = CatalogTable.newBuilder().schema(Schema.newBuilder().fromResolvedSchema(resolvedSchema).build()).options(options).comment(comment).partitionKeys(partitionKeys);
        if (tableDistribution != null) {
            tableBuilder.distribution(tableDistribution);
        }
        return new ResolvedCatalogTable(tableBuilder.build(), resolvedSchema);
    }

    private static ResolvedCatalogView createResolvedView(ResolvedSchema resolvedSchema, String originalQuery, String expandedQuery, String comment) {
        return new ResolvedCatalogView(CatalogView.of((Schema)Schema.newBuilder().fromResolvedSchema(resolvedSchema).build(), (String)comment, (String)originalQuery, (String)expandedQuery, Collections.emptyMap()), resolvedSchema);
    }

    private static ResolvedCatalogMaterializedTable createResolvedMaterialized(ResolvedSchema resolvedSchema, String comment, List<String> partitionBy, TableDistribution distribution, IntervalFreshness freshness, CatalogMaterializedTable.RefreshMode refreshMode, String definitionQuery) {
        return new ResolvedCatalogMaterializedTable(CatalogMaterializedTable.newBuilder().comment(comment).partitionKeys(partitionBy).distribution(distribution).schema(Schema.newBuilder().fromResolvedSchema(resolvedSchema).build()).freshness(freshness).refreshMode(refreshMode).definitionQuery(definitionQuery).logicalRefreshMode(CatalogMaterializedTable.LogicalRefreshMode.AUTOMATIC).refreshStatus(CatalogMaterializedTable.RefreshStatus.ACTIVATED).build(), resolvedSchema);
    }
}

