/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.partitioner;

import java.util.List;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.v2.DiscardingSink;
import org.apache.flink.streaming.api.graph.NonChainedOutput;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.runtime.partitioner.ForwardForUnspecifiedPartitioner;
import org.apache.flink.streaming.runtime.partitioner.ForwardPartitioner;
import org.apache.flink.streaming.runtime.partitioner.RescalePartitioner;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitionerTestUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ForwardForUnspecifiedPartitionerTest {
    ForwardForUnspecifiedPartitionerTest() {
    }

    @Test
    void testConvertToForwardPartitioner() {
        JobGraph jobGraph = StreamPartitionerTestUtils.createJobGraph("group1", "group1", (StreamPartitioner<Long>)new ForwardForUnspecifiedPartitioner());
        List jobVertices = jobGraph.getVerticesSortedTopologicallyFromSources();
        Assertions.assertThat((int)jobVertices.size()).isEqualTo(1);
        JobVertex vertex = (JobVertex)jobGraph.getVerticesSortedTopologicallyFromSources().get(0);
        StreamConfig sourceConfig = new StreamConfig(vertex.getConfiguration());
        StreamEdge edge = (StreamEdge)sourceConfig.getChainedOutputs(this.getClass().getClassLoader()).get(0);
        Assertions.assertThat((Object)edge.getPartitioner()).isInstanceOf(ForwardPartitioner.class);
    }

    @Test
    void testConvertToRescalePartitioner() {
        JobGraph jobGraph = StreamPartitionerTestUtils.createJobGraph("group1", "group2", (StreamPartitioner<Long>)new ForwardForUnspecifiedPartitioner());
        List jobVertices = jobGraph.getVerticesSortedTopologicallyFromSources();
        Assertions.assertThat((int)jobVertices.size()).isEqualTo(2);
        JobVertex sourceVertex = (JobVertex)jobGraph.getVerticesSortedTopologicallyFromSources().get(0);
        StreamConfig sourceConfig = new StreamConfig(sourceVertex.getConfiguration());
        NonChainedOutput output = (NonChainedOutput)sourceConfig.getOperatorNonChainedOutputs(this.getClass().getClassLoader()).get(0);
        Assertions.assertThat((Object)output.getPartitioner()).isInstanceOf(RescalePartitioner.class);
    }

    @Test
    void testConvertToCorrectPartitioner() {
        this.testConvertToCorrectPartitioner(null, RescalePartitioner.class);
        this.testConvertToCorrectPartitioner(JobManagerOptions.SchedulerType.AdaptiveBatch, RescalePartitioner.class);
        this.testConvertToCorrectPartitioner(JobManagerOptions.SchedulerType.Default, ForwardPartitioner.class);
    }

    private void testConvertToCorrectPartitioner(JobManagerOptions.SchedulerType scheduler, Class<?> expectedPartitioner) {
        Configuration configuration = new Configuration();
        if (scheduler != null) {
            configuration.set(JobManagerOptions.SCHEDULER, (Object)scheduler);
        }
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment((Configuration)configuration);
        env.setRuntimeMode(RuntimeExecutionMode.BATCH);
        env.fromSequence(0L, 99L).slotSharingGroup("group1").name("source").sinkTo((Sink)new DiscardingSink()).slotSharingGroup("group2").name("sink");
        List jobVertices = env.getStreamGraph().getJobGraph().getVerticesSortedTopologicallyFromSources();
        Assertions.assertThat((int)jobVertices.size()).isEqualTo(2);
        JobVertex sourceVertex = (JobVertex)jobVertices.get(0);
        StreamConfig sourceConfig = new StreamConfig(sourceVertex.getConfiguration());
        NonChainedOutput output = (NonChainedOutput)sourceConfig.getOperatorNonChainedOutputs(this.getClass().getClassLoader()).get(0);
        Assertions.assertThat((Object)output.getPartitioner()).isInstanceOf(expectedPartitioner);
    }
}

