/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.shaded.guava33.com.google.common.collect.Iterables;
import org.apache.flink.streaming.api.graph.JobGraphGeneratorTestBase;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.graph.StreamingJobGraphGenerator;

class StreamingJobGraphGeneratorTest
extends JobGraphGeneratorTestBase {
    StreamingJobGraphGeneratorTest() {
    }

    @Override
    JobGraph createJobGraph(StreamGraph streamGraph) {
        return StreamingJobGraphGenerator.createJobGraph((StreamGraph)streamGraph);
    }

    @Override
    void verifyManagedMemoryFractionForUnknownResourceSpec(JobVertex vertex1, JobVertex vertex2, JobVertex vertex3, Configuration taskManagerConfig) {
        StreamConfig sourceConfig = new StreamConfig(vertex1.getConfiguration());
        StreamingJobGraphGeneratorTest.verifyFractions(sourceConfig, 0.3, 0.0, 0.0, taskManagerConfig);
        StreamConfig map1Config = (StreamConfig)Iterables.getOnlyElement(sourceConfig.getTransitiveChainedTaskConfigs(JobGraphGeneratorTestBase.class.getClassLoader()).values());
        StreamingJobGraphGeneratorTest.verifyFractions(map1Config, 0.3, 0.4, 0.0, taskManagerConfig);
        StreamConfig map2Config = new StreamConfig(vertex2.getConfiguration());
        StreamingJobGraphGeneratorTest.verifyFractions(map2Config, 0.0, 0.4, 0.0, taskManagerConfig);
        StreamConfig map3Config = new StreamConfig(vertex3.getConfiguration());
        StreamingJobGraphGeneratorTest.verifyFractions(map3Config, 1.0, 0.0, 0.0, taskManagerConfig);
    }
}

