/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.rocksdb.iterator;

import java.io.IOException;
import java.util.Iterator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.CompositeKeySerializationUtils;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.heap.HeapPriorityQueueStateSnapshot;
import org.apache.flink.state.rocksdb.iterator.SingleStateIterator;
import org.apache.flink.util.FlinkRuntimeException;

public final class RocksQueueIterator
implements SingleStateIterator {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final DataOutputSerializer keyOut = new DataOutputSerializer(128);
    private final HeapPriorityQueueStateSnapshot<?> queueSnapshot;
    private final Iterator<Integer> keyGroupRangeIterator;
    private final int kvStateId;
    private final int keyGroupPrefixBytes;
    private final TypeSerializer<Object> elementSerializer;
    private Iterator<Object> elementsForKeyGroup;
    private int afterKeyMark = 0;
    private boolean isValid;
    private byte[] currentKey;

    public RocksQueueIterator(HeapPriorityQueueStateSnapshot<?> queuesSnapshot, KeyGroupRange keyGroupRange, int keyGroupPrefixBytes, int kvStateId) {
        this.queueSnapshot = queuesSnapshot;
        this.elementSerializer = RocksQueueIterator.castToType(queuesSnapshot.getMetaInfo().getElementSerializer());
        this.keyGroupRangeIterator = keyGroupRange.iterator();
        this.keyGroupPrefixBytes = keyGroupPrefixBytes;
        this.kvStateId = kvStateId;
        if (this.keyGroupRangeIterator.hasNext()) {
            try {
                if (this.moveToNextNonEmptyKeyGroup()) {
                    this.isValid = true;
                    this.next();
                } else {
                    this.isValid = false;
                }
            }
            catch (IOException e) {
                throw new FlinkRuntimeException((Throwable)e);
            }
        }
    }

    @Override
    public void next() {
        try {
            boolean hasElement;
            if (!this.elementsForKeyGroup.hasNext() && !(hasElement = this.moveToNextNonEmptyKeyGroup())) {
                this.isValid = false;
                return;
            }
            this.keyOut.setPosition(this.afterKeyMark);
            this.elementSerializer.serialize(this.elementsForKeyGroup.next(), (DataOutputView)this.keyOut);
            this.currentKey = this.keyOut.getCopyOfBuffer();
        }
        catch (IOException e) {
            throw new FlinkRuntimeException((Throwable)e);
        }
    }

    private boolean moveToNextNonEmptyKeyGroup() throws IOException {
        while (this.keyGroupRangeIterator.hasNext()) {
            Integer keyGroupId = this.keyGroupRangeIterator.next();
            this.elementsForKeyGroup = RocksQueueIterator.castToType(this.queueSnapshot.getIteratorForKeyGroup(keyGroupId.intValue()));
            if (!this.elementsForKeyGroup.hasNext()) continue;
            this.writeKeyGroupId(keyGroupId);
            return true;
        }
        return false;
    }

    private void writeKeyGroupId(Integer keyGroupId) throws IOException {
        this.keyOut.clear();
        CompositeKeySerializationUtils.writeKeyGroup((int)keyGroupId, (int)this.keyGroupPrefixBytes, (DataOutputView)this.keyOut);
        this.afterKeyMark = this.keyOut.length();
    }

    private static <T> TypeSerializer<T> castToType(TypeSerializer<?> typeSerializer) {
        return typeSerializer;
    }

    private static <T> Iterator<T> castToType(Iterator<?> iterator) {
        return iterator;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public byte[] key() {
        return this.currentKey;
    }

    @Override
    public byte[] value() {
        return EMPTY_BYTE_ARRAY;
    }

    @Override
    public int getKvStateId() {
        return this.kvStateId;
    }

    @Override
    public void close() {
    }
}

