/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.rocksdb.iterator;

import javax.annotation.Nonnull;
import org.apache.flink.runtime.state.StateSnapshotTransformer;
import org.apache.flink.state.rocksdb.RocksIteratorWrapper;
import org.rocksdb.RocksIterator;

public class RocksTransformingIteratorWrapper
extends RocksIteratorWrapper {
    @Nonnull
    private final StateSnapshotTransformer<byte[]> stateSnapshotTransformer;
    private byte[] current;

    public RocksTransformingIteratorWrapper(@Nonnull RocksIterator iterator, @Nonnull StateSnapshotTransformer<byte[]> stateSnapshotTransformer) {
        super(iterator);
        this.stateSnapshotTransformer = stateSnapshotTransformer;
    }

    @Override
    public void seekToFirst() {
        super.seekToFirst();
        this.filterOrTransform(() -> super.next());
    }

    @Override
    public void seekToLast() {
        super.seekToLast();
        this.filterOrTransform(() -> super.prev());
    }

    @Override
    public void next() {
        super.next();
        this.filterOrTransform(() -> super.next());
    }

    @Override
    public void prev() {
        super.prev();
        this.filterOrTransform(() -> super.prev());
    }

    private void filterOrTransform(@Nonnull Runnable advance) {
        while (this.isValid() && (this.current = (byte[])this.stateSnapshotTransformer.filterOrTransform((Object)super.value())) == null) {
            advance.run();
        }
    }

    @Override
    public byte[] value() {
        if (!this.isValid()) {
            throw new IllegalStateException("value() method cannot be called if isValid() is false");
        }
        return this.current;
    }
}

