/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.rocksdb;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.RandomUtils;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.operators.testutils.MockEnvironment;
import org.apache.flink.runtime.operators.testutils.MockEnvironmentBuilder;
import org.apache.flink.runtime.query.KvStateRegistry;
import org.apache.flink.runtime.query.TaskKvStateRegistry;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateBackendParametersImpl;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.heap.HeapPriorityQueueSetFactory;
import org.apache.flink.runtime.state.ttl.TtlTimeProvider;
import org.apache.flink.runtime.taskmanager.TaskManagerRuntimeInfo;
import org.apache.flink.runtime.util.TestingTaskManagerRuntimeInfo;
import org.apache.flink.state.rocksdb.ConfigurableRocksDBOptionsFactory;
import org.apache.flink.state.rocksdb.EmbeddedRocksDBStateBackend;
import org.apache.flink.state.rocksdb.PredefinedOptions;
import org.apache.flink.state.rocksdb.RocksDBConfigurableOptions;
import org.apache.flink.state.rocksdb.RocksDBKeyedStateBackend;
import org.apache.flink.state.rocksdb.RocksDBKeyedStateBackendBuilder;
import org.apache.flink.state.rocksdb.RocksDBMemoryConfiguration;
import org.apache.flink.state.rocksdb.RocksDBOptions;
import org.apache.flink.state.rocksdb.RocksDBOptionsFactory;
import org.apache.flink.state.rocksdb.RocksDBPriorityQueueSetFactory;
import org.apache.flink.state.rocksdb.RocksDBResourceContainer;
import org.apache.flink.state.rocksdb.RocksDBTestUtils;
import org.apache.flink.testutils.junit.FailsInGHAContainerWithRootUser;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.jupiter.api.Timeout;
import org.junit.rules.TemporaryFolder;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompactionStyle;
import org.rocksdb.CompressionType;
import org.rocksdb.DBOptions;
import org.rocksdb.FlushOptions;
import org.rocksdb.InfoLogLevel;

public class RocksDBStateBackendConfigTest {
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();

    @Test
    public void testDefaultsInSync() throws Exception {
        boolean defaultIncremental = (Boolean)CheckpointingOptions.INCREMENTAL_CHECKPOINTS.defaultValue();
        EmbeddedRocksDBStateBackend backend = new EmbeddedRocksDBStateBackend();
        Assert.assertEquals((Object)defaultIncremental, (Object)backend.isIncrementalCheckpointsEnabled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDefaultDbLogDir() throws Exception {
        EmbeddedRocksDBStateBackend backend = new EmbeddedRocksDBStateBackend();
        File logFile = File.createTempFile(this.getClass().getSimpleName() + "-", ".log");
        System.setProperty("log.file", logFile.getPath());
        try (RocksDBResourceContainer container = backend.createOptionsAndResourceContainer(null);){
            Assert.assertEquals((Object)RocksDBConfigurableOptions.LOG_LEVEL.defaultValue(), (Object)container.getDbOptions().infoLogLevel());
            Assert.assertEquals((Object)logFile.getParent(), (Object)container.getDbOptions().dbLogDir());
        }
        finally {
            logFile.delete();
        }
        StringBuilder longInstanceBasePath = new StringBuilder(this.tempFolder.newFolder().getAbsolutePath());
        while (longInstanceBasePath.length() < 255) {
            longInstanceBasePath.append("/append-for-long-path");
        }
        try (RocksDBResourceContainer container = backend.createOptionsAndResourceContainer(new File(longInstanceBasePath.toString()));){
            Assert.assertTrue((boolean)container.getDbOptions().dbLogDir().isEmpty());
        }
        finally {
            logFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetDbPath() throws Exception {
        EmbeddedRocksDBStateBackend rocksDbBackend = new EmbeddedRocksDBStateBackend();
        String testDir1 = this.tempFolder.newFolder().getAbsolutePath();
        String testDir2 = this.tempFolder.newFolder().getAbsolutePath();
        Assert.assertNull((Object)rocksDbBackend.getDbStoragePaths());
        rocksDbBackend.setDbStoragePath(testDir1);
        Assert.assertArrayEquals((Object[])new String[]{testDir1}, (Object[])rocksDbBackend.getDbStoragePaths());
        rocksDbBackend.setDbStoragePath(null);
        Assert.assertNull((Object)rocksDbBackend.getDbStoragePaths());
        rocksDbBackend.setDbStoragePaths(new String[]{testDir1, testDir2});
        Assert.assertArrayEquals((Object[])new String[]{testDir1, testDir2}, (Object[])rocksDbBackend.getDbStoragePaths());
        MockEnvironment env = RocksDBStateBackendConfigTest.getMockEnvironment(this.tempFolder.newFolder());
        RocksDBKeyedStateBackend keyedBackend = RocksDBTestUtils.createKeyedStateBackend(rocksDbBackend, (Environment)env, IntSerializer.INSTANCE);
        try {
            File instanceBasePath = keyedBackend.getInstanceBasePath();
            MatcherAssert.assertThat((Object)instanceBasePath.getAbsolutePath(), (Matcher)CoreMatchers.anyOf((Matcher)Matchers.startsWith((String)testDir1), (Matcher)Matchers.startsWith((String)testDir2)));
            rocksDbBackend.setDbStoragePaths(null);
            Assert.assertNull((Object)rocksDbBackend.getDbStoragePaths());
        }
        finally {
            IOUtils.closeQuietly(keyedBackend);
            keyedBackend.dispose();
            env.close();
        }
    }

    @Test
    public void testConfigureTimerService() throws Exception {
        MockEnvironment env = RocksDBStateBackendConfigTest.getMockEnvironment(this.tempFolder.newFolder());
        Assert.assertEquals((Object)"state.backend.rocksdb.timer-service.factory", (Object)RocksDBOptions.TIMER_SERVICE_FACTORY.key());
        Assert.assertEquals((long)2L, (long)EmbeddedRocksDBStateBackend.PriorityQueueStateType.values().length);
        Assert.assertEquals((Object)"ROCKSDB", (Object)EmbeddedRocksDBStateBackend.PriorityQueueStateType.ROCKSDB.toString());
        Assert.assertEquals((Object)"HEAP", (Object)EmbeddedRocksDBStateBackend.PriorityQueueStateType.HEAP.toString());
        Assert.assertEquals((Object)EmbeddedRocksDBStateBackend.PriorityQueueStateType.ROCKSDB, (Object)RocksDBOptions.TIMER_SERVICE_FACTORY.defaultValue());
        EmbeddedRocksDBStateBackend rocksDbBackend = new EmbeddedRocksDBStateBackend();
        RocksDBKeyedStateBackend keyedBackend = RocksDBTestUtils.createKeyedStateBackend(rocksDbBackend, (Environment)env, IntSerializer.INSTANCE);
        Assert.assertEquals(RocksDBPriorityQueueSetFactory.class, keyedBackend.getPriorityQueueFactory().getClass());
        keyedBackend.dispose();
        Configuration conf = new Configuration();
        conf.set(RocksDBOptions.TIMER_SERVICE_FACTORY, (Object)EmbeddedRocksDBStateBackend.PriorityQueueStateType.HEAP);
        rocksDbBackend = rocksDbBackend.configure((ReadableConfig)conf, Thread.currentThread().getContextClassLoader());
        keyedBackend = RocksDBTestUtils.createKeyedStateBackend(rocksDbBackend, (Environment)env, IntSerializer.INSTANCE);
        Assert.assertEquals(HeapPriorityQueueSetFactory.class, keyedBackend.getPriorityQueueFactory().getClass());
        keyedBackend.dispose();
        env.close();
    }

    @Test
    public void testConfigureRocksDBPriorityQueueFactoryCacheSize() throws Exception {
        MockEnvironment env = RocksDBStateBackendConfigTest.getMockEnvironment(this.tempFolder.newFolder());
        EmbeddedRocksDBStateBackend rocksDbBackend = new EmbeddedRocksDBStateBackend();
        int cacheSize = 512;
        Configuration conf = new Configuration();
        conf.set(RocksDBOptions.TIMER_SERVICE_FACTORY, (Object)EmbeddedRocksDBStateBackend.PriorityQueueStateType.ROCKSDB);
        conf.set(RocksDBOptions.ROCKSDB_TIMER_SERVICE_FACTORY_CACHE_SIZE, (Object)cacheSize);
        rocksDbBackend = rocksDbBackend.configure((ReadableConfig)conf, Thread.currentThread().getContextClassLoader());
        RocksDBKeyedStateBackend keyedBackend = RocksDBTestUtils.createKeyedStateBackend(rocksDbBackend, (Environment)env, IntSerializer.INSTANCE);
        Assert.assertEquals(RocksDBPriorityQueueSetFactory.class, keyedBackend.getPriorityQueueFactory().getClass());
        Assert.assertEquals((long)cacheSize, (long)((RocksDBPriorityQueueSetFactory)keyedBackend.getPriorityQueueFactory()).getCacheSize());
        keyedBackend.dispose();
        env.close();
    }

    @Test
    public void testConfigureTimerServiceLoadingFromApplication() throws Exception {
        MockEnvironment env = new MockEnvironmentBuilder().build();
        EmbeddedRocksDBStateBackend backend = new EmbeddedRocksDBStateBackend();
        backend.setPriorityQueueStateType(EmbeddedRocksDBStateBackend.PriorityQueueStateType.HEAP);
        Configuration configFromConfFile = new Configuration();
        configFromConfFile.setString(RocksDBOptions.TIMER_SERVICE_FACTORY.key(), EmbeddedRocksDBStateBackend.PriorityQueueStateType.ROCKSDB.toString());
        EmbeddedRocksDBStateBackend configuredRocksDBStateBackend = backend.configure((ReadableConfig)configFromConfFile, Thread.currentThread().getContextClassLoader());
        RocksDBKeyedStateBackend keyedBackend = RocksDBTestUtils.createKeyedStateBackend(configuredRocksDBStateBackend, (Environment)env, IntSerializer.INSTANCE);
        MatcherAssert.assertThat((Object)keyedBackend.getPriorityQueueFactory(), (Matcher)CoreMatchers.instanceOf(HeapPriorityQueueSetFactory.class));
        keyedBackend.close();
        keyedBackend.dispose();
        env.close();
    }

    @Test
    public void testConfigureRocksDBCompressionPerLevel() throws Exception {
        MockEnvironment env = RocksDBStateBackendConfigTest.getMockEnvironment(this.tempFolder.newFolder());
        EmbeddedRocksDBStateBackend rocksDbBackend = new EmbeddedRocksDBStateBackend();
        Object[] compressionTypes = new CompressionType[]{CompressionType.NO_COMPRESSION, CompressionType.SNAPPY_COMPRESSION};
        Configuration conf = new Configuration();
        conf.set(RocksDBConfigurableOptions.COMPRESSION_PER_LEVEL, new ArrayList<CompressionType>(Arrays.asList(compressionTypes)));
        rocksDbBackend = rocksDbBackend.configure((ReadableConfig)conf, Thread.currentThread().getContextClassLoader());
        RocksDBResourceContainer resourceContainer = rocksDbBackend.createOptionsAndResourceContainer(this.tempFolder.newFile());
        ColumnFamilyOptions columnFamilyOptions = resourceContainer.getColumnOptions();
        Assert.assertArrayEquals((Object[])compressionTypes, (Object[])columnFamilyOptions.compressionPerLevel().toArray());
        resourceContainer.close();
        env.close();
    }

    @Test
    public void testStoragePathWithFilePrefix() throws Exception {
        File folder = this.tempFolder.newFolder();
        String dbStoragePath = new Path(folder.toURI().toString()).toString();
        Assert.assertTrue((boolean)dbStoragePath.startsWith("file:"));
        this.testLocalDbPaths(dbStoragePath, folder);
    }

    @Test
    public void testWithDefaultFsSchemeNoStoragePath() throws Exception {
        try {
            Configuration config = new Configuration();
            config.set(CoreOptions.DEFAULT_FILESYSTEM_SCHEME, (Object)"s3://mydomain.com:8020/flink");
            FileSystem.initialize((Configuration)config);
            this.testLocalDbPaths(null, this.tempFolder.getRoot());
        }
        finally {
            FileSystem.initialize((Configuration)new Configuration());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithDefaultFsSchemeAbsoluteStoragePath() throws Exception {
        File folder = this.tempFolder.newFolder();
        String dbStoragePath = folder.getAbsolutePath();
        try {
            Configuration config = new Configuration();
            config.set(CoreOptions.DEFAULT_FILESYSTEM_SCHEME, (Object)"s3://mydomain.com:8020/flink");
            FileSystem.initialize((Configuration)config);
            this.testLocalDbPaths(dbStoragePath, folder);
        }
        finally {
            FileSystem.initialize((Configuration)new Configuration());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testLocalDbPaths(String configuredPath, File expectedPath) throws Exception {
        EmbeddedRocksDBStateBackend rocksDbBackend = new EmbeddedRocksDBStateBackend();
        rocksDbBackend.setDbStoragePath(configuredPath);
        MockEnvironment env = RocksDBStateBackendConfigTest.getMockEnvironment(this.tempFolder.newFolder());
        RocksDBKeyedStateBackend keyedBackend = RocksDBTestUtils.createKeyedStateBackend(rocksDbBackend, (Environment)env, IntSerializer.INSTANCE);
        try {
            File instanceBasePath = keyedBackend.getInstanceBasePath();
            MatcherAssert.assertThat((Object)instanceBasePath.getAbsolutePath(), (Matcher)Matchers.startsWith((String)expectedPath.getAbsolutePath()));
            rocksDbBackend.setDbStoragePaths(null);
            Assert.assertNull((Object)rocksDbBackend.getDbStoragePaths());
        }
        finally {
            IOUtils.closeQuietly(keyedBackend);
            keyedBackend.dispose();
            env.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testCleanRelocatedDbLogs() throws Exception {
        java.nio.file.Path[] relocatedDbLogs;
        File folder = this.tempFolder.newFolder();
        File relocatedDBLogDir = this.tempFolder.newFolder("db_logs");
        File logFile = new File(relocatedDBLogDir, "taskManager.log");
        Files.createFile(logFile.toPath(), new FileAttribute[0]);
        System.setProperty("log.file", logFile.getAbsolutePath());
        Configuration conf = new Configuration();
        conf.set(RocksDBConfigurableOptions.LOG_LEVEL, (Object)InfoLogLevel.DEBUG_LEVEL);
        conf.set(RocksDBConfigurableOptions.LOG_FILE_NUM, (Object)4);
        conf.set(RocksDBConfigurableOptions.LOG_MAX_FILE_SIZE, (Object)MemorySize.parse((String)"1kb"));
        EmbeddedRocksDBStateBackend rocksDbBackend = new EmbeddedRocksDBStateBackend().configure((ReadableConfig)conf, this.getClass().getClassLoader());
        String dbStoragePath = new Path(folder.toURI().toString()).toString();
        rocksDbBackend.setDbStoragePath(dbStoragePath);
        MockEnvironment env = RocksDBStateBackendConfigTest.getMockEnvironment(this.tempFolder.newFolder());
        RocksDBKeyedStateBackend keyedBackend = RocksDBTestUtils.createKeyedStateBackend(rocksDbBackend, (Environment)env, IntSerializer.INSTANCE);
        File instanceBasePath = keyedBackend.getInstanceBasePath();
        File instanceRocksDBPath = RocksDBKeyedStateBackendBuilder.getInstanceRocksDBPath((File)instanceBasePath);
        Assume.assumeTrue((instanceRocksDBPath.getAbsolutePath().length() <= 255 - "_LOG".length() ? 1 : 0) != 0);
        try {
            relocatedDbLogs = FileUtils.listDirectory((java.nio.file.Path)relocatedDBLogDir.toPath());
            while (relocatedDbLogs.length <= 2) {
                try (FlushOptions flushOptions = new FlushOptions();){
                    keyedBackend.db.put(RandomUtils.nextBytes((int)32), RandomUtils.nextBytes((int)512));
                    keyedBackend.db.flush(flushOptions);
                }
                relocatedDbLogs = FileUtils.listDirectory((java.nio.file.Path)relocatedDBLogDir.toPath());
            }
        }
        finally {
            IOUtils.closeQuietly(keyedBackend);
            keyedBackend.dispose();
            env.close();
        }
        relocatedDbLogs = FileUtils.listDirectory((java.nio.file.Path)relocatedDBLogDir.toPath());
        Assert.assertEquals((long)1L, (long)relocatedDbLogs.length);
        Assert.assertEquals((Object)"taskManager.log", (Object)relocatedDbLogs[0].toFile().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUseTempDirectories() throws Exception {
        EmbeddedRocksDBStateBackend rocksDbBackend = new EmbeddedRocksDBStateBackend();
        File dir1 = this.tempFolder.newFolder();
        Assert.assertNull((Object)rocksDbBackend.getDbStoragePaths());
        MockEnvironment env = RocksDBStateBackendConfigTest.getMockEnvironment(dir1);
        JobID jobID = env.getJobID();
        KeyGroupRange keyGroupRange = new KeyGroupRange(0, 0);
        TaskKvStateRegistry kvStateRegistry = env.getTaskKvStateRegistry();
        CloseableRegistry cancelStreamRegistry = new CloseableRegistry();
        RocksDBKeyedStateBackend keyedBackend = (RocksDBKeyedStateBackend)rocksDbBackend.createKeyedStateBackend((StateBackend.KeyedStateBackendParameters)new KeyedStateBackendParametersImpl((Environment)env, jobID, "test_op", (TypeSerializer)IntSerializer.INSTANCE, 1, keyGroupRange, kvStateRegistry, TtlTimeProvider.DEFAULT, (MetricGroup)new UnregisteredMetricsGroup(), Collections.emptyList(), cancelStreamRegistry));
        try {
            File instanceBasePath = keyedBackend.getInstanceBasePath();
            MatcherAssert.assertThat((Object)instanceBasePath.getAbsolutePath(), (Matcher)Matchers.startsWith((String)dir1.getAbsolutePath()));
        }
        finally {
            IOUtils.closeQuietly((AutoCloseable)keyedBackend);
            keyedBackend.dispose();
            env.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Category(value={FailsInGHAContainerWithRootUser.class})
    public void testFailWhenNoLocalStorageDir() throws Exception {
        File targetDir = this.tempFolder.newFolder();
        Assume.assumeTrue((String)"Cannot mark directory non-writable", (boolean)targetDir.setWritable(false, false));
        String checkpointPath = this.tempFolder.newFolder().toURI().toString();
        EmbeddedRocksDBStateBackend rocksDbBackend = new EmbeddedRocksDBStateBackend();
        try (MockEnvironment env = RocksDBStateBackendConfigTest.getMockEnvironment(this.tempFolder.newFolder());){
            rocksDbBackend.setDbStoragePath(targetDir.getAbsolutePath());
            boolean hasFailure = false;
            try {
                JobID jobID = env.getJobID();
                KeyGroupRange keyGroupRange = new KeyGroupRange(0, 0);
                TaskKvStateRegistry kvStateRegistry = new KvStateRegistry().createTaskRegistry(env.getJobID(), new JobVertexID());
                CloseableRegistry cancelStreamRegistry = new CloseableRegistry();
                rocksDbBackend.createKeyedStateBackend((StateBackend.KeyedStateBackendParameters)new KeyedStateBackendParametersImpl((Environment)env, jobID, "foobar", (TypeSerializer)IntSerializer.INSTANCE, 1, keyGroupRange, kvStateRegistry, TtlTimeProvider.DEFAULT, (MetricGroup)new UnregisteredMetricsGroup(), Collections.emptyList(), cancelStreamRegistry));
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)e.getMessage().contains("No local storage directories available"));
                Assert.assertTrue((boolean)e.getMessage().contains(targetDir.getAbsolutePath()));
                hasFailure = true;
            }
            Assert.assertTrue((String)"We must see a failure because no storaged directory is feasible.", (boolean)hasFailure);
        }
        finally {
            targetDir.setWritable(true, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContinueOnSomeDbDirectoriesMissing() throws Exception {
        File targetDir1 = this.tempFolder.newFolder();
        File targetDir2 = this.tempFolder.newFolder();
        Assume.assumeTrue((String)"Cannot mark directory non-writable", (boolean)targetDir1.setWritable(false, false));
        String checkpointPath = this.tempFolder.newFolder().toURI().toString();
        EmbeddedRocksDBStateBackend rocksDbBackend = new EmbeddedRocksDBStateBackend();
        try (MockEnvironment env = RocksDBStateBackendConfigTest.getMockEnvironment(this.tempFolder.newFolder());){
            rocksDbBackend.setDbStoragePaths(new String[]{targetDir1.getAbsolutePath(), targetDir2.getAbsolutePath()});
            try {
                JobID jobID = env.getJobID();
                KeyGroupRange keyGroupRange = new KeyGroupRange(0, 0);
                TaskKvStateRegistry kvStateRegistry = new KvStateRegistry().createTaskRegistry(env.getJobID(), new JobVertexID());
                CloseableRegistry cancelStreamRegistry = new CloseableRegistry();
                AbstractKeyedStateBackend keyedStateBackend = rocksDbBackend.createKeyedStateBackend((StateBackend.KeyedStateBackendParameters)new KeyedStateBackendParametersImpl((Environment)env, jobID, "foobar", (TypeSerializer)IntSerializer.INSTANCE, 1, keyGroupRange, kvStateRegistry, TtlTimeProvider.DEFAULT, (MetricGroup)new UnregisteredMetricsGroup(), Collections.emptyList(), cancelStreamRegistry));
                IOUtils.closeQuietly((AutoCloseable)keyedStateBackend);
                keyedStateBackend.dispose();
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"Backend initialization failed even though some paths were available");
            }
        }
        finally {
            targetDir1.setWritable(true, false);
        }
    }

    @Test
    public void testPredefinedOptions() throws Exception {
        String checkpointPath = this.tempFolder.newFolder().toURI().toString();
        EmbeddedRocksDBStateBackend rocksDbBackend = new EmbeddedRocksDBStateBackend();
        Assert.assertEquals((Object)PredefinedOptions.DEFAULT, (Object)rocksDbBackend.getPredefinedOptions());
        Configuration configuration = new Configuration();
        configuration.set(RocksDBOptions.PREDEFINED_OPTIONS, (Object)PredefinedOptions.FLASH_SSD_OPTIMIZED.name());
        rocksDbBackend = new EmbeddedRocksDBStateBackend();
        rocksDbBackend = rocksDbBackend.configure((ReadableConfig)configuration, this.getClass().getClassLoader());
        Assert.assertEquals((Object)PredefinedOptions.FLASH_SSD_OPTIMIZED, (Object)rocksDbBackend.getPredefinedOptions());
        rocksDbBackend.setPredefinedOptions(PredefinedOptions.SPINNING_DISK_OPTIMIZED);
        Assert.assertEquals((Object)PredefinedOptions.SPINNING_DISK_OPTIMIZED, (Object)rocksDbBackend.getPredefinedOptions());
    }

    @Test
    public void testConfigurableOptionsFromConfig() throws Exception {
        Configuration configuration = new Configuration();
        this.verifyIllegalArgument(RocksDBConfigurableOptions.MAX_BACKGROUND_THREADS, "-1");
        this.verifyIllegalArgument(RocksDBConfigurableOptions.LOG_LEVEL, "DEBUG");
        this.verifyIllegalArgument(RocksDBConfigurableOptions.LOG_DIR, "tmp/rocksdb-logs/");
        this.verifyIllegalArgument(RocksDBConfigurableOptions.LOG_DIR, "");
        this.verifyIllegalArgument(RocksDBConfigurableOptions.LOG_FILE_NUM, "0");
        this.verifyIllegalArgument(RocksDBConfigurableOptions.LOG_FILE_NUM, "-1");
        this.verifyIllegalArgument(RocksDBConfigurableOptions.LOG_MAX_FILE_SIZE, "-1KB");
        this.verifyIllegalArgument(RocksDBConfigurableOptions.MAX_WRITE_BUFFER_NUMBER, "-1");
        this.verifyIllegalArgument(RocksDBConfigurableOptions.MIN_WRITE_BUFFER_NUMBER_TO_MERGE, "-1");
        this.verifyIllegalArgument(RocksDBConfigurableOptions.TARGET_FILE_SIZE_BASE, "0KB");
        this.verifyIllegalArgument(RocksDBConfigurableOptions.MAX_SIZE_LEVEL_BASE, "1BB");
        this.verifyIllegalArgument(RocksDBConfigurableOptions.WRITE_BUFFER_SIZE, "-1KB");
        this.verifyIllegalArgument(RocksDBConfigurableOptions.BLOCK_SIZE, "0MB");
        this.verifyIllegalArgument(RocksDBConfigurableOptions.METADATA_BLOCK_SIZE, "0MB");
        this.verifyIllegalArgument(RocksDBConfigurableOptions.BLOCK_CACHE_SIZE, "0");
        this.verifyIllegalArgument(RocksDBConfigurableOptions.USE_DYNAMIC_LEVEL_SIZE, "1");
        this.verifyIllegalArgument(RocksDBConfigurableOptions.COMPACTION_STYLE, "LEV");
        this.verifyIllegalArgument(RocksDBConfigurableOptions.COMPRESSION_PER_LEVEL, "SNAP");
        this.verifyIllegalArgument(RocksDBConfigurableOptions.USE_BLOOM_FILTER, "NO");
        this.verifyIllegalArgument(RocksDBConfigurableOptions.BLOOM_FILTER_BLOCK_BASED_MODE, "YES");
        this.verifyIllegalArgument(RocksDBConfigurableOptions.RESTORE_OVERLAP_FRACTION_THRESHOLD, "2");
        this.verifyIllegalArgument(RocksDBConfigurableOptions.COMPACT_FILTER_PERIODIC_COMPACTION_TIME, "-1s");
        this.verifyIllegalArgument(RocksDBConfigurableOptions.COMPACT_FILTER_QUERY_TIME_AFTER_NUM_ENTRIES, "1.1");
        configuration.setString(RocksDBConfigurableOptions.LOG_LEVEL.key(), "DEBUG_LEVEL");
        configuration.setString(RocksDBConfigurableOptions.LOG_DIR.key(), "/tmp/rocksdb-logs/");
        configuration.setString(RocksDBConfigurableOptions.LOG_FILE_NUM.key(), "10");
        configuration.setString(RocksDBConfigurableOptions.LOG_MAX_FILE_SIZE.key(), "2MB");
        configuration.setString(RocksDBConfigurableOptions.COMPACTION_STYLE.key(), "level");
        configuration.setString(RocksDBConfigurableOptions.COMPRESSION_PER_LEVEL.key(), "no_compression;snappy_compression;lz4_compression");
        configuration.setString(RocksDBConfigurableOptions.USE_DYNAMIC_LEVEL_SIZE.key(), "TRUE");
        configuration.setString(RocksDBConfigurableOptions.TARGET_FILE_SIZE_BASE.key(), "8 mb");
        configuration.setString(RocksDBConfigurableOptions.MAX_SIZE_LEVEL_BASE.key(), "128MB");
        configuration.setString(RocksDBConfigurableOptions.MAX_BACKGROUND_THREADS.key(), "4");
        configuration.setString(RocksDBConfigurableOptions.MAX_WRITE_BUFFER_NUMBER.key(), "4");
        configuration.setString(RocksDBConfigurableOptions.MIN_WRITE_BUFFER_NUMBER_TO_MERGE.key(), "2");
        configuration.setString(RocksDBConfigurableOptions.WRITE_BUFFER_SIZE.key(), "64 MB");
        configuration.setString(RocksDBConfigurableOptions.BLOCK_SIZE.key(), "4 kb");
        configuration.setString(RocksDBConfigurableOptions.METADATA_BLOCK_SIZE.key(), "8 kb");
        configuration.setString(RocksDBConfigurableOptions.BLOCK_CACHE_SIZE.key(), "512 mb");
        configuration.setString(RocksDBConfigurableOptions.USE_BLOOM_FILTER.key(), "TRUE");
        configuration.setString(RocksDBConfigurableOptions.RESTORE_OVERLAP_FRACTION_THRESHOLD.key(), "0.5");
        configuration.setString(RocksDBConfigurableOptions.COMPACT_FILTER_PERIODIC_COMPACTION_TIME.key(), "1h");
        try (RocksDBResourceContainer optionsContainer = new RocksDBResourceContainer((ReadableConfig)configuration, PredefinedOptions.DEFAULT, null, null, null, false);){
            DBOptions dbOptions = optionsContainer.getDbOptions();
            Assert.assertEquals((long)-1L, (long)dbOptions.maxOpenFiles());
            Assert.assertEquals((Object)InfoLogLevel.DEBUG_LEVEL, (Object)dbOptions.infoLogLevel());
            Assert.assertEquals((Object)"/tmp/rocksdb-logs/", (Object)dbOptions.dbLogDir());
            Assert.assertEquals((long)10L, (long)dbOptions.keepLogFileNum());
            Assert.assertEquals((long)0x200000L, (long)dbOptions.maxLogFileSize());
            ColumnFamilyOptions columnOptions = optionsContainer.getColumnOptions();
            Assert.assertEquals((Object)CompactionStyle.LEVEL, (Object)columnOptions.compactionStyle());
            Assert.assertTrue((boolean)columnOptions.levelCompactionDynamicLevelBytes());
            Assert.assertEquals((long)0x800000L, (long)columnOptions.targetFileSizeBase());
            Assert.assertEquals((long)0x8000000L, (long)columnOptions.maxBytesForLevelBase());
            Assert.assertEquals((long)4L, (long)columnOptions.maxWriteBufferNumber());
            Assert.assertEquals((long)2L, (long)columnOptions.minWriteBufferNumberToMerge());
            Assert.assertEquals((long)0x4000000L, (long)columnOptions.writeBufferSize());
            Assert.assertEquals(Arrays.asList(CompressionType.NO_COMPRESSION, CompressionType.SNAPPY_COMPRESSION, CompressionType.LZ4_COMPRESSION), (Object)columnOptions.compressionPerLevel());
            Assert.assertEquals((long)3600L, (long)columnOptions.periodicCompactionSeconds());
            BlockBasedTableConfig tableConfig = (BlockBasedTableConfig)columnOptions.tableFormatConfig();
            Assert.assertEquals((long)4096L, (long)tableConfig.blockSize());
            Assert.assertEquals((long)8192L, (long)tableConfig.metadataBlockSize());
            Assert.assertEquals((long)0x20000000L, (long)tableConfig.blockCacheSize());
            Assert.assertTrue((boolean)(tableConfig.filterPolicy() instanceof BloomFilter));
        }
    }

    @Test
    public void testOptionsFactory() throws Exception {
        String checkpointPath = this.tempFolder.newFolder().toURI().toString();
        EmbeddedRocksDBStateBackend rocksDbBackend = new EmbeddedRocksDBStateBackend();
        Configuration config = new Configuration();
        config.setString(RocksDBOptions.OPTIONS_FACTORY.key(), TestOptionsFactory.class.getName());
        config.setString(TestOptionsFactory.BACKGROUND_JOBS_OPTION.key(), "4");
        rocksDbBackend = rocksDbBackend.configure((ReadableConfig)config, this.getClass().getClassLoader());
        Assert.assertTrue((boolean)(rocksDbBackend.getRocksDBOptions() instanceof TestOptionsFactory));
        try (RocksDBResourceContainer optionsContainer = rocksDbBackend.createOptionsAndResourceContainer(null);){
            DBOptions dbOptions = optionsContainer.getDbOptions();
            Assert.assertEquals((long)4L, (long)dbOptions.maxBackgroundJobs());
        }
        rocksDbBackend.setRocksDBOptions(new RocksDBOptionsFactory(){

            public DBOptions createDBOptions(DBOptions currentOptions, Collection<AutoCloseable> handlesToClose) {
                return currentOptions;
            }

            public ColumnFamilyOptions createColumnOptions(ColumnFamilyOptions currentOptions, Collection<AutoCloseable> handlesToClose) {
                return currentOptions.setCompactionStyle(CompactionStyle.FIFO);
            }
        });
        optionsContainer = rocksDbBackend.createOptionsAndResourceContainer(null);
        try {
            ColumnFamilyOptions colCreated = optionsContainer.getColumnOptions();
            Assert.assertEquals((Object)CompactionStyle.FIFO, (Object)colCreated.compactionStyle());
        }
        finally {
            if (optionsContainer != null) {
                optionsContainer.close();
            }
        }
    }

    @Test
    public void testPredefinedAndConfigurableOptions() throws Exception {
        ColumnFamilyOptions columnFamilyOptions;
        Configuration configuration = new Configuration();
        configuration.set(RocksDBConfigurableOptions.COMPACTION_STYLE, (Object)CompactionStyle.UNIVERSAL);
        try (RocksDBResourceContainer optionsContainer = new RocksDBResourceContainer((ReadableConfig)configuration, PredefinedOptions.SPINNING_DISK_OPTIMIZED, null, null, null, false);){
            columnFamilyOptions = optionsContainer.getColumnOptions();
            Assert.assertNotNull((Object)columnFamilyOptions);
            Assert.assertEquals((Object)CompactionStyle.UNIVERSAL, (Object)columnFamilyOptions.compactionStyle());
        }
        optionsContainer = new RocksDBResourceContainer((ReadableConfig)new Configuration(), PredefinedOptions.SPINNING_DISK_OPTIMIZED, null, null, null, false);
        try {
            columnFamilyOptions = optionsContainer.getColumnOptions();
            Assert.assertNotNull((Object)columnFamilyOptions);
            Assert.assertEquals((Object)CompactionStyle.LEVEL, (Object)columnFamilyOptions.compactionStyle());
        }
        finally {
            optionsContainer.close();
        }
    }

    @Test
    public void testPredefinedAndOptionsFactory() throws Exception {
        RocksDBOptionsFactory optionsFactory = new RocksDBOptionsFactory(){

            public DBOptions createDBOptions(DBOptions currentOptions, Collection<AutoCloseable> handlesToClose) {
                return currentOptions;
            }

            public ColumnFamilyOptions createColumnOptions(ColumnFamilyOptions currentOptions, Collection<AutoCloseable> handlesToClose) {
                return currentOptions.setCompactionStyle(CompactionStyle.UNIVERSAL);
            }
        };
        try (RocksDBResourceContainer optionsContainer = new RocksDBResourceContainer(PredefinedOptions.SPINNING_DISK_OPTIMIZED, optionsFactory);){
            ColumnFamilyOptions columnFamilyOptions = optionsContainer.getColumnOptions();
            Assert.assertNotNull((Object)columnFamilyOptions);
            Assert.assertEquals((Object)CompactionStyle.UNIVERSAL, (Object)columnFamilyOptions.compactionStyle());
        }
    }

    @Test
    public void testDefaultMemoryControlParameters() {
        RocksDBMemoryConfiguration memSettings = new RocksDBMemoryConfiguration();
        Assert.assertTrue((boolean)memSettings.isUsingManagedMemory());
        Assert.assertFalse((boolean)memSettings.isUsingFixedMemoryPerSlot());
        Assert.assertEquals((double)((Double)RocksDBOptions.HIGH_PRIORITY_POOL_RATIO.defaultValue()), (double)memSettings.getHighPriorityPoolRatio(), (double)0.0);
        Assert.assertEquals((double)((Double)RocksDBOptions.WRITE_BUFFER_RATIO.defaultValue()), (double)memSettings.getWriteBufferRatio(), (double)0.0);
        RocksDBMemoryConfiguration configured = RocksDBMemoryConfiguration.fromOtherAndConfiguration((RocksDBMemoryConfiguration)memSettings, (ReadableConfig)new Configuration());
        Assert.assertTrue((boolean)configured.isUsingManagedMemory());
        Assert.assertFalse((boolean)configured.isUsingFixedMemoryPerSlot());
        Assert.assertEquals((double)((Double)RocksDBOptions.HIGH_PRIORITY_POOL_RATIO.defaultValue()), (double)configured.getHighPriorityPoolRatio(), (double)0.0);
        Assert.assertEquals((double)((Double)RocksDBOptions.WRITE_BUFFER_RATIO.defaultValue()), (double)configured.getWriteBufferRatio(), (double)0.0);
    }

    @Test
    public void testConfigureManagedMemory() {
        Configuration config = new Configuration();
        config.set(RocksDBOptions.USE_MANAGED_MEMORY, (Object)true);
        RocksDBMemoryConfiguration memSettings = RocksDBMemoryConfiguration.fromOtherAndConfiguration((RocksDBMemoryConfiguration)new RocksDBMemoryConfiguration(), (ReadableConfig)config);
        Assert.assertTrue((boolean)memSettings.isUsingManagedMemory());
    }

    @Test
    public void testConfigureIllegalMemoryControlParameters() {
        RocksDBMemoryConfiguration memSettings = new RocksDBMemoryConfiguration();
        this.verifySetParameter(() -> memSettings.setFixedMemoryPerSlot("-1B"));
        this.verifySetParameter(() -> memSettings.setHighPriorityPoolRatio(-0.1));
        this.verifySetParameter(() -> memSettings.setHighPriorityPoolRatio(1.1));
        this.verifySetParameter(() -> memSettings.setWriteBufferRatio(-0.1));
        this.verifySetParameter(() -> memSettings.setWriteBufferRatio(1.1));
        memSettings.setFixedMemoryPerSlot("128MB");
        memSettings.setWriteBufferRatio(0.6);
        memSettings.setHighPriorityPoolRatio(0.6);
        try {
            memSettings.validate();
            Assert.fail((String)"Expected an IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testDefaultRestoreOverlapThreshold() {
        EmbeddedRocksDBStateBackend rocksDBStateBackend = new EmbeddedRocksDBStateBackend(true);
        Assert.assertTrue((((Double)RocksDBConfigurableOptions.RESTORE_OVERLAP_FRACTION_THRESHOLD.defaultValue()).doubleValue() == rocksDBStateBackend.getOverlapFractionThreshold() ? 1 : 0) != 0);
    }

    @Test
    public void testConfigureRestoreOverlapThreshold() {
        EmbeddedRocksDBStateBackend rocksDBStateBackend = new EmbeddedRocksDBStateBackend(true);
        Configuration configuration = new Configuration();
        configuration.set(RocksDBConfigurableOptions.RESTORE_OVERLAP_FRACTION_THRESHOLD, (Object)0.3);
        rocksDBStateBackend = rocksDBStateBackend.configure((ReadableConfig)configuration, this.getClass().getClassLoader());
        Assert.assertTrue((0.3 == rocksDBStateBackend.getOverlapFractionThreshold() ? 1 : 0) != 0);
    }

    @Test
    public void testDefaultUseIngestDB() {
        EmbeddedRocksDBStateBackend rocksDBStateBackend = new EmbeddedRocksDBStateBackend(true);
        Assert.assertEquals((Object)RocksDBConfigurableOptions.USE_INGEST_DB_RESTORE_MODE.defaultValue(), (Object)rocksDBStateBackend.getUseIngestDbRestoreMode());
    }

    @Test
    public void testConfigureUseIngestDB() {
        EmbeddedRocksDBStateBackend rocksDBStateBackend = new EmbeddedRocksDBStateBackend(true);
        Configuration configuration = new Configuration();
        configuration.set(RocksDBConfigurableOptions.USE_INGEST_DB_RESTORE_MODE, (Object)true);
        rocksDBStateBackend = rocksDBStateBackend.configure((ReadableConfig)configuration, this.getClass().getClassLoader());
        Assert.assertTrue((boolean)rocksDBStateBackend.getUseIngestDbRestoreMode());
    }

    @Test
    public void testDefaultUseDeleteFilesInRange() {
        EmbeddedRocksDBStateBackend rocksDBStateBackend = new EmbeddedRocksDBStateBackend(true);
        Assert.assertEquals((Object)RocksDBConfigurableOptions.USE_DELETE_FILES_IN_RANGE_DURING_RESCALING.defaultValue(), (Object)rocksDBStateBackend.isRescalingUseDeleteFilesInRange());
    }

    @Test
    public void testConfigureUseFilesInRange() {
        EmbeddedRocksDBStateBackend rocksDBStateBackend = new EmbeddedRocksDBStateBackend(true);
        Configuration configuration = new Configuration();
        configuration.set(RocksDBConfigurableOptions.USE_DELETE_FILES_IN_RANGE_DURING_RESCALING, (Object)((Boolean)RocksDBConfigurableOptions.USE_DELETE_FILES_IN_RANGE_DURING_RESCALING.defaultValue() == false ? 1 : 0));
        rocksDBStateBackend = rocksDBStateBackend.configure((ReadableConfig)configuration, this.getClass().getClassLoader());
        Assert.assertEquals((Object)((Boolean)RocksDBConfigurableOptions.USE_DELETE_FILES_IN_RANGE_DURING_RESCALING.defaultValue() == false ? 1 : 0), (Object)rocksDBStateBackend.isRescalingUseDeleteFilesInRange());
    }

    @Test
    public void testDefaultIncrementalRestoreInstanceBufferSize() {
        EmbeddedRocksDBStateBackend rocksDBStateBackend = new EmbeddedRocksDBStateBackend(true);
        Assert.assertEquals((Object)RocksDBConfigurableOptions.INCREMENTAL_RESTORE_ASYNC_COMPACT_AFTER_RESCALE.defaultValue(), (Object)rocksDBStateBackend.getIncrementalRestoreAsyncCompactAfterRescale());
    }

    @Test
    public void testConfigureIncrementalRestoreInstanceBufferSize() {
        EmbeddedRocksDBStateBackend rocksDBStateBackend = new EmbeddedRocksDBStateBackend(true);
        Configuration configuration = new Configuration();
        boolean notDefault = (Boolean)RocksDBConfigurableOptions.INCREMENTAL_RESTORE_ASYNC_COMPACT_AFTER_RESCALE.defaultValue() == false;
        configuration.set(RocksDBConfigurableOptions.INCREMENTAL_RESTORE_ASYNC_COMPACT_AFTER_RESCALE, (Object)notDefault);
        rocksDBStateBackend = rocksDBStateBackend.configure((ReadableConfig)configuration, this.getClass().getClassLoader());
        Assert.assertEquals((Object)notDefault, (Object)rocksDBStateBackend.getIncrementalRestoreAsyncCompactAfterRescale());
    }

    @Test
    public void testConfigurePeriodicCompactionTime() throws Exception {
        EmbeddedRocksDBStateBackend rocksDBStateBackend = new EmbeddedRocksDBStateBackend(true);
        Configuration configuration = new Configuration();
        configuration.setString(RocksDBConfigurableOptions.COMPACT_FILTER_PERIODIC_COMPACTION_TIME.key(), "1d");
        rocksDBStateBackend = rocksDBStateBackend.configure((ReadableConfig)configuration, this.getClass().getClassLoader());
        try (RocksDBResourceContainer resourceContainer = rocksDBStateBackend.createOptionsAndResourceContainer(null);){
            Assert.assertEquals((Object)Duration.ofDays(1L), (Object)resourceContainer.getPeriodicCompactionTime());
        }
    }

    @Test
    public void testConfigureQueryTimeAfterNumEntries() throws Exception {
        EmbeddedRocksDBStateBackend rocksDBStateBackend = new EmbeddedRocksDBStateBackend(true);
        Configuration configuration = new Configuration();
        configuration.setString(RocksDBConfigurableOptions.COMPACT_FILTER_QUERY_TIME_AFTER_NUM_ENTRIES.key(), "100");
        rocksDBStateBackend = rocksDBStateBackend.configure((ReadableConfig)configuration, this.getClass().getClassLoader());
        try (RocksDBResourceContainer resourceContainer = rocksDBStateBackend.createOptionsAndResourceContainer(null);){
            Assert.assertEquals((long)100L, (long)resourceContainer.getQueryTimeAfterNumEntries());
        }
    }

    private void verifySetParameter(Runnable setter) {
        try {
            setter.run();
            Assert.fail((String)"No expected IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    static MockEnvironment getMockEnvironment(File tempDir) {
        return MockEnvironment.builder().setUserCodeClassLoader(RocksDBStateBackendConfigTest.class.getClassLoader()).setTaskManagerRuntimeInfo((TaskManagerRuntimeInfo)new TestingTaskManagerRuntimeInfo(new Configuration(), tempDir)).build();
    }

    private void verifyIllegalArgument(ConfigOption<?> configOption, String configValue) {
        Configuration configuration = new Configuration();
        configuration.setString(configOption.key(), configValue);
        EmbeddedRocksDBStateBackend stateBackend = new EmbeddedRocksDBStateBackend();
        try {
            stateBackend.configure((ReadableConfig)configuration, null);
            Assert.fail((String)"Not throwing expected IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static class TestOptionsFactory
    implements ConfigurableRocksDBOptionsFactory {
        public static final ConfigOption<Integer> BACKGROUND_JOBS_OPTION = ConfigOptions.key((String)"my.custom.rocksdb.backgroundJobs").intType().defaultValue((Object)2);
        private int backgroundJobs = (Integer)BACKGROUND_JOBS_OPTION.defaultValue();

        public DBOptions createDBOptions(DBOptions currentOptions, Collection<AutoCloseable> handlesToClose) {
            return currentOptions.setMaxBackgroundJobs(this.backgroundJobs);
        }

        public ColumnFamilyOptions createColumnOptions(ColumnFamilyOptions currentOptions, Collection<AutoCloseable> handlesToClose) {
            return currentOptions.setCompactionStyle(CompactionStyle.UNIVERSAL);
        }

        public RocksDBOptionsFactory configure(ReadableConfig configuration) {
            this.backgroundJobs = (Integer)configuration.get(BACKGROUND_JOBS_OPTION);
            return this;
        }
    }
}

