/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.table;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.utils.TypeUtils;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.state.api.OperatorIdentifier;
import org.apache.flink.state.table.SavepointConnectorOptions;
import org.apache.flink.state.table.SavepointConnectorOptionsUtil;
import org.apache.flink.state.table.SavepointDynamicTableSource;
import org.apache.flink.state.table.SavepointTypeInformationFactory;
import org.apache.flink.state.table.StateValueColumnConfiguration;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.util.Preconditions;

public class SavepointDynamicTableSourceFactory
implements DynamicTableSourceFactory {
    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        Configuration options = new Configuration();
        context.getCatalogTable().getOptions().forEach((arg_0, arg_1) -> ((Configuration)options).setString(arg_0, arg_1));
        String stateBackendType = options.getOptional(SavepointConnectorOptions.STATE_BACKEND_TYPE).orElse(null);
        String statePath = (String)options.get(SavepointConnectorOptions.STATE_PATH);
        OperatorIdentifier operatorIdentifier = SavepointConnectorOptionsUtil.getOperatorIdentifier((ReadableConfig)options);
        Tuple2<Integer, int[]> keyValueProjections = this.createKeyValueProjections(context.getCatalogTable());
        LogicalType logicalType = context.getPhysicalRowDataType().getLogicalType();
        Preconditions.checkArgument((boolean)logicalType.is(LogicalTypeRoot.ROW), (Object)"Row data type expected.");
        RowType rowType = (RowType)logicalType;
        HashSet requiredOptions = new HashSet(this.requiredOptions());
        HashSet optionalOptions = new HashSet(this.optionalOptions());
        RowType.RowField keyRowField = (RowType.RowField)rowType.getFields().get((Integer)keyValueProjections.f0);
        ConfigOption keyFormatOption = ConfigOptions.key((String)String.format("%s.%s.%s", "fields", keyRowField.getName(), "value-class")).stringType().noDefaultValue();
        optionalOptions.add(keyFormatOption);
        ConfigOption keyTypeInfoFactoryOption = ConfigOptions.key((String)String.format("%s.%s.%s", "fields", keyRowField.getName(), "value-type-factory")).stringType().noDefaultValue();
        optionalOptions.add(keyTypeInfoFactoryOption);
        TypeInformation<?> keyTypeInfo = this.getTypeInfo(options, (ConfigOption<String>)keyFormatOption, (ConfigOption<String>)keyTypeInfoFactoryOption, keyRowField, true);
        Tuple2 keyValueConfigProjections = Tuple2.of((Object)((Integer)keyValueProjections.f0), Arrays.stream((int[])keyValueProjections.f1).mapToObj(columnIndex -> {
            RowType.RowField valueRowField = (RowType.RowField)rowType.getFields().get(columnIndex);
            ConfigOption stateNameOption = ConfigOptions.key((String)String.format("%s.%s.%s", "fields", valueRowField.getName(), "state-name")).stringType().noDefaultValue();
            optionalOptions.add(stateNameOption);
            ConfigOption stateTypeOption = ConfigOptions.key((String)String.format("%s.%s.%s", "fields", valueRowField.getName(), "state-type")).enumType(SavepointConnectorOptions.StateType.class).noDefaultValue();
            optionalOptions.add(stateTypeOption);
            ConfigOption mapKeyFormatOption = ConfigOptions.key((String)String.format("%s.%s.%s", "fields", valueRowField.getName(), "key-class")).stringType().noDefaultValue();
            optionalOptions.add(mapKeyFormatOption);
            ConfigOption mapKeyTypeInfoFactoryOption = ConfigOptions.key((String)String.format("%s.%s.%s", "fields", valueRowField.getName(), "key-type-factory")).stringType().noDefaultValue();
            optionalOptions.add(mapKeyTypeInfoFactoryOption);
            ConfigOption valueFormatOption = ConfigOptions.key((String)String.format("%s.%s.%s", "fields", valueRowField.getName(), "value-class")).stringType().noDefaultValue();
            optionalOptions.add(valueFormatOption);
            ConfigOption valueTypeInfoFactoryOption = ConfigOptions.key((String)String.format("%s.%s.%s", "fields", valueRowField.getName(), "value-type-factory")).stringType().noDefaultValue();
            optionalOptions.add(valueTypeInfoFactoryOption);
            LogicalType valueLogicalType = valueRowField.getType();
            SavepointConnectorOptions.StateType stateType = options.getOptional(stateTypeOption).orElseGet(() -> this.inferStateType(valueLogicalType));
            TypeInformation<?> mapKeyTypeInfo = this.getTypeInfo(options, (ConfigOption<String>)keyFormatOption, (ConfigOption<String>)mapKeyTypeInfoFactoryOption, valueRowField, stateType.equals((Object)SavepointConnectorOptions.StateType.MAP));
            TypeInformation<?> valueTypeInfo = this.getTypeInfo(options, (ConfigOption<String>)valueFormatOption, (ConfigOption<String>)valueTypeInfoFactoryOption, valueRowField, true);
            return new StateValueColumnConfiguration(columnIndex, options.getOptional(stateNameOption).orElse(valueRowField.getName()), stateType, mapKeyTypeInfo, valueTypeInfo);
        }).collect(Collectors.toList()));
        FactoryUtil.validateFactoryOptions(requiredOptions, optionalOptions, (ReadableConfig)options);
        HashSet<String> consumedOptionKeys = new HashSet<String>();
        consumedOptionKeys.add(FactoryUtil.CONNECTOR.key());
        requiredOptions.stream().map(ConfigOption::key).forEach(consumedOptionKeys::add);
        optionalOptions.stream().map(ConfigOption::key).forEach(consumedOptionKeys::add);
        FactoryUtil.validateUnconsumedKeys((String)this.factoryIdentifier(), (Set)options.keySet(), consumedOptionKeys);
        return new SavepointDynamicTableSource(stateBackendType, statePath, operatorIdentifier, keyTypeInfo, (Tuple2<Integer, List<StateValueColumnConfiguration>>)keyValueConfigProjections, rowType);
    }

    private Tuple2<Integer, int[]> createKeyValueProjections(ResolvedCatalogTable catalogTable) {
        ResolvedSchema schema = catalogTable.getResolvedSchema();
        if (schema.getPrimaryKey().isEmpty()) {
            throw new ValidationException("Could not find the primary key in the table schema.");
        }
        List keyFields = ((UniqueConstraint)schema.getPrimaryKey().get()).getColumns();
        if (keyFields.size() != 1) {
            throw new ValidationException("Only a single primary key must be defined in the table schema.");
        }
        DataType physicalDataType = schema.toPhysicalRowDataType();
        int keyProjection = this.createKeyFormatProjection(physicalDataType, (String)keyFields.get(0));
        int[] valueProjection = this.createValueFormatProjection(physicalDataType, keyProjection);
        return Tuple2.of((Object)keyProjection, (Object)valueProjection);
    }

    private int createKeyFormatProjection(DataType physicalDataType, String keyField) {
        LogicalType physicalType = physicalDataType.getLogicalType();
        Preconditions.checkArgument((boolean)physicalType.is(LogicalTypeRoot.ROW), (Object)"Row data type expected.");
        List physicalFields = LogicalTypeChecks.getFieldNames((LogicalType)physicalType);
        return physicalFields.indexOf(keyField);
    }

    private int[] createValueFormatProjection(DataType physicalDataType, int keyProjection) {
        LogicalType physicalType = physicalDataType.getLogicalType();
        Preconditions.checkArgument((boolean)physicalType.is(LogicalTypeRoot.ROW), (Object)"Row data type expected.");
        int physicalFieldCount = LogicalTypeChecks.getFieldCount((LogicalType)physicalType);
        IntStream physicalFields = IntStream.range(0, physicalFieldCount);
        return physicalFields.filter(pos -> keyProjection != pos).toArray();
    }

    private TypeInformation<?> getTypeInfo(Configuration options, ConfigOption<String> classOption, ConfigOption<String> typeInfoFactoryOption, RowType.RowField rowField, boolean inferStateType) {
        Optional clazz = options.getOptional(classOption);
        Optional typeInfoFactory = options.getOptional(typeInfoFactoryOption);
        if (clazz.isPresent() && typeInfoFactory.isPresent()) {
            throw new IllegalArgumentException("Either " + classOption.key() + " or " + typeInfoFactoryOption.key() + " can be specified for column " + rowField.getName() + ".");
        }
        try {
            if (clazz.isPresent()) {
                return TypeInformation.of(Class.forName((String)clazz.get()));
            }
            if (typeInfoFactory.isPresent()) {
                SavepointTypeInformationFactory savepointTypeInformationFactory = (SavepointTypeInformationFactory)TypeUtils.getInstance((String)((String)typeInfoFactory.get()), (Object[])new Object[0]);
                return savepointTypeInformationFactory.getTypeInformation();
            }
            if (inferStateType) {
                String inferredValueFormat = this.inferStateValueFormat(rowField.getName(), rowField.getType());
                return TypeInformation.of(Class.forName(inferredValueFormat));
            }
            return null;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private SavepointConnectorOptions.StateType inferStateType(LogicalType logicalType) {
        switch (logicalType.getTypeRoot()) {
            case ARRAY: {
                return SavepointConnectorOptions.StateType.LIST;
            }
            case MAP: {
                return SavepointConnectorOptions.StateType.MAP;
            }
        }
        return SavepointConnectorOptions.StateType.VALUE;
    }

    @Nullable
    private String inferStateMapKeyFormat(String columnName, LogicalType logicalType) {
        return logicalType.is(LogicalTypeRoot.MAP) ? this.inferStateValueFormat(columnName, ((MapType)logicalType).getKeyType()) : null;
    }

    private String inferStateValueFormat(String columnName, LogicalType logicalType) {
        switch (logicalType.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                return String.class.getName();
            }
            case BOOLEAN: {
                return Boolean.class.getName();
            }
            case BINARY: 
            case VARBINARY: {
                return byte[].class.getName();
            }
            case DECIMAL: {
                return BigDecimal.class.getName();
            }
            case TINYINT: {
                return Byte.class.getName();
            }
            case SMALLINT: {
                return Short.class.getName();
            }
            case INTEGER: {
                return Integer.class.getName();
            }
            case BIGINT: {
                return Long.class.getName();
            }
            case FLOAT: {
                return Float.class.getName();
            }
            case DOUBLE: {
                return Double.class.getName();
            }
            case DATE: {
                return Integer.class.getName();
            }
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_DAY_TIME: {
                return Long.class.getName();
            }
            case ARRAY: {
                return this.inferStateValueFormat(columnName, ((ArrayType)logicalType).getElementType());
            }
            case MAP: {
                return this.inferStateValueFormat(columnName, ((MapType)logicalType).getValueType());
            }
            case NULL: {
                return null;
            }
        }
        throw new UnsupportedOperationException(String.format("Unable to infer state format for SQL type: %s in column: %s. Please override the type with the following config parameter: %s.%s.%s", logicalType, columnName, "fields", columnName, "value-class"));
    }

    public String factoryIdentifier() {
        return "savepoint";
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(SavepointConnectorOptions.STATE_PATH);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(SavepointConnectorOptions.STATE_BACKEND_TYPE);
        options.add(SavepointConnectorOptions.OPERATOR_UID);
        options.add(SavepointConnectorOptions.OPERATOR_UID_HASH);
        options.add(SavepointConnectorOptions.STATE_NAME_PLACEHOLDER);
        options.add(SavepointConnectorOptions.STATE_TYPE_PLACEHOLDER);
        options.add(SavepointConnectorOptions.KEY_CLASS_PLACEHOLDER);
        options.add(SavepointConnectorOptions.KEY_TYPE_INFO_FACTORY_PLACEHOLDER);
        options.add(SavepointConnectorOptions.VALUE_CLASS_PLACEHOLDER);
        options.add(SavepointConnectorOptions.VALUE_TYPE_INFO_FACTORY_PLACEHOLDER);
        return options;
    }
}

